/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.inventory;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1799;

public class NPCInventoryImpl
extends class_1277 {
    public static final int MAX_SIZE = 24;
    public static final int HEAD = 18;
    public static final int CHEST = 19;
    public static final int LEGS = 20;
    public static final int FEET = 21;
    public static final int MAIN_HAND = 22;
    public static final int OFF_HAND = 23;

    public NPCInventoryImpl(int size) {
        super(size);
        this.init();
    }

    public NPCInventoryImpl(class_1799 ... items) {
        super(items);
        this.init();
    }

    protected void init() {
    }

    public class_1799 getHand(class_1268 hand) {
        if (hand == class_1268.field_5808) {
            return this.getMainHand();
        }
        if (hand == class_1268.field_5810) {
            return this.getOffHand();
        }
        return class_1799.field_8037;
    }

    public class_1799 getMainHand() {
        return this.method_5438(22);
    }

    public class_1799 getOffHand() {
        return this.method_5438(23);
    }

    public class_1799 getHead() {
        return this.method_5438(18);
    }

    public class_1799 getChest() {
        return this.method_5438(19);
    }

    public class_1799 getLegs() {
        return this.method_5438(20);
    }

    public class_1799 getFeet() {
        return this.method_5438(21);
    }

    public void setHand(class_1268 hand, class_1799 stack) {
        if (hand == class_1268.field_5808) {
            this.setMainHand(stack);
        } else if (hand == class_1268.field_5810) {
            this.setOffHand(stack);
        }
    }

    public void setMainHand(class_1799 stack) {
        this.method_5447(22, stack.method_7972());
    }

    public void setOffHand(class_1799 stack) {
        this.method_5447(23, stack.method_7972());
    }

    public void setHead(class_1799 stack) {
        this.method_5447(18, stack.method_7972());
    }

    public void setChest(class_1799 stack) {
        this.method_5447(19, stack.method_7972());
    }

    public void setLegs(class_1799 stack) {
        this.method_5447(20, stack.method_7972());
    }

    public void setFeet(class_1799 stack) {
        this.method_5447(21, stack.method_7972());
    }

    public boolean isArmorSlot(int slot) {
        return 18 == slot || 19 == slot || 20 == slot || 21 == slot;
    }

    public boolean method_27070(class_1799 stack) {
        return super.method_27070(stack);
    }

    public int insertStack(class_1799 stack) {
        if (stack.method_7960()) {
            return 0;
        }
        int remaining = stack.method_7947();
        int inserted = 0;
        for (int i = 0; i < this.field_5828.size(); ++i) {
            if (this.isArmorSlot(i)) continue;
            class_1799 slot = (class_1799)this.field_5828.get(i);
            if (slot.method_7960()) {
                int toInsert = Math.min(remaining, stack.method_7914());
                this.field_5828.set(i, (Object)stack.method_7972());
                ((class_1799)this.field_5828.get(i)).method_7939(toInsert);
                inserted += toInsert;
                remaining -= toInsert;
            } else if (class_1799.method_31577((class_1799)slot, (class_1799)stack) && slot.method_7947() < slot.method_7914()) {
                int space = slot.method_7914() - slot.method_7947();
                int toInsert = Math.min(remaining, space);
                slot.method_7933(toInsert);
                inserted += toInsert;
                remaining -= toInsert;
            }
            if (remaining <= 0) break;
        }
        stack.method_7934(inserted);
        return inserted;
    }

    @Nonnull
    public List<Integer> findItemSlots(int maxLength, Predicate<class_1799> isGood, Predicate<Integer> isExcludeIndex) {
        LinkedList<Integer> itemSlots = new LinkedList<Integer>();
        for (int i = 23; i >= 0 && itemSlots.size() < maxLength; --i) {
            class_1799 stack = this.method_5438(i);
            if (stack.method_7960() || isExcludeIndex.test(i) || !isGood.test(stack)) continue;
            itemSlots.add(i);
        }
        return itemSlots;
    }

    public Integer findSlot(Predicate<class_1799> isGood) {
        List<Integer> slots = this.findItemSlots(1, isGood, i -> i >= 18 && i <= 21);
        return slots.isEmpty() ? null : slots.getFirst();
    }

    public Integer findHand(Predicate<class_1799> isGood) {
        return isGood.test(this.method_5438(23)) ? Integer.valueOf(23) : (isGood.test(this.method_5438(22)) ? Integer.valueOf(22) : null);
    }
}

