/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.item.prop;

import cc.thonly.reverie_dreams.component.GapRecorder;
import cc.thonly.reverie_dreams.component.ModDataComponentTypes;
import cc.thonly.reverie_dreams.item.ModGuiItems;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2709;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class GapBall
extends class_1792 {
    public GapBall(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        if (!world.method_8608() && user instanceof class_3222) {
            class_3222 serverPlayerEntity = (class_3222)user;
            GapGUI gapGui = new GapGUI(serverPlayerEntity, stack);
            gapGui.open();
            return class_1269.field_52422;
        }
        return class_1269.field_5812;
    }

    public static class GapGUI
    extends SimpleGui {
        public static final String[][] GRID = new String[][]{{"X", "X", "I", "I", "I", "I", "I", "X", "X"}, {"X", "X", "A", "A", "A", "A", "A", "X", "X"}, {"X", "X", "D", "D", "D", "D", "D", "X", "X"}};
        public static final int MAX_INDEX = 4;
        public static final int MIN_INDEX = 0;
        private final class_1799 stack;
        private List<GapRecorder> gapRecorders;

        public GapGUI(class_3222 player, class_1799 stack) {
            super(class_3917.field_17326, player, false);
            this.stack = stack;
            this.gapRecorders = new ArrayList<GapRecorder>((Collection)stack.method_58695(ModDataComponentTypes.GAP_RECORDER, new ArrayList()));
            while (this.gapRecorders.size() <= 4) {
                this.gapRecorders.add(new GapRecorder("\u672a\u8bb0\u5f55", this.getPlayer().method_51469().method_27983().method_29177().toString(), class_2338.field_10980, false));
            }
            this.init();
        }

        public void init() {
            class_2561 text = this.stack.method_65130() != null ? this.stack.method_65130() : this.stack.method_7964();
            this.setTitle(text);
            for (int row = 0; row < GRID.length; ++row) {
                block13: for (int col = 0; col < GRID[row].length; ++col) {
                    String pos = GRID[row][col];
                    int slot = row * 9 + col;
                    int index = col - 2;
                    switch (pos) {
                        case "X": {
                            this.setSlot(slot, (GuiElementBuilderInterface)new GuiElementBuilder(ModGuiItems.EMPTY_SLOT));
                            continue block13;
                        }
                        case "I": {
                            if (index < 0 || index > 4) continue block13;
                            GapRecorder recorder = this.gapRecorders.get(index);
                            this.setSlot(slot, new GuiElementBuilder(recorder.isEnable() ? class_1802.field_8077 : class_1802.field_8449).setName((class_2561)class_2561.method_43470((String)("\u4f20\u9001" + index))).setCallback(click -> this.teleport(index)));
                            continue block13;
                        }
                        case "A": {
                            if (index < 0 || index > 4) continue block13;
                            this.setSlot(slot, new GuiElementBuilder(class_1802.field_8733).setName((class_2561)class_2561.method_43470((String)("\u8bb0\u5f55 " + index))).setCallback(click -> this.add(index)));
                            continue block13;
                        }
                        case "D": {
                            if (index < 0 || index > 4) continue block13;
                            this.setSlot(slot, new GuiElementBuilder(class_1802.field_8793).setName((class_2561)class_2561.method_43470((String)("\u5220\u9664 " + index))).setCallback(click -> this.delete(index)));
                        }
                    }
                }
            }
        }

        public void onTick() {
            super.onTick();
            this.gapRecorders = new ArrayList<GapRecorder>((Collection)this.stack.method_58695(ModDataComponentTypes.GAP_RECORDER, new ArrayList()));
            while (this.gapRecorders.size() <= 4) {
                this.gapRecorders.add(new GapRecorder("\u672a\u8bb0\u5f55", this.getPlayer().method_51469().method_27983().method_29177().toString(), class_2338.field_10980, false));
            }
            this.updateTeleportSlots();
        }

        private void updateTeleportSlots() {
            for (int col = 2; col <= 6; ++col) {
                int index = col - 2;
                int slot = 0 + col;
                GapRecorder recorder = this.gapRecorders.get(index);
                boolean hasTarget = recorder != null && recorder.isEnable();
                class_1792 item = hasTarget ? class_1802.field_8449 : class_1802.field_8077;
                this.setSlot(slot, new GuiElementBuilder(item).setName((class_2561)class_2561.method_43470((String)("\u4f20\u9001 " + index + (String)(hasTarget ? " - " + recorder.getName() : "\uff08\u672a\u8bb0\u5f55\uff09")))).setLore(List.of(class_2561.method_43470((String)("\u4e16\u754c\uff1a" + recorder.getWorld())), class_2561.method_43470((String)("\u4e16\u754c\uff1a" + recorder.getValue().method_10263() + " " + recorder.getValue().method_10264() + " " + recorder.getValue().method_10260())))).setCallback(click -> this.teleport(index)));
            }
        }

        public void teleport(int index) {
            GapRecorder recorder = this.gapRecorders.get(index);
            this.player.method_17356((class_3414)class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
            if (recorder != null && recorder.isEnable()) {
                class_2960 id;
                class_5321 worldKey;
                class_2338 pos = recorder.getValue();
                MinecraftServer server = this.player.method_5682();
                class_3218 targetWorld = server.method_3847(worldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)(id = class_2960.method_60654((String)recorder.getWorld()))));
                if (targetWorld == null) {
                    this.player.method_7353((class_2561)class_2561.method_43470((String)("\u76ee\u6807\u4e16\u754c\u4e0d\u5b58\u5728: " + String.valueOf(id))), false);
                    return;
                }
                this.player.method_48105(targetWorld, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, EnumSet.noneOf(class_2709.class), this.player.method_36454(), this.player.method_36455(), true);
                this.player.method_7353((class_2561)class_2561.method_43470((String)("\u5df2\u4f20\u9001\u81f3\uff1a" + recorder.getName())), false);
                this.player.method_17356(class_3417.field_14890, class_3419.field_15248, 1.0f, 1.0f);
                this.player.method_7357().method_62835(this.stack, 60);
                this.close();
            } else {
                this.player.method_7353((class_2561)class_2561.method_43470((String)"\u76ee\u6807\u4f4d\u7f6e\u4e0d\u5b58\u5728\u3002"), false);
            }
        }

        public void add(int index) {
            class_2338 pos = this.player.method_24515();
            GapRecorder recorder = new GapRecorder("\u4f4d\u7f6e " + index, this.getPlayer().method_51469().method_27983().method_29177().toString(), pos, true);
            this.player.method_17356((class_3414)class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
            this.gapRecorders.set(index, recorder);
            this.stack.method_57379(ModDataComponentTypes.GAP_RECORDER, this.gapRecorders);
            this.player.method_7353((class_2561)class_2561.method_43470((String)("\u5df2\u8bb0\u5f55\u5f53\u524d\u4f4d\u7f6e\u81f3\u69fd\u4f4d " + index)), false);
            this.init();
            this.stack.method_57379(ModDataComponentTypes.GAP_RECORDER, this.gapRecorders);
            this.player.method_31548().method_5431();
        }

        public void delete(int index) {
            GapRecorder recorder = this.gapRecorders.get(index);
            this.player.method_17356((class_3414)class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
            if (recorder != null) {
                recorder.setEnable(false);
                this.stack.method_57379(ModDataComponentTypes.GAP_RECORDER, this.gapRecorders);
                this.player.method_7353((class_2561)class_2561.method_43470((String)("\u5df2\u6e05\u9664\u69fd\u4f4d " + index)), false);
                this.init();
            }
            this.stack.method_57379(ModDataComponentTypes.GAP_RECORDER, this.gapRecorders);
            this.player.method_31548().method_5431();
        }

        public void onClose() {
            super.onClose();
            this.stack.method_57379(ModDataComponentTypes.GAP_RECORDER, this.gapRecorders);
            this.player.method_31548().method_5431();
        }
    }
}

