/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.registry;

import cc.thonly.reverie_dreams.registry.Key2ValueRegistryManager;
import com.sun.nio.sctp.IllegalUnbindException;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.class_2960;

public class Key2ValueRegister<K, V>
implements Serializable {
    private final class_2960 key;
    private ReloadableFactory reloadableFactory = null;
    private final Class<K> klass;
    private final Class<V> vlass;
    private final Map<Integer, V> rawToEntry;
    private final Map<K, V> keyToEntry;
    private final Map<V, K> entryToKey;

    protected Key2ValueRegister(class_2960 key, Class<K> klass, Class<V> vlass) {
        if (key == null) {
            throw new IllegalArgumentException("Registry require a key, but it is null");
        }
        if (Key2ValueRegistryManager.ROOT.containsKey(key)) {
            throw new IllegalUnbindException("Repeat the creation of the same named instance");
        }
        this.key = key;
        this.rawToEntry = new Object2ObjectLinkedOpenHashMap();
        this.keyToEntry = new Object2ObjectLinkedOpenHashMap();
        this.entryToKey = new Object2ObjectLinkedOpenHashMap();
        this.klass = klass;
        this.vlass = vlass;
        Key2ValueRegistryManager.ROOT.put(key, this);
    }

    public static <K, V> Key2ValueRegister<K, V> createRegister(class_2960 id, Class<K> klass, Class<V> vlass) {
        return new Key2ValueRegister<K, V>(id, klass, vlass);
    }

    public static <K, V> Key2ValueRegister<K, V> of(class_2960 id, Class<K> klass, Class<V> vlass) {
        return Key2ValueRegistryManager.ROOT.computeIfAbsent(id, x -> new Key2ValueRegister(id, klass, vlass));
    }

    public static <K, V> Key2ValueRegister<K, V> of(Class<K> klass, Class<V> vlass) {
        Set<Map.Entry<class_2960, Key2ValueRegister<?, ?>>> registries = Key2ValueRegistryManager.ROOT.entrySet();
        for (Map.Entry<class_2960, Key2ValueRegister<?, ?>> entry : registries) {
            Key2ValueRegister<?, ?> registry = entry.getValue();
            if (registry.klass != klass || registry.vlass != vlass) continue;
            return registry;
        }
        return new Key2ValueRegister<K, V>(class_2960.method_60654((String)(klass.getName().toLowerCase() + "_2_" + vlass.getName().toLowerCase())), klass, vlass);
    }

    public static <K, V> Key2ValueRegister<K, V> ofNullable(Class<K> klass, Class<V> vlass) {
        Set<Map.Entry<class_2960, Key2ValueRegister<?, ?>>> registries = Key2ValueRegistryManager.ROOT.entrySet();
        for (Map.Entry<class_2960, Key2ValueRegister<?, ?>> entry : registries) {
            Key2ValueRegister<?, ?> registry = entry.getValue();
            if (registry.klass != klass || registry.vlass != vlass) continue;
            return registry;
        }
        return null;
    }

    public V add(K key, V value) {
        if (this.keyToEntry.containsKey(key)) {
            throw new IllegalStateException("Duplicate key: " + String.valueOf(key));
        }
        if (this.keyToEntry.containsValue(value)) {
            throw new IllegalStateException("Duplicate value: " + String.valueOf(value));
        }
        int raw = this.rawToEntry.size();
        this.rawToEntry.put(raw, value);
        this.keyToEntry.put(key, value);
        this.entryToKey.put(value, key);
        return value;
    }

    public V get(K key) {
        return this.keyToEntry.get(key);
    }

    public K getKey(V value) {
        return this.entryToKey.get(value);
    }

    public Optional<V> getOptional(K key) {
        return Optional.ofNullable(this.get(key));
    }

    public Optional<K> getKeyOptional(V value) {
        return Optional.ofNullable(this.getKey(value));
    }

    public Stream<K> keysStream() {
        return this.keyToEntry.keySet().stream();
    }

    public Stream<V> valuesStream() {
        return this.keyToEntry.values().stream();
    }

    public Set<K> keys() {
        return Collections.unmodifiableSet(this.keyToEntry.keySet());
    }

    public Set<V> values() {
        return Set.copyOf(this.keyToEntry.values());
    }

    public Key2ValueRegister<K, V> reload(ReloadableFactory reloadableFactory) {
        this.reloadableFactory = reloadableFactory;
        return this;
    }

    public void reload() {
        if (this.reloadableFactory != null) {
            this.rawToEntry.clear();
            this.keyToEntry.clear();
            this.reloadableFactory.onReload();
        }
    }

    @Generated
    public class_2960 getKey() {
        return this.key;
    }

    @Generated
    public void setReloadableFactory(ReloadableFactory reloadableFactory) {
        this.reloadableFactory = reloadableFactory;
    }

    @Generated
    public ReloadableFactory getReloadableFactory() {
        return this.reloadableFactory;
    }

    @Generated
    public Class<K> getKlass() {
        return this.klass;
    }

    @Generated
    public Class<V> getVlass() {
        return this.vlass;
    }

    @Generated
    protected Map<Integer, V> getRawToEntry() {
        return this.rawToEntry;
    }

    @Generated
    protected Map<K, V> getKeyToEntry() {
        return this.keyToEntry;
    }

    @Generated
    protected Map<V, K> getEntryToKey() {
        return this.entryToKey;
    }

    @FunctionalInterface
    public static interface ReloadableFactory {
        public void onReload();
    }
}

