/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.authlib.properties.Property;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkinFetcherCaches {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SkinFetcherCaches.class);
    private static final Path PATH = Paths.get("config", "reverie_dreams", "skin-cached.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Codec<Map<String, Entry>> CODEC_MAP = Codec.unboundedMap((Codec)Codec.STRING, Entry.CODEC);
    public static final Map<String, Entry> MD5_CACHED = new Object2ObjectLinkedOpenHashMap();

    public static Property from(InputStream in) {
        String md5;
        if (MD5_CACHED.isEmpty()) {
            SkinFetcherCaches.load();
        }
        if ((md5 = SkinFetcherCaches.getMD5FromInputStream(in)) == null) {
            return null;
        }
        Entry entry = MD5_CACHED.get(md5);
        if (entry == null) {
            return null;
        }
        return entry.property();
    }

    public static void load() {
        try {
            if (!Files.exists(PATH.getParent(), new LinkOption[0])) {
                Files.createDirectories(PATH.getParent(), new FileAttribute[0]);
                Files.createFile(PATH, new FileAttribute[0]);
                SkinFetcherCaches.save();
            }
        }
        catch (IOException e) {
            log.error("\u521b\u5efa\u76ee\u5f55\u6216\u6587\u4ef6\u5931\u8d25: {}", (Object)PATH, (Object)e);
        }
        if (!Files.exists(PATH, new LinkOption[0])) {
            log.warn("\u7f13\u5b58\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u6b63\u5728\u521b\u5efa: {}", (Object)PATH);
            SkinFetcherCaches.save();
            return;
        }
        File file = PATH.toFile();
        try (FileInputStream in = new FileInputStream(file);){
            JsonElement element = JsonParser.parseReader((Reader)new InputStreamReader(in));
            DataResult parse = CODEC_MAP.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
            parse.result().ifPresent(map -> {
                MD5_CACHED.clear();
                MD5_CACHED.putAll((Map<String, Entry>)map);
            });
        }
        catch (Exception err) {
            log.error("\u52a0\u8f7d\u7f13\u5b58\u6587\u4ef6\u5931\u8d25", (Throwable)err);
        }
    }

    public static void save() {
        DataResult dataResult = CODEC_MAP.encodeStart((DynamicOps)JsonOps.INSTANCE, MD5_CACHED);
        dataResult.result().ifPresent(element -> {
            String json = GSON.toJson(element);
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(PATH.toFile()), StandardCharsets.UTF_8);){
                writer.write(json);
            }
            catch (IOException e) {
                log.error("\u5199\u5165\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            }
        });
    }

    public static String getMD5FromInputStream(InputStream in) {
        try {
            int bytesRead;
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[1024];
            while ((bytesRead = in.read(buffer)) != -1) {
                md.update(buffer, 0, bytesRead);
            }
            byte[] hashBytes = md.digest();
            StringBuilder hexString = new StringBuilder();
            for (byte b : hashBytes) {
                hexString.append(String.format("%02x", b));
            }
            return hexString.toString();
        }
        catch (IOException | NoSuchAlgorithmException e) {
            return null;
        }
    }

    public record Entry(Property property) {
        public static final Codec<Property> PROPERTY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(Property::name), (App)Codec.STRING.fieldOf("value").forGetter(Property::value), (App)Codec.STRING.optionalFieldOf("signature", (Object)"").forGetter(Property::signature)).apply((Applicative)instance, Property::new));
        public static final Codec<Entry> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)PROPERTY_CODEC.fieldOf("property").forGetter(Entry::property)).apply((Applicative)instance, Entry::new));
    }
}

