/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.util.fabric;

import cc.thonly.reverie_dreams.util.ConstantInfo;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import lombok.Generated;
import net.fabricmc.api.EnvType;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.metadata.ContactInformation;
import net.fabricmc.loader.api.metadata.CustomValue;
import net.fabricmc.loader.api.metadata.ModDependency;
import net.fabricmc.loader.api.metadata.ModEnvironment;
import net.fabricmc.loader.api.metadata.Person;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.fabricmc.loader.impl.discovery.ModCandidateImpl;
import net.fabricmc.loader.impl.metadata.AbstractModMetadata;
import net.fabricmc.loader.impl.metadata.EntrypointMetadata;
import net.fabricmc.loader.impl.metadata.LoaderModMetadata;
import net.fabricmc.loader.impl.metadata.NestedJarEntry;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FKMod {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FKMod.class);

    public static void addMod(String modName, String mod_id) {
        try {
            FabricLoaderInterface.addMod(FabricLoaderImpl.INSTANCE, FabricLoaderInterface.createPlain(Path.of("/", new String[0]), new V1ModMetadata(mod_id, Version.parse((String)ConstantInfo.VERSION), List.of(), ModEnvironment.UNIVERSAL, Map.of(), List.of(), List.of(), null, List.of(), false, modName, "Runtime-generated mod", List.of(), List.of(), ContactInformation.EMPTY, List.of(), V1ModMetadata.NO_ICON, Map.of(), Map.of()), false, List.of()));
        }
        catch (Exception e) {
            log.error("Error: ", (Throwable)e);
        }
    }

    static {
        FKMod.addMod("Nota", "nota");
    }

    public static final class V1ModMetadata
    extends AbstractModMetadata
    implements LoaderModMetadata {
        static final IconEntry NO_ICON = size -> Optional.empty();
        private final String id;
        private Version version;
        private final Collection<String> provides;
        private final ModEnvironment environment;
        private final Map<String, List<EntrypointMetadata>> entrypoints;
        private final Collection<NestedJarEntry> jars;
        private final Collection<MixinEntry> mixins;
        private final String accessWidener;
        private Collection<ModDependency> dependencies;
        private final boolean hasRequires;
        private final String name;
        private final String description;
        private final Collection<Person> authors;
        private final Collection<Person> contributors;
        private final ContactInformation contact;
        private final Collection<String> license;
        private final IconEntry icon;
        private final Map<String, String> languageAdapters;
        private final Map<String, CustomValue> customValues;

        public V1ModMetadata(String id, Version version, Collection<String> provides, ModEnvironment environment, Map<String, List<EntrypointMetadata>> entrypoints, Collection<NestedJarEntry> jars, Collection<MixinEntry> mixins, String accessWidener, Collection<ModDependency> dependencies, boolean hasRequires, String name, String description, Collection<Person> authors, Collection<Person> contributors, ContactInformation contact, Collection<String> license, IconEntry icon, Map<String, String> languageAdapters, Map<String, CustomValue> customValues) {
            this.id = id;
            this.version = version;
            this.provides = Collections.unmodifiableCollection(provides);
            this.environment = environment;
            this.entrypoints = Collections.unmodifiableMap(entrypoints);
            this.jars = Collections.unmodifiableCollection(jars);
            this.mixins = Collections.unmodifiableCollection(mixins);
            this.accessWidener = accessWidener;
            this.dependencies = Collections.unmodifiableCollection(dependencies);
            this.hasRequires = hasRequires;
            this.name = name;
            this.description = description != null ? description : "";
            this.authors = Collections.unmodifiableCollection(authors);
            this.contributors = Collections.unmodifiableCollection(contributors);
            this.contact = contact != null ? contact : ContactInformation.EMPTY;
            this.license = Collections.unmodifiableCollection(license);
            this.icon = icon != null ? icon : NO_ICON;
            this.languageAdapters = Collections.unmodifiableMap(languageAdapters);
            this.customValues = Collections.unmodifiableMap(customValues);
        }

        public int getSchemaVersion() {
            return 1;
        }

        public String getType() {
            return "fabric";
        }

        public String getId() {
            return this.id;
        }

        public Collection<String> getProvides() {
            return this.provides;
        }

        public Version getVersion() {
            return this.version;
        }

        public void setVersion(Version version) {
            this.version = version;
        }

        public ModEnvironment getEnvironment() {
            return this.environment;
        }

        public boolean loadsInEnvironment(EnvType type) {
            return this.environment.matches(type);
        }

        public Collection<ModDependency> getDependencies() {
            return this.dependencies;
        }

        public void setDependencies(Collection<ModDependency> dependencies) {
            this.dependencies = Collections.unmodifiableCollection(dependencies);
        }

        public String getName() {
            if (this.name == null || this.name.isEmpty()) {
                return this.id;
            }
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public Collection<Person> getAuthors() {
            return this.authors;
        }

        public Collection<Person> getContributors() {
            return this.contributors;
        }

        public ContactInformation getContact() {
            return this.contact;
        }

        public Collection<String> getLicense() {
            return this.license;
        }

        public Optional<String> getIconPath(int size) {
            return this.icon.getIconPath(size);
        }

        public Map<String, CustomValue> getCustomValues() {
            return this.customValues;
        }

        public Map<String, String> getLanguageAdapterDefinitions() {
            return this.languageAdapters;
        }

        public Collection<NestedJarEntry> getJars() {
            return this.jars;
        }

        public Collection<String> getMixinConfigs(EnvType type) {
            ArrayList<String> mixinConfigs = new ArrayList<String>();
            for (MixinEntry mixin : this.mixins) {
                if (!mixin.environment.matches(type)) continue;
                mixinConfigs.add(mixin.config);
            }
            return mixinConfigs;
        }

        public String getAccessWidener() {
            return this.accessWidener;
        }

        public Collection<String> getOldInitializers() {
            return Collections.emptyList();
        }

        public List<EntrypointMetadata> getEntrypoints(String type) {
            if (type == null) {
                return Collections.emptyList();
            }
            List<EntrypointMetadata> entrypoints = this.entrypoints.get(type);
            if (entrypoints != null) {
                return entrypoints;
            }
            return Collections.emptyList();
        }

        public Collection<String> getEntrypointKeys() {
            return this.entrypoints.keySet();
        }

        public void emitFormatWarnings() {
            if (this.hasRequires) {
                Log.warn((LogCategory)LogCategory.METADATA, (String)"Mod `%s` (%s) uses 'requires' key in fabric.mod.json, which is not supported - use 'depends'", (Object[])new Object[]{this.id, this.version});
            }
        }

        static interface IconEntry {
            public Optional<String> getIconPath(int var1);
        }

        static final class MixinEntry {
            private final String config;
            private final ModEnvironment environment;

            MixinEntry(String config, ModEnvironment environment) {
                this.config = config;
                this.environment = environment;
            }
        }

        static final class MapEntry
        implements IconEntry {
            private final SortedMap<Integer, String> icons;

            MapEntry(SortedMap<Integer, String> icons) {
                this.icons = icons;
            }

            @Override
            public Optional<String> getIconPath(int size) {
                int i;
                int iconValue = -1;
                Iterator<Integer> iterator = this.icons.keySet().iterator();
                while (iterator.hasNext() && (iconValue = (i = iterator.next().intValue())) < size) {
                }
                return Optional.of((String)this.icons.get(iconValue));
            }
        }

        static final class Single
        implements IconEntry {
            private final String icon;

            Single(String icon) {
                this.icon = icon;
            }

            @Override
            public Optional<String> getIconPath(int size) {
                return Optional.of(this.icon);
            }
        }

        static final class JarEntry
        implements NestedJarEntry {
            private final String file;

            JarEntry(String file) {
                this.file = file;
            }

            public String getFile() {
                return this.file;
            }
        }

        public static final class EntrypointMetadataImpl
        implements EntrypointMetadata {
            private final String adapter;
            private final String value;

            EntrypointMetadataImpl(String adapter, String value) {
                this.adapter = adapter;
                this.value = value;
            }

            public String getAdapter() {
                return this.adapter;
            }

            public String getValue() {
                return this.value;
            }
        }
    }

    public static class FabricLoaderInterface {
        private static final Method ADD_MOD_METHOD;
        private static final Method CREATE_PLAIN_METHOD;
        private static final Field MODS_FIELD;

        public static void addMod(FabricLoaderImpl fabricLoader, ModCandidateImpl candidate) {
            try {
                ADD_MOD_METHOD.invoke((Object)fabricLoader, candidate);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException("Failed to inject mod", e);
            }
        }

        public static ModCandidateImpl createPlain(Path path, LoaderModMetadata metadata, boolean requiresRemap, Collection<ModCandidateImpl> nestedMods) {
            try {
                return (ModCandidateImpl)CREATE_PLAIN_METHOD.invoke(null, List.of(path), metadata, requiresRemap, nestedMods);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IllegalStateException("Failed to create plain mod container", e);
            }
        }

        static {
            try {
                ADD_MOD_METHOD = FabricLoaderImpl.class.getDeclaredMethod("addMod", ModCandidateImpl.class);
                ADD_MOD_METHOD.setAccessible(true);
                MODS_FIELD = FabricLoaderImpl.class.getDeclaredField("mods");
                MODS_FIELD.setAccessible(true);
                CREATE_PLAIN_METHOD = ModCandidateImpl.class.getDeclaredMethod("createPlain", List.class, LoaderModMetadata.class, Boolean.TYPE, Collection.class);
                CREATE_PLAIN_METHOD.setAccessible(true);
            }
            catch (NoSuchFieldException | NoSuchMethodException e) {
                throw new IllegalStateException("failed to reflect addMod/createPlain/mods - fabric loader unsupported?", e);
            }
        }
    }
}

