/*
 * Decompiled with CFR 0.152.
 */
package nota.utils;

import net.minecraft.class_2766;
import net.minecraft.class_3414;
import nota.model.Sound;
import nota.utils.NoteUtils;

public class InstrumentUtils {
    public static class_3414 getInstrument(byte instrument) {
        return Sound.getFromBukkitName(InstrumentUtils.getInstrumentName(instrument));
    }

    public static String warpNameOutOfRange(byte instrument, byte key, short pitch) {
        return InstrumentUtils.warpNameOutOfRange(InstrumentUtils.getSoundNameByInstrument(instrument), key, pitch);
    }

    public static String warpNameOutOfRange(String name, byte key, short pitch) {
        if ((key = NoteUtils.applyPitchToKey(key, pitch)) < 9) {
            name = (String)name + "_-2";
        } else if (key < 33) {
            name = (String)name + "_-1";
        } else if (key >= 57) {
            if (key < 81) {
                name = (String)name + "_1";
            } else if (key < 105) {
                name = (String)name + "_2";
            }
        }
        return name;
    }

    public static String getSoundNameByInstrument(byte instrument) {
        switch (instrument) {
            case 0: {
                return "minecraft:block.note_block.harp";
            }
            case 1: {
                return "minecraft:block.note_block.bass";
            }
            case 2: {
                return "minecraft:block.note_block.basedrum";
            }
            case 3: {
                return "minecraft:block.note_block.snare";
            }
            case 4: {
                return "minecraft:block.note_block.hat";
            }
            case 5: {
                return "minecraft:block.note_block.guitar";
            }
            case 6: {
                return "minecraft:block.note_block.flute";
            }
            case 7: {
                return "minecraft:block.note_block.bell";
            }
            case 8: {
                return "minecraft:block.note_block.chime";
            }
            case 9: {
                return "minecraft:block.note_block.xylophone";
            }
            case 10: {
                return "minecraft:block.note_block.iron_xylophone";
            }
            case 11: {
                return "minecraft:block.note_block.cow_bell";
            }
            case 12: {
                return "minecraft:block.note_block.didgeridoo";
            }
            case 13: {
                return "minecraft:block.note_block.bit";
            }
            case 14: {
                return "minecraft:block.note_block.banjo";
            }
            case 15: {
                return "minecraft:block.note_block.pling";
            }
        }
        return "minecraft:block.note_block.harp";
    }

    public static String getInstrumentName(byte instrument) {
        return switch (instrument) {
            case 1 -> "BLOCK_NOTE_BLOCK_BASS";
            case 2 -> "BLOCK_NOTE_BLOCK_BASEDRUM";
            case 3 -> "BLOCK_NOTE_BLOCK_SNARE";
            case 4 -> "BLOCK_NOTE_BLOCK_HAT";
            case 5 -> "BLOCK_NOTE_BLOCK_GUITAR";
            case 6 -> "BLOCK_NOTE_BLOCK_FLUTE";
            case 7 -> "BLOCK_NOTE_BLOCK_BELL";
            case 8 -> "BLOCK_NOTE_BLOCK_CHIME";
            case 9 -> "BLOCK_NOTE_BLOCK_XYLOPHONE";
            case 10 -> "BLOCK_NOTE_BLOCK_IRON_XYLOPHONE";
            case 11 -> "BLOCK_NOTE_BLOCK_COW_BELL";
            case 12 -> "BLOCK_NOTE_BLOCK_DIDGERIDOO";
            case 13 -> "BLOCK_NOTE_BLOCK_BIT";
            case 14 -> "BLOCK_NOTE_BLOCK_BANJO";
            case 15 -> "BLOCK_NOTE_BLOCK_PLING";
            default -> "BLOCK_NOTE_BLOCK_HARP";
        };
    }

    public static class_2766 getBukkitInstrument(byte instrument) {
        return switch (instrument) {
            case 0 -> class_2766.field_12648;
            case 1 -> class_2766.field_12651;
            case 2 -> class_2766.field_12653;
            case 3 -> class_2766.field_12643;
            case 4 -> class_2766.field_12645;
            case 5 -> class_2766.field_12654;
            case 6 -> class_2766.field_12650;
            case 7 -> class_2766.field_12644;
            case 8 -> class_2766.field_12647;
            case 9 -> class_2766.field_12655;
            case 10 -> class_2766.field_18284;
            case 11 -> class_2766.field_18285;
            case 12 -> class_2766.field_18286;
            case 13 -> class_2766.field_18287;
            case 14 -> class_2766.field_18288;
            case 15 -> class_2766.field_18289;
            default -> class_2766.field_12648;
        };
    }

    public static boolean isCustomInstrument(byte instrument) {
        return instrument >= InstrumentUtils.getCustomInstrumentFirstIndex();
    }

    public static byte getCustomInstrumentFirstIndex() {
        return 16;
    }
}

