package cc.thonly.minecraft.api;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1309;
import net.minecraft.class_1799;

public interface ItemPostHitCallback {
    Event<ItemPostHitCallback> EVENT = EventFactory.createArrayBacked(
            ItemPostHitCallback.class,
            (listeners) -> (stack, target, attacker) -> {
                boolean shouldContinue = true;
                for (ItemPostHitCallback listener : listeners) {
                    shouldContinue = listener.postHit(stack, target, attacker);
                }
                return shouldContinue;
            }
    );

    boolean postHit(class_1799 stack, class_1309 target, class_1309 attacker);
}
