package cc.thonly.minecraft.mixin;

import cc.thonly.minecraft.api.ItemLeftClickCallback;
import cc.thonly.reverie_dreams.server.DelayedTask;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2846;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value = class_3244.class)
public class ServerGamePacketListenerImplMixin {
    private boolean recentAttackPacket = false;

    @Inject(method = "handlePlayerAction", at = @At("HEAD"))
    private void handle(class_2846 packet, CallbackInfo ci) {
        class_3244 self = (class_3244) (Object) this;
        class_1657 player = self.field_14140;
        class_1937 world = player.method_37908();
        MinecraftServer server = player.method_5682();
        if (server == null) {
            return;
        }
        if (player.method_7325()) return;
        if (player.method_6115()) return;

        if (recentAttackPacket) {
            ItemLeftClickCallback.EVENT.invoker().leftClick(world, player, class_1268.field_5808);
        } else {
            recentAttackPacket = true;
        }
    }
}
