package cc.thonly.polymer.block;


import eu.pb4.factorytools.api.block.FactoryBlock;
import eu.pb4.factorytools.api.virtualentity.BlockModel;
import eu.pb4.factorytools.api.virtualentity.ItemDisplayElementUtil;
import eu.pb4.polymer.blocks.api.PolymerTexturedBlock;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import lombok.Getter;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7833;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import xyz.nucleoid.packettweaker.PacketContext;

@Getter
public class PottedPlantPolymerBlock implements PolymerTexturedBlock, FactoryBlock {
    private final class_2960 blockId;
    private final class_1799 MODEL;

    public PottedPlantPolymerBlock(class_2960 blockId) {
        this(blockId, false);
    }
    public PottedPlantPolymerBlock(class_2960 blockId, boolean useExtraModel) {
        this.blockId = blockId;
        MODEL = ItemDisplayElementUtil.getModel(class_2960.method_60655(blockId.method_12836(), "block/%s".formatted(useExtraModel ? blockId.method_12832() : blockId.method_12832().replace("potted_", ""))));
    }

    @Override
    public class_2680 getPolymerBlockState(class_2680 state, PacketContext context) {
        return class_2246.field_10495.method_9564();
    }


    @Override
    public @Nullable ElementHolder createElementHolder(class_3218 world, class_2338 pos, class_2680 initialBlockState) {
        return new ItemDisplayPottedPlantModel(pos);
    }

    public class ItemDisplayPottedPlantModel extends BlockModel {

        public ItemDisplayPottedPlantModel(class_2338 pos) {
            ItemDisplayElement main = ItemDisplayElementUtil.createSimple(MODEL);
            main.setScale(new Vector3f(0.98f));
            main.setDisplaySize(1, 1);
            int rotation = pos.hashCode() % 4 * 90;
            main.setRightRotation(class_7833.field_40716.rotationDegrees(rotation));
            this.addElement(main);
        }
    }
}
