package cc.thonly.polymer.entity;

import cc.thonly.polymer.entity.bil.BlockbenchEntityHolder;
import de.tomalbrc.bil.api.AnimatedEntity;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1309;

public interface TickHolderEntity {
    List<TickHolderEntity> LIST = new ArrayList<>();
    Map<class_1297, BlockbenchEntityHolder<?,?>> ELEMENT_BINDS = new Object2ObjectOpenHashMap<>();

    static void addTickHolder(TickHolderEntity entity) {
        LIST.add(entity);
    }

    static void addElementBind(class_1297 entity, BlockbenchEntityHolder<?,?> holder) {
        ELEMENT_BINDS.put(entity, holder);
    }

    static void tick() {
        LIST.removeIf(e -> {
            class_1309 entity = e.getEntity();
            if (entity == null || entity.method_31481()) {
                ELEMENT_BINDS.remove(entity);
                return true;
            }
            e.onTick();
            return false;
        });
    }

    class_1309 getEntity();

    default void onTick() {

    }
}
