package cc.thonly.polymer.entity.bil;

import de.tomalbrc.bil.api.AnimatedEntity;
import de.tomalbrc.bil.api.AnimatedEntityHolder;
import de.tomalbrc.bil.core.holder.base.AbstractAnimationHolder;
import de.tomalbrc.bil.core.holder.wrapper.Bone;
import de.tomalbrc.bil.core.holder.wrapper.ItemBone;
import de.tomalbrc.bil.core.model.Model;
import de.tomalbrc.bil.util.Utils;
import eu.pb4.polymer.virtualentity.api.VirtualEntityUtils;
import eu.pb4.polymer.virtualentity.api.elements.DisplayElement;
import eu.pb4.polymer.virtualentity.api.tracker.EntityTrackedData;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2752;
import net.minecraft.class_2940;
import net.minecraft.class_3244;
import net.minecraft.class_4048;

public abstract class BlockbenchEntityHolder<E extends class_1297, A extends AnimatedEntity> extends AbstractAnimationHolder implements AnimatedEntityHolder {
    protected final ObjectOpenHashSet<DisplayElement> additionalDisplays;
    protected final E entity;
    protected final A animatedEntity;
    protected class_4048 dimensions;
    protected int tickCount;

    protected BlockbenchEntityHolder(E entity, A animatedEntity, Model model) {
        super(model);
        this.additionalDisplays = new ObjectOpenHashSet<>();
        this.entity = entity;
        this.animatedEntity = animatedEntity;

        this.dimensions = entity.method_5864().method_18386();
        this.tickCount = entity.field_6012 - 1;
    }

    @Override
    public boolean addAdditionalDisplay(DisplayElement element) {
        if (this.additionalDisplays.add(element)) {
            this.addElement(element);
            this.sendPacket(new class_2752(this.entity));
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAdditionalDisplay(DisplayElement element) {
        if (this.additionalDisplays.remove(element)) {
            this.removeElement(element);
            return true;
        }
        return false;
    }

    @Override
    protected void startWatchingExtraPackets(class_3244 player, Consumer<class_2596<class_2602>> consumer) {
        super.startWatchingExtraPackets(player, consumer);
        this.sendDirectPassengers(consumer);
    }

    public void sendDirectPassengers(Consumer<class_2596<class_2602>> consumer) {
        IntList passengers = new IntArrayList();
        this.addDirectPassengers(passengers);

        if (!passengers.isEmpty()) {
            consumer.accept(VirtualEntityUtils.createRidePacket(this.entity.method_5628(), passengers));
        }
    }

    protected void addDirectPassengers(IntList passengers) {
    }

    @Override
    protected void notifyElementsOfPositionUpdate(class_243 newPos, class_243 delta) {
    }

    @Override
    protected void onDataLoaded() {
        this.onDimensionsUpdated(this.entity.method_18377(this.entity.method_18376()));
        super.onDataLoaded();
    }

    @Override
    protected boolean shouldSkipTick() {
        int parentTickCount = this.entity.field_6012;
        if (parentTickCount < ++this.tickCount) {
            // If the parent entity is behind, they likely haven't been ticked - in which case we can skip this tick too.
            this.tickCount = parentTickCount;
            return true;
        }
        return super.shouldSkipTick();
    }

    @Override
    public class_2168 createCommandSourceStack() {
        return this.entity.method_5671(this.getLevel());
    }

    @Override
    public void onDimensionsUpdated(class_4048 dimensions) {
        this.dimensions = dimensions;
        this.updateCullingBox();
    }

    @Override
    public void setScale(float scale) {
        super.setScale(scale);
        this.updateCullingBox();
    }

    protected void updateCullingBox() {
        float scale = this.getScale();
        float width = scale * (this.dimensions.comp_2185() * 2);
        float height = scale * (this.dimensions.comp_2186() + 1);

        for (int i = 0; i < this.bones.length; i++) {
            bones[i].element().setDisplaySize(width, height);
        }
    }

    @Override
    public void onSyncedDataUpdated(class_2940<?> key, Object object) {
        if (key.equals(EntityTrackedData.FLAGS)) {
            byte value = (byte) object;
            this.updateOnFire(Utils.getSharedFlag(value, EntityTrackedData.ON_FIRE_FLAG_INDEX));
            this.updateGlowing(Utils.getSharedFlag(value, EntityTrackedData.GLOWING_FLAG_INDEX));
            this.updateInvisibility(Utils.getSharedFlag(value, EntityTrackedData.INVISIBLE_FLAG_INDEX));
        }
    }

    protected void updateOnFire(boolean displayFire) {
    }

    protected void updateInvisibility(boolean isInvisible) {
        for (int i = 0; i < this.bones.length; i++) {
            if (this.bones[i] instanceof ItemBone itemBone) itemBone.setInvisible(isInvisible);
        }
    }

    protected void updateGlowing(boolean isGlowing) {
        for (int i = 0; i < this.bones.length; i++) {
            bones[i].element().setGlowing(isGlowing);
        }
    }

    @Override
    public int[] getDisplayIds() {
        int[] displays = new int[this.bones.length + this.additionalDisplays.size()];

        int index = 0;
        for (Bone<?> bone : this.bones) {
            displays[index++] = bone.element().getEntityId();
        }

        for (DisplayElement element : this.additionalDisplays) {
            displays[index++] = element.getEntityId();
        }

        return displays;
    }

    @Override
    public int getDisplayVehicleId() {
        return this.entity.method_5628();
    }

    @Override
    public int getVehicleId() {
        return this.entity.method_5628();
    }

    @Override
    public int getLeashedId() {
        return this.entity.method_5628();
    }

    @Override
    public int getEntityEventId() {
        return this.entity.method_5628();
    }

    @Override
    public int getCritParticleId() {
        return this.entity.method_5628();
    }

    public E getEntity() {
        return this.entity;
    }
}
