package cc.thonly.polymer.mixin;

import cc.thonly.polymer.entity.TickHolderEntity;
import de.tomalbrc.bil.api.AnimatedEntity;
import de.tomalbrc.bil.api.AnimatedEntityHolder;
import eu.pb4.polymer.virtualentity.api.tracker.DisplayTrackedData;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2945;
import net.minecraft.class_3222;

@Mixin(value = AnimatedEntity.class, remap = false)
public interface AnimatedEntityMixin {
    @SuppressWarnings("SuspiciousMethodCalls")
    @Inject(method = "getHolder(Ljava/lang/Object;)Lde/tomalbrc/bil/api/AnimatedEntityHolder;", at = @At("HEAD"), cancellable = true)
    private static void get(Object obj, CallbackInfoReturnable<AnimatedEntityHolder> cir) {
        if (TickHolderEntity.ELEMENT_BINDS.containsKey(obj)) {
            cir.setReturnValue(TickHolderEntity.ELEMENT_BINDS.get(obj));
        }

    }

    @Inject(method = "modifyRawTrackedData", at = @At("HEAD"), cancellable = true)
    public default void onModifyRawTrackedData(List<class_2945.class_7834<?>> data, class_3222 player, boolean initial, CallbackInfo ci) {
        if (this instanceof TickHolderEntity tickHolder) {
            class_1297 entity = tickHolder.getEntity();
            data.add(class_2945.class_7834.method_46360(DisplayTrackedData.WIDTH, entity.method_17681()));
            data.add(class_2945.class_7834.method_46360(DisplayTrackedData.HEIGHT, entity.method_17682()));
        }
    }

    @Inject(method = "getShadowRadius", at = @At("HEAD"), cancellable = true)
    public default void onGetShadowRadius(CallbackInfoReturnable<Float> cir) {
        if (this instanceof TickHolderEntity tickHolder) {
            class_1297 entity = tickHolder.getEntity();
            cir.setReturnValue(entity.method_17681() * 0.6f);
        }
    }
}
