package cc.thonly.reverie_dreams;

import cc.thonly.minecraft.api.ItemPostHitCallback;
import cc.thonly.reverie_dreams.item.weapon.YukaFlowerUmbrella;
import cc.thonly.reverie_dreams.registry.content.DrinkProperties;
import cc.thonly.reverie_dreams.registry.content.FoodProperties;
import cc.thonly.reverie_dreams.registry.content.RDEnchantments;
import cc.thonly.reverie_dreams.registry.content.effect.RDPotions;
import cc.thonly.reverie_dreams.registry.*;
import cc.thonly.reverie_dreams.registry.content.armor.RDArmorMaterials;
import cc.thonly.reverie_dreams.registry.content.block.*;
import cc.thonly.reverie_dreams.block.entity.RDBlockEntityTypes;
import cc.thonly.reverie_dreams.command.CommandInit;
import cc.thonly.reverie_dreams.compat.ReverieDreamsCompats;
import cc.thonly.reverie_dreams.registry.content.component.RDDataComponentTypes;
import cc.thonly.reverie_dreams.config.ReverieDreamsConfiguration;
import cc.thonly.reverie_dreams.registry.content.danmaku.DanmakuTemplates;
import cc.thonly.reverie_dreams.data.danmaku.script.DanmakuScriptManager;
import cc.thonly.reverie_dreams.data.danmaku.SpellcardRenderer;
import cc.thonly.reverie_dreams.loot.RDLootModifies;
import cc.thonly.reverie_dreams.registry.content.item.*;
import cc.thonly.reverie_dreams.registry.impl.ServerResourceHelper;
import cc.thonly.reverie_dreams.datafixer.DataFixerContentManager;
import cc.thonly.reverie_dreams.dialog.DialogFiles;
import cc.thonly.reverie_dreams.dialog.DialogInit;
import cc.thonly.reverie_dreams.dialog.DialogPlayer;
import cc.thonly.reverie_dreams.registry.content.effect.RDStatusEffects;
import cc.thonly.reverie_dreams.registry.content.entity.RDEntityTypes;
import cc.thonly.reverie_dreams.entity.villager.RDPointOfInterestTypes;
import cc.thonly.reverie_dreams.entity.villager.RDVillagerProfessions;
import cc.thonly.reverie_dreams.gui.RecipeTypeCategoryManager;
import cc.thonly.reverie_dreams.networking.CSVersionPayload;
import cc.thonly.reverie_dreams.networking.HelloPayload;
import cc.thonly.reverie_dreams.recipe.RecipeManager;
import cc.thonly.reverie_dreams.server.*;
import cc.thonly.reverie_dreams.server.player.PlayerComponent;
import cc.thonly.reverie_dreams.server.player.PlayerComponentInitializer;
import cc.thonly.reverie_dreams.server.player.PlayerDataComponentManager;
import cc.thonly.reverie_dreams.sound.JukeboxSongInit;
import cc.thonly.reverie_dreams.sound.SoundEventInit;
import cc.thonly.reverie_dreams.state.RDBlockStateTemplates;
import cc.thonly.reverie_dreams.util.*;
import cc.thonly.reverie_dreams.util.item.ItemStackCheckUtils;
import cc.thonly.reverie_dreams.util.network.ModrinthAPI;
import cc.thonly.reverie_dreams.util.network.NetUtil;
import cc.thonly.reverie_dreams.world.BiomeModificationInit;
import cc.thonly.reverie_dreams.world.GameRulesInit;
import cc.thonly.reverie_dreams.world.WorldGenerationInit;
import eu.midnightdust.lib.config.MidnightConfig;
import lombok.Getter;
import lombok.Setter;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2397;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3483;
import net.minecraft.class_3902;
import net.minecraft.class_5250;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8109;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.*;
import java.net.URI;
import java.util.*;
import java.util.concurrent.CompletableFuture;

@Setter
@Getter
public class ReverieDreams implements ModInitializer {
    public static final String MOD_NAME = "Gensokyo: Reverie of Lost Dreams";
    public static final String MOD_ID = "reverie_dreams";
    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);
    private static MinecraftServer server;
    private static final Set<class_3222> PLAYER_WITH_MOD = new HashSet<>();
    private static final Map<class_3222, String> PLAYER_SIDE_VERSION = new WeakHashMap<>();

    @Override
    public void onInitialize() {
        MidnightConfig.init(MOD_ID, ReverieDreamsConfiguration.class);
        LOGGER.info("Loaded " + MOD_NAME);

        // 初始化静态注册表
        SoundEventInit.init();
        JukeboxSongInit.init();
        RDDataComponentTypes.init();
        RDArmorMaterials.init();
        RDGuiItems.init();
        RDBlockStateTemplates.bootstrap();
        RDBlockEntityTypes.registerBlockEntityTypes();
        RDBlocks.registerBlocks();
        RDWoodBlocks.registerBlocks();
        RDCropBlocks.registerBlocks();
        RDPlantBlocks.registerBlocks();
        KitchenBlocks.registerBlocks();
        RDEnchantments.registerEnchantments();
        RDItems.registerItems();
        RDIngredientItems.registerItems();
        RDFoodItems.registerItems();
        RDDrinkItems.registerItems();
        RDEntityHolderItems.registerHolders();
        RDEntityTypes.registerEntityTypes();
        RDStatusEffects.registerEffects();
        RDPotions.registerPotions();
        WorldGenerationInit.registerWorldGeneration();
        RDPointOfInterestTypes.registers();
        RDVillagerProfessions.registers();
        BiomeModificationInit.init();
        GameRulesInit.init();
        DataFixerContentManager.bootstrap();
        DialogInit.bootstrap();

        // 初始化其他注册内容
        CommandInit.init();
        RecipeManager.bootstrap();
        ServerResourceHelper.init();
        RegistryHandlers.bootstrap();
        FoodProperties.registerDefaultItemUsingProperty();
        DrinkProperties.registerDefaultItemUsingProperty();
        PairRegistryHandlers.bootstrap();
        RDLootModifies.register();
        RecipeTypeCategoryManager.registerCategories();
        DanmakuTemplates.init();

        ImageToTextScanner.bootstrap();
        ItemDescriptionManager.bootstrap();
        PlayerDataComponentManager.registers();

        this.loadCompletableEvent();
        this.registerNetworkingEvent();
        this.registerServerEvents();
        this.registerContentEvent();

        ReverieDreamsCompats.init();
    }

    private void registerContentEvent() {
        UseBlockCallback.EVENT.register((playerEntity, world, hand, blockHitResult) -> {
            if (!world.method_8608()) {
                class_1799 stack = playerEntity.method_5998(hand);
                class_2338 blockPos = blockHitResult.method_17777();
                class_2680 blockState = world.method_8320(blockPos);
                class_2248 block = blockState.method_26204();
                if (block instanceof class_2397 && (blockState.method_11654(class_2397.field_38227))) {
                    if (stack.method_7909() == class_1802.field_17524) {
                        stack.method_57008(1, playerEntity);
                        if (!playerEntity.method_56992()) {
                            playerEntity.method_7270(new class_1799(RDIngredientItems.DEW, 1));
                        }
                        playerEntity.method_6104(hand);
                        return class_1269.field_52422;
                    }
                }
            }
            return class_1269.field_5811;
        });

        ItemPostHitCallback.EVENT.register((stack, target, attacker) -> {
            MinecraftServer server = target.method_5682();
            if (server != null && target.method_37908() instanceof class_3218 serverWorld && class_3902.field_17274.equals(stack.method_58695(RDDataComponentTypes.SILVER_ITEM, null))) {
                class_5455.class_6890 registryAccess = server.method_30611();
                class_2378<class_1299<?>> entityTypes = registryAccess.method_30530(class_7924.field_41266);
                class_8109 damageSources = attacker.method_48923();
                for (class_6880<class_1299<?>> iterateEntry : entityTypes.method_40286(class_3483.field_46232)) {
                    class_1299<?> value = iterateEntry.comp_349();
                    if (target.method_5864() == value) {
                        target.field_6253 = 0;
                        target.method_64397(serverWorld, damageSources.method_48831(), 2);
                        target.field_6253 = 0;
                        break;
                    }
                }

            }
            return true;
        });

        ItemPostHitCallback.EVENT.register((stack, target, attacker) -> {
            MinecraftServer server = target.method_5682();
            class_1799 itemStack = attacker.method_5998(class_1268.field_5808);
            if (server != null && !itemStack.method_7960()) {
                class_1937 world = target.method_37908();
                class_5455 registryAccess = target.method_56673();
                class_2378<class_1887> enchantments = registryAccess.method_30530(class_7924.field_41265);
                class_6880.class_6883<class_1887> moonDamage = enchantments.method_46747(RDEnchantments.MOON_DAMAGE);
                int itemEnchantmentLevel = class_1890.method_8225(moonDamage, itemStack);
                if (itemEnchantmentLevel != 0) {
                    DelayedTask.create(server, 1, () -> {
                        target.field_6235 = 0;
                        if (target.method_6032() - itemEnchantmentLevel >= 0) {
                            target.method_6033(target.method_6032() - itemEnchantmentLevel);
                        }
                        target.field_6253 = 0;
                    });
                }
            }
            return true;
        });

        ItemPostHitCallback.EVENT.register((stack, target, attacker) -> {
            class_1937 level = attacker.method_37908();
            if (level instanceof class_3218 world && stack.method_7909() instanceof YukaFlowerUmbrella) {
                double speed = attacker.method_18798().method_1033();
                class_1297 vehicle = attacker.method_5854();
                if (vehicle != null) {
                    double length = vehicle.method_18798().method_1033();
                    if (speed > length) {
                        speed = length;
                    }
                }
                MinecraftServer server = level.method_8503();
                float damageValue = (float) (48f * speed);
                DelayedTask.create(server, 1, () -> {
                    target.field_6235 = 0;
                    if (target.method_6032() - damageValue >= 0) {
                        target.method_6033(target.method_6032() - damageValue);
                    } else {
                        target.method_6033(0);
                    }
                    target.field_6235 = 0;
                });
            }
            return true;
        });

        ItemPostHitCallback.EVENT.register((stack, target, attacker) -> {
            MinecraftServer server = target.method_5682();
            if (server != null && target.method_37908() instanceof class_3218 serverWorld && target.method_5864() == RDEntityTypes.GHOST_ENTITY_TYPE && stack.method_7909() == RDItems.ROKANKEN) {
                class_8109 damageSources = attacker.method_48923();
                target.field_6253 = 0;
                target.method_64397(serverWorld, damageSources.method_48831(), Integer.MAX_VALUE);
            }
            return true;
        });

    }

    private void registerNetworkingEvent() {
        PayloadTypeRegistry.playC2S().register(HelloPayload.PACKET_ID, HelloPayload.codec);
        ServerPlayNetworking.registerGlobalReceiver(HelloPayload.PACKET_ID, (payload, context) -> {
            class_3222 player = context.player();
            if (player != null) {
                PLAYER_WITH_MOD.add(player);
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((playNetworkHandler, server) -> {
            PLAYER_WITH_MOD.remove(playNetworkHandler.field_14140);
        });
        PayloadTypeRegistry.playC2S().register(CSVersionPayload.PACKET_ID, CSVersionPayload.codec);
        ServerPlayNetworking.registerGlobalReceiver(CSVersionPayload.PACKET_ID, (payload, context) -> {
            class_3222 player = context.player();
            String version = payload.version();
            if (player != null) {
                PLAYER_SIDE_VERSION.put(player, version);
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((playNetworkHandler, server) -> {
            PLAYER_SIDE_VERSION.remove(playNetworkHandler.field_14140);
        });
    }

    @SuppressWarnings("rawtypes")
    private void registerServerEvents() {
        ServerPlayConnectionEvents.JOIN.register((handler, packetSender, server) -> {
            class_3222 player = handler.method_32311();
            PlayerDataComponentManager componentManager = PlayerDataComponentManager.getInstance();
            for (Map.Entry<Class<PlayerComponent<? extends PlayerComponent>>, PlayerComponentInitializer<?>> mapEntry : PlayerDataComponentManager.getComponents()) {
                Class<PlayerComponent<? extends PlayerComponent>> key = mapEntry.getKey();
                componentManager.getOrCreatePlayerComponent(player, key);
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((serverPlayNetworkHandler, server) -> {
            PlayerDataComponentManager playerDataComponentManager = PlayerDataComponentManager.getInstance();
            playerDataComponentManager.saveAll();
        });
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, success) -> {
            if (success) {
                PlayerDataComponentManager playerDataComponentManager = PlayerDataComponentManager.getInstance();
                playerDataComponentManager.onLoad(server);
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, packetSender, minecraftServer) -> {
            class_3222 player = handler.method_32311();
            if (!ReverieDreamsConfiguration.CHECK_UPDATE) {
                return;
            }
            if (!player.method_64475(2)) {
                return;
            }
            if (ConstantInfo.LATEST_VERSION == null) {
                return;
            }
            class_5250 mutableText = class_2561.method_43473();
            mutableText.method_10852(class_2561.method_43469("message.reverie_dreams.update", ConstantInfo.LATEST_VERSION));
            mutableText.method_27693(" §r[");
            mutableText.method_10852(class_2561.method_43471("item.action.click.left").method_10862(class_2583.field_24360.method_10958(new class_2558.class_10608(URI.create("https://modrinth.com/mod/gensokyo-reverie-of-lost-dreams")))));
            mutableText.method_27693("§r]");
            player.method_7353(mutableText, false);
        });
        ServerLivingEntityEvents.ALLOW_DEATH.register((livingEntity, damageSource, v) -> {
            return !livingEntity.method_6059(RDStatusEffects.ELIXIR_OF_LIFE);
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            PlayerInputManager inputManager = PlayerInputManager.getInstance();
            inputManager.reload();
            DialogPlayer.reload();
        });
        ServerLifecycleEvents.AFTER_SAVE.register((server, flush, force) -> {
            PlayerDataComponentManager playerDataComponentManager = PlayerDataComponentManager.getInstance();
            playerDataComponentManager.saveAll();
        });
        ServerTickEvents.END_SERVER_TICK.register(DelayedTask::tick);
        ServerTickEvents.END_SERVER_TICK.register(ArmorAttributeManager::tick);
        ServerTickEvents.END_SERVER_TICK.register(PlayerDataComponentManager::tick);
        ServerTickEvents.END_SERVER_TICK.register(ParticleTickerManager::tick);
        ServerTickEvents.END_SERVER_TICK.register(PlayerInputManager::tick);
        ServerTickEvents.END_SERVER_TICK.register(DanmakuScriptManager::onTick);
        ServerTickEvents.END_SERVER_TICK.register(DialogPlayer::tick);
        ServerTickEvents.END_SERVER_TICK.register(SpellcardRenderer::tick);
    }

    private void loadCompletableEvent() {
        CompletableFuture.runAsync(ItemStackCheckUtils::test);

        CompletableFuture.runAsync(() -> {
            ModrinthAPI.Entry latest = ModrinthAPI.get();
            if (latest == null) {
                LOGGER.error("Unable to check for new version");
                return;
            }
            if (ConstantInfo.VERSION.equals("unknown")) {
                LOGGER.error("Unable to detect local version number");
                return;
            }
            String versionNumber = latest.getVersion_number();

            int cmp = ModrinthAPI.compareVersion(versionNumber, ConstantInfo.VERSION);
            if (cmp > 0) {
                LOGGER.info("A newer version is available: {}", versionNumber);
                ConstantInfo.LATEST_VERSION = versionNumber;
            } else if (cmp < 0) {
                LOGGER.info("You're using a newer version than latest: {}", ConstantInfo.VERSION);
            } else {
                LOGGER.info("You're using the latest version: {}", ConstantInfo.VERSION);
            }
        });

        CompletableFuture.runAsync(() -> {
            String testUrl = "https://textures.minecraft.net/texture/7fd9ba42a7c81eeea22f1524271ae85a8e045ce0af5a6ae16c6406ae917e68b5";
            boolean reachable = NetUtil.isUrlAccessible(testUrl);
            if (!reachable) {
                LOGGER.error("Unable to connect to the Minecraft network, unexpected behavior may occur");
            }
        });

        CompletableFuture.runAsync(() -> {
            boolean contain = DialogFiles.contain("badapple.json");
            if (!contain) {
                try {
                    NetUtil.downloadFile("https://www.otomads.top/reverie_dreams/badapple.json", DialogFiles.PATH.resolve("badapple.json").toFile());
                } catch (Exception err) {
                    LOGGER.error("Can't download badapple.json", err);
                }
            }
        });
    }

    public static class_2960 id(String id) {
        return class_2960.method_60655(MOD_ID, id);
    }

    public static boolean hasModOnClient(class_3222 player) {
        if (player == null) return false;
        return PLAYER_WITH_MOD.contains(player);
    }

    public static void setServer(MinecraftServer server) {
        ReverieDreams.server = server;
    }

    @Nullable
    public static MinecraftServer getServer() {
        return server;
    }


}