package cc.thonly.reverie_dreams.block;

import cc.thonly.reverie_dreams.block.entity.RDBlockEntityTypes;
import cc.thonly.reverie_dreams.block.entity.MusicBlockEntity;
import cc.thonly.reverie_dreams.util.TouhouNotaUtils;
import com.mojang.serialization.MapCodec;
import nota.player.SongPlayer;
import org.jetbrains.annotations.Nullable;

import java.util.Map;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_5558;
import net.minecraft.class_9904;

public class MusicBlock extends class_2237 {
    public static final class_2746 POWERED = class_2741.field_12484;

    public MusicBlock(class_2251 settings) {
        super( settings);
        this.method_9590(this.method_9595().method_11664().method_11657(POWERED, false));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(POWERED);
    }

    @Override
    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        if (!world.method_8608() && world instanceof class_3218 serverWorld) {
            MusicBlockEntity blockEntity = (MusicBlockEntity) serverWorld.method_8321(pos);
            if (blockEntity == null) {
                return class_1269.field_5814;
            }
            int index = -1;
            index = player.method_5715() ? blockEntity.next() : blockEntity.prev();
            if (blockEntity.getFilenames().isEmpty()) {
                player.method_7353(class_2561.method_43471("item.reverie_dreams.music.no_files"), false);
                return class_1269.field_5811;
            }
            if (index == -1) {
                player.method_7353(class_2561.method_43471("item.reverie_dreams.music.no_music_selected"), false);
                return class_1269.field_5811;
            } else if (world.method_49803(pos)){
                TouhouNotaUtils.playAt(world, pos, blockEntity.getSelect());
            }
            player.method_7353(class_2561.method_43469("item.reverie_dreams.music.switch_music", blockEntity.getSelect()), false);
            return class_1269.field_52422;
        }
        return super.method_55766(state, world, pos, player, hit);
    }

    @Override
    public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof MusicBlockEntity musicBlockEntity) {
            SongPlayer selfPlayer = musicBlockEntity.getSelfPlayer();
            if (selfPlayer != null) {
                selfPlayer.setPlaying(false);
                Map<Long, SongPlayer> blockPos2SongPlayer = TouhouNotaUtils.blockMusicPlayCache.get(world);
                if (blockPos2SongPlayer != null) {
                    blockPos2SongPlayer.remove(pos.method_10063());
                }
            }
        }
        return super.method_9576(world, pos, state, player);
    }

    @Override
    protected void method_9612(class_2680 state, class_1937 world, class_2338 pos, class_2248 sourceBlock, @Nullable class_9904 wireOrientation, boolean notify) {
        super.method_9612(state, world, pos, sourceBlock, wireOrientation, notify);

        boolean hasPower = world.method_49803(pos);
        boolean wasPowered = state.method_11654(POWERED);

        if (hasPower != wasPowered) {
            world.method_8652(pos, state.method_11657(POWERED, hasPower), class_2248.field_31036);

            if (hasPower) {
                class_2586 blockEntity = world.method_8321(pos);
                if (blockEntity instanceof MusicBlockEntity musicBlockEntity) {
                    TouhouNotaUtils.playAt(world, pos, musicBlockEntity.getSelect());
                }
            }
        }
    }

    @Override
    public @Nullable <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return method_31618(type, RDBlockEntityTypes.MUSIC_BLOCK_ENTITY, MusicBlockEntity::tick);
    }

    @Override
    protected MapCodec<? extends class_2237> method_53969() {
        return method_54094(MusicBlock::new);
    }

    @Override
    public @Nullable class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new MusicBlockEntity(pos, state);
    }
}
