package cc.thonly.reverie_dreams.block.creator;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.registry.content.block.RDBlocks;
import lombok.Getter;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2446;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2544;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_5793;
import net.minecraft.class_5794;
import net.minecraft.class_7800;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class DecorativeBlockCreator extends AbstractBlockCreator {
    public static final List<DecorativeBlockCreator> INSTANCES = new ArrayList<>();
    public static final List<class_1792> BLOCK_ITEMS = new ArrayList<>();
    @Getter
    private class_5794 blockFamily;
    private class_2248 base;
    private class_2248 block;
    private class_2248 stair;
    private class_2248 slab;
    private class_2248 wall;

    private DecorativeBlockCreator(class_2960 id) {
        super(id.method_12832(), id);
        INSTANCES.add(this);
    }

    private DecorativeBlockCreator(String name) {
        this(ReverieDreams.id(name));
    }

    public void base(class_2248 base) {
        this.base = base;
    }

    public class_2248 base() {
        return this.base;
    }

    public class_2248 block() {
        return this.block;
    }

    public class_2248 stair() {
        return this.stair;
    }

    public class_2248 slab() {
        return this.slab;
    }

    public class_2248 wall() {
        return this.wall;
    }

    @Override
    public Stream<class_2248> stream() {
        return Stream.of(
                this.block,
                this.stair,
                this.slab,
                this.wall
        ).filter(Objects::nonNull);
    }

    public void offerRecipe(class_2446 generator, @NotNull class_1792 material) {
        class_2960 id = class_7923.field_41178.method_10221(material);
        class_1935 start = this.base() == null ? material : this.base();
        if (start != this.block()) {
            generator.method_62747(class_7800.field_40635, this.block(), 2)
                    .method_10439("XX")
                    .method_10439("XX")
                    .method_10434('X', start)
                    .method_10429("has_" + id.method_12832(), generator.method_10426(start))
                    .method_36443(generator.field_53721, class_2446.method_36450(this.block()));
        }
        generator.method_32814(class_7800.field_40634, this.slab(), material);
        generator.method_33715(class_7800.field_40634, this.slab(), this.block(), 2);
        generator.method_32808(this.stair(), class_1856.method_8101(material))
                .method_33530("has_" + id.method_12832(), generator.method_10426(material))
                .method_36443(generator.field_53721, class_2446.method_36450(this.stair()));
        generator.method_33717(class_7800.field_40634, this.stair(), this.block());
        generator.method_32809(class_7800.field_40634, this.wall(), material);
    }

    @Override
    public DecorativeBlockCreator build() {
        this.block = RDBlocks.registerSimpleBlock(this.getId(), class_2248::new, class_4970.class_2251.method_9630(class_2246.field_10340));
        this.stair = RDBlocks.registerSimpleBlock(suffix("stairs"), (settings) -> new class_2510(this.block.method_9564(), settings), class_4970.class_2251.method_9630(class_2246.field_10563));
        this.slab = RDBlocks.registerSimpleBlock(suffix("slab"), class_2482::new, class_4970.class_2251.method_9630(class_2246.field_10119).method_22488());
        this.wall = RDBlocks.registerSimpleBlock(suffix("wall"), class_2544::new, class_4970.class_2251.method_9630(class_2246.field_10252).method_22488());

        class_7923.field_41178.addAlias(suffix("stair"), suffix("stairs"));

        this.stream().forEach((block) -> {
            BLOCK_ITEMS.add(block.method_8389());
        });

        this.blockFamily = class_5793.method_33468(this.block)
                .method_33493(this.stair)
                .method_33492(this.slab)
                .method_33497(this.wall)
                .method_33484(this.getId().getPath()).recipeUnlockedBy("has_" + this.getId().getPath())
                .getFamily();
        return this;
    }

    public static DecorativeBlockCreator create(String name) {
        return new DecorativeBlockCreator(name);
    }

    public static DecorativeBlockCreator create(class_2960 id) {
        return new DecorativeBlockCreator(id);
    }
}
