package cc.thonly.reverie_dreams.block.entity;

import cc.thonly.reverie_dreams.block.FoodDisplayBlock;
import cc.thonly.polymer.block.ItemStackDisplayImpl;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import java.util.Map;
import java.util.Optional;

@Setter
@Getter
public class FoodDisplayBlockEntity extends class_2586 {
    private ItemStackWrapper item = ItemStackWrapper.empty();
    private double yaw = 0.0;

    public FoodDisplayBlockEntity(class_2338 pos, class_2680 state) {
        super(RDBlockEntityTypes.ITEM_DISPLAY_BLOCK_ENTITY, pos, state);
    }

    public void update() {
        if (!(this.method_10997() instanceof class_3218 serverWorld)) {
            return;
        }
        Map<Long, ItemStackDisplayImpl.Model> longModelMap = ItemStackDisplayImpl.MAPPING.computeIfAbsent(serverWorld, w -> new Object2ObjectOpenHashMap<>());
        var model = longModelMap.get(this.method_11016().method_10063());
        if (!(this.method_11010().method_26204() instanceof FoodDisplayBlock)) {
            return;
        }
        if (model != null) {
            model.updateItem(this.method_11010());
        }
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, FoodDisplayBlockEntity blockEntity) {
        if (!(world instanceof class_3218 serverWorld)) {
            return;
        }

        Map<Long, ItemStackDisplayImpl.Model> longModelMap = ItemStackDisplayImpl.MAPPING.computeIfAbsent(serverWorld, w -> new Object2ObjectOpenHashMap<>());
        var model = longModelMap.get(pos.method_10063());
        if (model != null) {
            model.updateItem(state);
        }

    }

    @Override
    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        Optional<ItemStackWrapper> itemOptional = view.method_71426("Item", ItemStackWrapper.CODEC);
        itemOptional.ifPresent(wrapper -> this.item = wrapper);
        this.yaw = view.method_71422("Yaw", 0);
    }

    @Override
    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        DataResult<JsonElement> dataResult = ItemStackWrapper.CODEC.encodeStart(JsonOps.INSTANCE, this.item);
        Optional<JsonElement> result = dataResult.result();
        if (result.isPresent()) {
            view.method_71468("Item", ItemStackWrapper.CODEC, this.item);
        }
        view.method_71463("Yaw", this.yaw);
    }
}
