package cc.thonly.reverie_dreams.compat;

import cc.thonly.reverie_dreams.data.FoodProperty;
import cc.thonly.reverie_dreams.recipe.RecipeManager;
import cc.thonly.reverie_dreams.recipe.entry.KitchenRecipe;
import cc.thonly.reverie_dreams.registry.content.FoodProperties;
import cc.thonly.reverie_dreams.api.RecipeCompatPatchesCallback;
import cc.thonly.reverie_dreams.api.RecipeCompatPatchesImpl;
import cc.thonly.reverie_dreams.api.RegistryManagerReloadCallback;
import cc.thonly.reverie_dreams.registry.RegistryHandlers;
import cc.thonly.reverie_dreams.registry.impl.RegistryHandler;
import com.phoen1x.items.ODItems;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_2960;

@SuppressWarnings("unchecked")
public class OceansdelightCompatImpl {
    public static void bootstrap() {
        RecipeCompatPatchesCallback.EVENT.register(() -> {
            RecipeCompatPatchesImpl.Builder<KitchenRecipe> builder = RecipeCompatPatchesImpl.getOrCreateBuilder(RecipeManager.KITCHEN_TYPE);

        });
        RegistryManagerReloadCallback.EVENT.register(simpleRegistry -> {
            if (!simpleRegistry.equals(RegistryHandlers.FOOD_PROPERTY)) {
                return;
            }
            RegistryHandler<FoodProperty> registry = (RegistryHandler<FoodProperty>) simpleRegistry;
            Stream<Map.Entry<class_2960, FoodProperty>> stream = registry.streamIdToValue();
            stream.forEach(mapEntry -> {
                FoodProperty property = mapEntry.getValue();
                Set<class_1792> items = property.getItems();
                if (property.is(FoodProperties.UMAMI)) {
                    items.add(ODItems.TENTACLES);
                    items.add(ODItems.CUT_TENTACLES);
                    items.add(ODItems.SQUID_RINGS);
                    items.add(ODItems.GUARDIAN);
                    items.add(ODItems.GUARDIAN_TAIL);
                    items.add(ODItems.ELDER_GUARDIAN_SLICE);
                    items.add(ODItems.FUGU_SLICE);
                }
                if (property.is(FoodProperties.AQUATIC_PRODUCTS)) {
                    items.add(ODItems.TENTACLES);
                    items.add(ODItems.CUT_TENTACLES);
                    items.add(ODItems.SQUID_RINGS);
                    items.add(ODItems.FUGU_SLICE);
                }
            });
        });
    }
}
