package cc.thonly.reverie_dreams.component;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.registry.content.RDDamageTypes;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Value;
import lombok.With;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import java.util.function.Supplier;

@Value
@With
@AllArgsConstructor
@Builder(toBuilder = true)
public class DanmakuProperties {
    public static final class_2960 DEFAULT_TEMPLATE_ID = ReverieDreams.id("single");
    public static final Supplier<DanmakuProperties> EMPTY = () -> new DanmakuProperties(
            DEFAULT_TEMPLATE_ID,
            1,
            2,
            RDDamageTypes.DANMAKU_GENERIC,
            1,
            0.5f,
            0,
            false,
            false
    );

    public class_2960 templateId;
    public int count;
    public float damage;
    public class_5321<class_8110> damageType;
    public float scale;
    public float speed;
    public float acceleration;
    public boolean tile;
    public boolean infinite;

    public static final Codec<DanmakuProperties> CODEC = RecordCodecBuilder.create(instance ->
            instance.group(
                    class_2960.field_25139.fieldOf("templateId").forGetter(DanmakuProperties::getTemplateId),
                    Codec.INT.fieldOf("count").forGetter(DanmakuProperties::getCount),
                    Codec.FLOAT.fieldOf("damage").forGetter(DanmakuProperties::getDamage),
                    class_5321.method_39154(class_7924.field_42534).optionalFieldOf("damage_type", RDDamageTypes.DANMAKU_GENERIC).forGetter(DanmakuProperties::getDamageType),
                    Codec.FLOAT.fieldOf("scale").forGetter(DanmakuProperties::getScale),
                    Codec.FLOAT.fieldOf("speed").forGetter(DanmakuProperties::getSpeed),
                    Codec.FLOAT.fieldOf("acceleration").forGetter(DanmakuProperties::getAcceleration),
                    Codec.BOOL.fieldOf("tile").forGetter(DanmakuProperties::isTile),
                    Codec.BOOL.fieldOf("infinite").forGetter(DanmakuProperties::isInfinite)
            ).apply(instance, DanmakuProperties::new)
    );

    @SuppressWarnings("MethodDoesntCallSuperMethod")
    @Override
    public DanmakuProperties clone() {
        return this.toBuilder().build();
    }

    public static DanmakuProperties ofDefault() {
        return EMPTY.get();
    }
}