package cc.thonly.reverie_dreams.data.danmaku;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.component.DanmakuProperties;
import cc.thonly.reverie_dreams.registry.content.ItemColor;
import cc.thonly.reverie_dreams.registry.content.component.RDDataComponentTypes;
import cc.thonly.reverie_dreams.datagen.generator.AbstractRecipeTypeProvider;
import cc.thonly.reverie_dreams.entity.misc.DanmakuEntity;
import cc.thonly.reverie_dreams.item.danmaku.DanmakuItem;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import cc.thonly.reverie_dreams.recipe.entry.DanmakuShapeDrawRecipe;
import cc.thonly.reverie_dreams.registry.*;
import cc.thonly.reverie_dreams.registry.impl.RegistryHandler;
import cc.thonly.reverie_dreams.registry.interfaces.BuiltinObject;
import cc.thonly.reverie_dreams.registry.interfaces.CodecStep;
import cc.thonly.reverie_dreams.registry.interfaces.OwnerBinding;
import cc.thonly.reverie_dreams.registry.interfaces.Translatable;
import cc.thonly.reverie_dreams.registry.tag.RDItemTags;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.class_10130;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3545;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8110;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import java.util.*;

@Setter
@Getter
public class DanmakuType implements CodecStep<DanmakuType>, OwnerBinding<DanmakuType>, Translatable, BuiltinObject {
    public static final Codec<DanmakuType> CODEC = RecordCodecBuilder.create(instance ->
            instance.group(
                    class_2960.field_25139.fieldOf("registry_key").forGetter(DanmakuType::getId),
                    class_5321.method_39154(class_7924.field_42534).fieldOf("damage_type").forGetter(DanmakuType::getDamageType),
                    Codec.FLOAT.fieldOf("damage").forGetter(DanmakuType::getDamage),
                    Codec.FLOAT.fieldOf("scale").forGetter(DanmakuType::getScale),
                    Codec.FLOAT.fieldOf("speed").forGetter(DanmakuType::getSpeed),
                    Codec.BOOL.fieldOf("tile").forGetter(DanmakuType::isTile),
                    Codec.BOOL.fieldOf("infinite").forGetter(DanmakuType::isInfinite)
            ).apply(instance, DanmakuType::getOrCreate)
    );

    private class_2960 id;
    private final class_5321<class_8110> damageType;
    private final float damage;
    private final float scale;
    private final float speed;
    private final boolean tile;
    private final boolean infinite;
    private class_1792 item;
    private DanmakuEntity.OnHitFactory hitFactory;
    private RegistryHandler<DanmakuType> owner;

    public DanmakuType(class_2960 id, class_5321<class_8110> damageType, float damage, float scale, float speed, boolean tile, boolean infinite) {
        this.id = id;
        this.damageType = damageType;
        this.damage = damage;
        this.scale = scale;
        this.speed = speed;
        this.tile = tile;
        this.infinite = infinite;
        this.createItem();
    }

    public static DanmakuType getOrCreate(class_2960 id, class_5321<class_8110> damageType, float damage, float scale, float speed, boolean tile, boolean infinite) {
        DanmakuType type = RegistryHandlers.DANMAKU_TYPE.method_63535(id);
        if (type == null) {
            return new DanmakuType(id, damageType, damage, scale, speed, tile, infinite);
        }
        return type;
    }

    @Override
    public String translateKey() {
        return this.item.method_7876();
    }

    public DanmakuShape toShape() {
        for (Map.Entry<class_5321<DanmakuShape>, DanmakuShape> mapEntry : RegistryHandlers.DANMAKU_SHAPE.method_29722()) {
            DanmakuShape shape = mapEntry.getValue();
            if (shape.getType() == this) {
                return shape;
            }
        }
        return new DanmakuShape(this);
    }

    public void buildShapeRecipe(AbstractRecipeTypeProvider.Factory<DanmakuShapeDrawRecipe> factory, List<List<Boolean>> shape) {
        factory.register(this.id, new DanmakuShapeDrawRecipe(shape, ItemStackWrapper.of(this.toShape().getItemStack().method_7972())));
    }

    public void buildShapeRecipe(AbstractRecipeTypeProvider.Factory<DanmakuShapeDrawRecipe> factory, String[] shape) {
        List<List<Boolean>> list = new ArrayList<>();

        for (String line : shape) {
            ArrayList<Boolean> row = new ArrayList<>();
            for (int i = 0; i < line.length(); i++) {
                char c = line.charAt(i);
                if (c == 'T') {
                    row.add(true);
                } else if (c == 'F') {
                    row.add(false);
                } else {
                    throw new IllegalArgumentException("Invalid character in shape string: " + c);
                }
            }
            list.add(row);
        }

        this.buildShapeRecipe(factory, list);
    }

    public void createItem() {
        DanmakuItem item = new DanmakuItem(this.createItemSettings()
                .method_57349(class_9334.field_49644, new class_9282(14606046))
                .method_7895(120)
        );
        item.type(this);
        this.item = item;
        class_2378.method_10230(class_7923.field_41178, this.getItemId(), this.item);
    }

    public List<class_3545<class_1792, class_1799>> getColorPairs() {
        List<class_3545<class_1792, class_1799>> pairList = new LinkedList<>();
        class_1799 defaultStack = this.item.method_7854();
        for (Map.Entry<class_1792, Long> itemLongEntry : ItemColor.getView().entrySet()) {
            class_1792 dyeItem = itemLongEntry.getKey();
            class_1799 stack = defaultStack.method_7972();
            stack.method_57379(class_9334.field_49644, new class_9282(itemLongEntry.getValue().intValue()));
            stack.method_57379(class_9334.field_53966, new class_10130(0.5f, Optional.of(class_2960.method_60654(UUID.randomUUID().toString()))));
            pairList.add(new class_3545<>(dyeItem, stack));
        }
        return pairList;
    }

    public class_2960 getItemId() {
        return class_2960.method_60655(this.id.method_12836(), "danmaku/" + this.id.method_12832());
    }

    public class_1792.class_1793 createItemSettings() {
        return new class_1792.class_1793()
                .method_63686(class_5321.method_29179(class_7924.field_41197, this.getItemId()))
                .method_57349(RDDataComponentTypes.DANMAKU_PROPERTIES, this.createDanmakuProperties())
                .method_57349(class_9334.field_53966, new class_10130(0.5f, Optional.of(class_2960.method_60654(UUID.randomUUID().toString()))))
                .method_7895(120)
                .method_61647(RDItemTags.POWER_BLOCK);
    }

    public DanmakuProperties createDanmakuProperties() {
        return new DanmakuProperties(
                ReverieDreams.id("single"),
                1,
                this.damage,
                this.damageType,
                this.scale,
                this.speed,
                0,
                this.tile,
                this.infinite
        );
    }

    @Override
    public Codec<DanmakuType> getCodec() {
        return CODEC;
    }
}
