package cc.thonly.reverie_dreams.data.danmaku.trajectory;

import cc.thonly.reverie_dreams.data.danmaku.DanmakuTrajectory;
import cc.thonly.reverie_dreams.data.danmaku.Pattern;
import cc.thonly.reverie_dreams.entity.misc.DanmakuEntity;
import cc.thonly.reverie_dreams.item.base.IDanmakuItem;
import lombok.AllArgsConstructor;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import org.jetbrains.annotations.Nullable;

@AllArgsConstructor
public class PatternTrajectory extends DanmakuTrajectory {
    public final Pattern pattern;

    @Override
    public void run(class_3218 world, @Nullable class_1309 livingEntity, class_1799 stack,
                    Double x, Double y, Double z,
                    float pitch, float yaw, float divergence, float offsetDist, IDanmakuItem pThis) {

        char[][] chars = this.pattern.getChars();
        int height = chars.length;
        int width = height > 0 ? chars[0].length : 0;
        if (width == 0 || height == 0) return;

        double centerX = (width - 1) / 2.0;
        double centerY = (height - 1) / 2.0;

        // 弧度
        double yawRad = Math.toRadians(yaw);
        double pitchRad = Math.toRadians(pitch);

        // 玩家前方向量
        class_243 forward = new class_243(
                -Math.sin(yawRad) * Math.cos(pitchRad),
                Math.sin(pitchRad),
                Math.cos(yawRad) * Math.cos(pitchRad)
        ).method_1029();

        // 世界上方向
        class_243 up = new class_243(0, 1, 0);

        // 玩家右方向
        class_243 right = forward.method_1036(up);
        if (right.method_1033() < 0.001) {
            right = forward.method_1036(new class_243(0, 0, 1));
        }
        right = right.method_1029();

        // 前方偏移
        double forwardDist = Math.max(offsetDist, 2.0);

        for (int row = 0; row < height; row++) {
            for (int col = 0; col < width; col++) {
                if (chars[row][col] != '#') continue;

                // 局部坐标 Y–Z 平面
                double localUp = centerY - row;    // 垂直
                double localRight = col - centerX; // 横向

                // 世界坐标
                class_243 spawnPos = new class_243(x, y, z)
                        .method_1019(forward.method_1021(forwardDist))       // 前方偏移
                        .method_1019(right.method_1021(localRight))          // 横向
                        .method_1019(up.method_1021(localUp));               // 垂直

                DanmakuEntity e = spawnByItemStack(world, livingEntity,
                        spawnPos.field_1352, spawnPos.field_1351, spawnPos.field_1350,
                        stack, pitch, yaw, divergence, offsetDist);

//                if (e != null)
//                    System.out.printf("(%.3f, %.3f, %.3f)%n",
//                            spawnPos.x - x, spawnPos.y - y, spawnPos.z - z);
            }
            System.out.println();
        }
    }
}
