package cc.thonly.reverie_dreams.datagen;

import cc.thonly.reverie_dreams.datagen.generator.AbstractIngredientProvider;
import cc.thonly.reverie_dreams.registry.content.FoodProperties;
import cc.thonly.reverie_dreams.registry.content.block.RDBlocks;
import cc.thonly.reverie_dreams.registry.content.item.RDFoodItems;
import cc.thonly.reverie_dreams.registry.content.item.RDIngredientItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_1802;
import net.minecraft.class_7225;
import java.util.concurrent.CompletableFuture;

public class IngredientProvider extends AbstractIngredientProvider {
    public IngredientProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> future) {
        super(output, future);
    }

    @Override
    protected void configured() {
        this.generateFoodIngredient();
        this.generateFoodItem();
    }

    private void generateFoodIngredient() {
        this.createFactory(FoodProperties.AQUATIC_PRODUCTS)
                .add(RDIngredientItems.TROUT)
                .add(RDIngredientItems.HAGFISH)
                .add(RDIngredientItems.SALMON)
                .add(RDIngredientItems.TUNA)
                .add(RDIngredientItems.SUPREME_TUNA)
                .add(class_1802.field_8323)
                .add(RDIngredientItems.SHRIMP)
                .add(RDIngredientItems.OCTOPUS)
                .add(RDIngredientItems.SEA_URCHIN)
                .add(RDIngredientItems.CRAB)
                .build();
        this.createFactory(FoodProperties.BIZARRE)
                .add(RDIngredientItems.CICADA_SHELL)
                .build();
        this.createFactory(FoodProperties.CHINESE_STYLE)
                .build();
        this.createFactory(FoodProperties.COOL)
                .add(RDBlocks.MAGIC_ICE_BLOCK.method_8389())
                .add(RDIngredientItems.FICUS_MICROCARPA)
                .build();
        this.createFactory(FoodProperties.CURSE)
                .add(RDIngredientItems.PUFF_YO_FRUIT)
                .add(RDIngredientItems.CAPSAICIN)
                .build();
        this.createFactory(FoodProperties.CULTURAL_DEPTH)
                .add(RDIngredientItems.MOONFLOWER)
                .add(RDIngredientItems.TWIN_LOTUS)
                .add(RDIngredientItems.LOTUS_NUTS)
                .build();
        this.createFactory(FoodProperties.DARK_CUISINE)
                .build();
        this.createFactory(FoodProperties.DREAMLIKE)
                .add(RDIngredientItems.UDUMBARA)
                .add(RDIngredientItems.MOONFLOWER)
                .add(RDIngredientItems.TWIN_LOTUS)
                .add(RDIngredientItems.FLOWERS)
                .add(RDIngredientItems.FICUS_MICROCARPA)
                .build();
        this.createFactory(FoodProperties.ECONOMICAL)
                .build();
        this.createFactory(FoodProperties.EXPENSIVE)
                .build();
        this.createFactory(FoodProperties.FIERY)
                .add(RDIngredientItems.CHILI)
                .build();
        this.createFactory(FoodProperties.FILLING)
                .add(class_1802.field_17518)
                .add(RDIngredientItems.FLOUR)
                .add(RDIngredientItems.SWEET_POTATO)
                .add(class_1802.field_8116)
                .build();
        this.createFactory(FoodProperties.FLAMING)
                .build();
        this.createFactory(FoodProperties.FRUITY)
                .add(RDIngredientItems.PEACH)
                .add(RDIngredientItems.GRAPE)
                .add(RDIngredientItems.LEMON)
                .build();
        this.createFactory(FoodProperties.GOURMET)
                .add(RDIngredientItems.SALMON)
                .add(RDIngredientItems.TUNA)
                .add(RDIngredientItems.WAGYU_BEEF)
                .add(RDIngredientItems.TRUFFLE)
                .add(RDIngredientItems.SUPREME_TUNA)
                .add(RDIngredientItems.UDUMBARA)
                .add(RDIngredientItems.SEA_URCHIN)
                .add(RDIngredientItems.CRAB)
                .add(RDIngredientItems.TWIN_LOTUS)
                .add(RDIngredientItems.CHEESE)
                .add(RDIngredientItems.PINE_NUT)
                .build();
        this.createFactory(FoodProperties.GREASY)
                .add(RDIngredientItems.BUTTER)
                .build();
        this.createFactory(FoodProperties.GRILLED)
                .build();
        this.createFactory(FoodProperties.GOOD_WITH_ALCOHOL)
                .add(RDIngredientItems.WHITE_RADISH)
                .add(RDFoodItems.COLD_TOFU)
                .add(RDFoodItems.PICKLED_CUCUMBERS)
                .build();
        this.createFactory(FoodProperties.HOMESTYLE)
                .add(RDIngredientItems.TOFU)
                .add(class_1802.field_8567)
                .add(RDIngredientItems.CUCUMBER)
                .add(RDIngredientItems.CREAM)
                .add(RDIngredientItems.CHESTNUT)
                .add(RDIngredientItems.RED_BEANS)
                .add(RDIngredientItems.BROCCOLI)
                .build();
        this.createFactory(FoodProperties.JAPANESE_STYLE)
                .build();
        this.createFactory(FoodProperties.LARGE_PARTITION)
                .build();
        this.createFactory(FoodProperties.LEGENDARY)
                .add(RDIngredientItems.BLACK_PORK)
                .add(RDIngredientItems.WAGYU_BEEF)
                .add(RDIngredientItems.TRUFFLE)
                .add(RDIngredientItems.SUPREME_TUNA)
                .add(RDIngredientItems.UDUMBARA)
                .add(RDIngredientItems.SEA_URCHIN)
                .add(RDIngredientItems.TWIN_LOTUS)
                .build();
        this.createFactory(FoodProperties.LIGHT)
                .add(RDIngredientItems.TOFU)
                .add(RDIngredientItems.DEW)
                .add(RDIngredientItems.BAMBOO_SHOOTS)
                .add(RDIngredientItems.MOONFLOWER)
                .add(RDIngredientItems.CUCUMBER)
                .add(RDIngredientItems.TWIN_LOTUS)
                .add(RDIngredientItems.LOTUS_NUTS)
                .add(RDIngredientItems.PINE_NUT)
                .add(RDIngredientItems.TREMELLA)
                .build();
        this.createFactory(FoodProperties.LOCAL_SPECIALTY)
                .build();
        this.createFactory(FoodProperties.MEAT)
                .add(class_1802.field_8389)
                .add(class_1802.field_8046)
                .add(RDIngredientItems.VENISON)
                .add(RDIngredientItems.WILD_BOAR_MEAT)
                .add(RDIngredientItems.BLACK_PORK)
                .add(RDIngredientItems.WAGYU_BEEF)
                .build();
        this.createFactory(FoodProperties.MUSHROOMS)
                .add(class_1802.field_17517)
                .add(class_1802.field_17516)
                .add(RDIngredientItems.TRUFFLE)
                .add(RDIngredientItems.TREMELLA)
                .build();
        this.createFactory(FoodProperties.MOUNTAIN_DELICACY)
                .add(RDIngredientItems.BLACK_PORK)
                .add(RDIngredientItems.TRUFFLE)
                .build();
        this.createFactory(FoodProperties.OCEAN_FLAVOR)
                .add(RDIngredientItems.SUPREME_TUNA)
                .add(class_1802.field_8323)
                .add(RDIngredientItems.OCTOPUS)
                .add(RDIngredientItems.SEA_URCHIN)
                .build();
        this.createFactory(FoodProperties.PETITE)
                .add(RDIngredientItems.PLUM)
                .build();
        this.createFactory(FoodProperties.PHOTOGENIC)
                .add(RDIngredientItems.GINKGO)
                .add(class_1802.field_8648)
                .add(RDIngredientItems.FLOWERS)
                .build();
        this.createFactory(FoodProperties.POPULAR_NEGATIVE)
                .build();
        this.createFactory(FoodProperties.POPULAR_POSITIVE)
                .build();
        this.createFactory(FoodProperties.POWER_SURGE)
                .build();
        this.createFactory(FoodProperties.RAW)
                .add(class_1802.field_8803)
                .build();
        this.createFactory(FoodProperties.SALTY)
                .add(RDIngredientItems.BLACK_SALT)
                .add(RDIngredientItems.CHEESE)
                .add(RDIngredientItems.PLUM)
                .build();
        this.createFactory(FoodProperties.SIGNATURE)
                .add(RDIngredientItems.HAGFISH)
                .add(RDIngredientItems.LOTUS_NUTS)
                .add(RDIngredientItems.PINE_NUT)
                .build();
        this.createFactory(FoodProperties.SOUR)
                .add(RDIngredientItems.LEMON)
                .build();
        this.createFactory(FoodProperties.SPICY)
                .add(RDIngredientItems.CHILI)
                .build();
        this.createFactory(FoodProperties.SWEET)
                .add(RDIngredientItems.PEACH)
                .add(class_1802.field_20417)
                .add(RDIngredientItems.GRAPE)
                .add(RDIngredientItems.CREAM)
                .build();
        this.createFactory(FoodProperties.SOUP_AND_STEW)
                .build();
        this.createFactory(FoodProperties.TOXIC)
                .add(RDIngredientItems.TOON)
                .build();
        this.createFactory(FoodProperties.UMAMI)
                .add(RDIngredientItems.ONION)
                .add(RDIngredientItems.TROUT)
                .add(RDIngredientItems.HAGFISH)
                .add(RDIngredientItems.SALMON)
                .add(RDIngredientItems.TUNA)
                .add(class_1802.field_17517)
                .add(class_1802.field_17516)
                .add(RDIngredientItems.TRUFFLE)
                .add(RDIngredientItems.SUPREME_TUNA)
                .add(class_1802.field_8323)
                .add(RDIngredientItems.SHRIMP)
                .add(RDIngredientItems.OCTOPUS)
                .add(RDIngredientItems.SEA_URCHIN)
                .add(RDIngredientItems.CRAB)
                .add(RDIngredientItems.CHEESE)
                .build();
        this.createFactory(FoodProperties.UNBELIEVABLE)
                .add(RDIngredientItems.UDUMBARA)
                .add(RDIngredientItems.MOONFLOWER)
                .add(class_1802.field_8116)
                .build();
        this.createFactory(FoodProperties.VEGETARIAN)
                .add(RDIngredientItems.TOFU)
                .add(class_1802.field_8567)
                .add(RDIngredientItems.ONION)
                .add(class_1802.field_17518)
                .add(RDIngredientItems.WHITE_RADISH)
                .add(class_1802.field_17532)
                .add(class_1802.field_17517)
                .add(class_1802.field_17516)
                .add(RDIngredientItems.TRUFFLE)
                .add(RDIngredientItems.BAMBOO_SHOOTS)
                .add(RDIngredientItems.CUCUMBER)
                .add(RDIngredientItems.CHESTNUT)
                .add(RDIngredientItems.TOON)
                .add(RDIngredientItems.TOMATO)
                .add(RDIngredientItems.BROCCOLI)
                .build();
        this.createFactory(FoodProperties.WESTERN_STYLE)
                .add(RDIngredientItems.CREAM)
                .build();
    }

    private void generateFoodItem() {
        this.createFactory(FoodProperties.AQUATIC_PRODUCTS)
                .add(RDFoodItems.PORK_AND_TROUT_SMOKED)
                .add(RDFoodItems.GRILLED_HAGFISH)
                .add(RDFoodItems.WARM_RICE_BALL)
                .add(RDFoodItems.FAILING_SAKURA_SNOW)
                .add(RDFoodItems.BRAISED_EEL)
                .add(RDFoodItems.FRIED_HAGFISH)
                .add(RDFoodItems.SNOW_WHITE)
                .add(RDFoodItems.SASHIMI_PLATTER)
                .add(RDFoodItems.GRAND_BANQUET)
                .add(RDFoodItems.MAGMA)
                .add(RDFoodItems.BEAR_PAW)
                .add(RDFoodItems.SECRET_DRIED_FISH)
                .add(RDFoodItems.ARCTIC_SWEET_SHRIMP_AND_PEACH_SALAD)
                .add(RDFoodItems.REAL_SEAFOOD_MISO_SOUP)
                .add(RDFoodItems.BOILED_FISH)
                .add(RDFoodItems.GOLDEN_CRISPY_FISH_CAKE)
                .add(RDFoodItems.TAKOYAKI)
                .add(RDFoodItems.MUSHROOM_GIRLS_DANCE_STEW)
                .add(RDFoodItems.NIGIRI_SUSHI)
                .add(RDFoodItems.PUMPKIN_SHRIMP_CAKE)
                .add(RDFoodItems.GENSOKYO_BUDDHA_JUMPS_OVER_THE_WALL)
                .add(RDFoodItems.OEDO_BOAT_FESTIVAL)
                .add(RDFoodItems.CAT_FOOD)
                .add(RDFoodItems.SALMON_TEMPURA)
                .add(RDFoodItems.FISH_LEAPS_OVER_DRAGON_GATE)
                .add(RDFoodItems.TAICHI_BAGUA_FISH_MAW)
                .add(RDFoodItems.LOTUS_FISH_RICE_BOWL)
                .add(RDFoodItems.THE_BEAUTY_OF_HAN_PALACE)
                .add(RDFoodItems.POISONOUS_GARDEN)
                .add(RDFoodItems.EEL_EGG_DONBURI)
                .add(RDFoodItems.BAMBOO_TUBE_ROASTED_DRUNKEN_SHRIMP)
                .add(RDFoodItems.RAPUNZEL)
                .add(RDFoodItems.SEA_URCHIN_SHINGEN_PANCAKE)
                .add(RDFoodItems.THE_MARS)
                .add(RDFoodItems.SUPERME_SEAFOOD_NOODLES)
                .build();
        this.createFactory(FoodProperties.BIZARRE)
                .add(RDFoodItems.STINKY_TOFU)
                .add(RDFoodItems.SCARLET_DEVILS_CAKE)
                .add(RDFoodItems.PSEUDO_JIRITAMA)
                .add(RDFoodItems.CRISP_CYCLONE)
                .add(RDFoodItems.LOOKING_UP_AT_THE_CEILING_FRUIT_PIE)
                .add(RDFoodItems.BEETLE_STEAMED_CAKE)
                .add(RDFoodItems.HELL_THRILL_WARNING)
                .add(RDFoodItems.SKINNY_HORSE_DUMPLING)
                .add(RDFoodItems.FRIED_TOMATO_STRIPS)
                .add(RDFoodItems.REVERSING_THE_WORLD)
                .add(RDFoodItems.THE_BEAUTY_OF_HAN_PALACE)
                .add(RDFoodItems.POISONOUS_GARDEN)
                .add(RDFoodItems.BAMBOO_TUBE_ROASTED_DRUNKEN_SHRIMP)
                .build();
        this.createFactory(FoodProperties.CHINESE_STYLE)
                .add(RDFoodItems.FRIED_PORK_SHREDS)
                .add(RDFoodItems.POETRY_AND_GINKGO)
                .add(RDFoodItems.HONEY_BBQ_PORK)
                .add(RDFoodItems.GINKGO_AND_RADISH_PORK_RIB_SOUP)
                .add(RDFoodItems.STINKY_TOFU)
                .add(RDFoodItems.COLORFUL_JADE_FRIED_BUNS)
                .add(RDFoodItems.MAPO_TOFU)
                .add(RDFoodItems.BOILED_FISH)
                .add(RDFoodItems.MAOYU_LAVA_TOFU)
                .add(RDFoodItems.DUMPLING)
                .add(RDFoodItems.GLUTINOUS_RICE_BALLS)
                .add(RDFoodItems.GENSOKYO_BUDDHA_JUMPS_OVER_THE_WALL)
                .add(RDFoodItems.FISH_LEAPS_OVER_DRAGON_GATE)
                .add(RDFoodItems.TIANSHI_BRAISED_CHESTNUT_MUSHROOMS)
                .add(RDFoodItems.LOTUS_FISH_RICE_BOWL)
                .add(RDFoodItems.THE_BEAUTY_OF_HAN_PALACE)
                .add(RDFoodItems.BEEF_HOT_POT)
                .add(RDFoodItems.MOONLIGHT_OVER_LOTUS_POND)
                .add(RDFoodItems.HULA_SOUP)
                .build();
        this.createFactory(FoodProperties.COOL)
                .add(RDFoodItems.VEGETABLE_SPECIAL)
                .add(RDFoodItems.COLD_DISH_CARVING)
                .add(RDFoodItems.PEACH_BLOSSOM_SOUP)
                .add(RDFoodItems.FLOWING_WATER_NOODLES)
                .add(RDFoodItems.MAOYU_TRICOLOR_ICE_CREAM)
                .add(RDFoodItems.SAKURA_PUDDING)
                .add(RDFoodItems.REFRESHING_PUDDING)
                .add(RDFoodItems.BURNT_PUDDING)
                .add(RDFoodItems.LUOHAN_VEGETARIAN)
                .add(RDFoodItems.GENSOKYO_STAR_LOTUS_SHIP)
                .add(RDFoodItems.TAICHI_BAGUA_FISH_MAW)
                .add(RDFoodItems.REVERSING_THE_WORLD)
                .add(RDFoodItems.THE_DREAM)
                .add(RDFoodItems.CATS_PLAYING_IN_WATER)
                .add(RDFoodItems.SEA_URCHIN_SHINGEN_PANCAKE)
                .add(RDFoodItems.MOONLIGHT_OVER_LOTUS_POND)
                .add(RDFoodItems.LONGYIN_PEACH)
                .build();
        this.createFactory(FoodProperties.CURSE)
                .add(RDFoodItems.POISONOUS_GARDEN)
                .build();
        this.createFactory(FoodProperties.CULTURAL_DEPTH)
                .add(RDFoodItems.TWO_HEAVENS_ONE_STYLE)
                .add(RDFoodItems.SNOW_WHITE)
                .add(RDFoodItems.POETRY_AND_GINKGO)
                .add(RDFoodItems.TAKETORIHIME)
                .add(RDFoodItems.PIG_DEER_BUTTERFLY)
                .add(RDFoodItems.HORAI_DAMA_NO_EDA)
                .add(RDFoodItems.MOON_CAKE)
                .add(RDFoodItems.DUMPLING)
                .add(RDFoodItems.GLUTINOUS_RICE_BALLS)
                .add(RDFoodItems.ORDINARY_SMALL_CAKE)
                .add(RDFoodItems.SEVEN_COLORED_YOKAN)
                .add(RDFoodItems.NIGIRI_SUSHI)
                .add(RDFoodItems.GENSOKYO_BUDDHA_JUMPS_OVER_THE_WALL)
                .add(RDFoodItems.OEDO_BOAT_FESTIVAL)
                .add(RDFoodItems.FISH_LEAPS_OVER_DRAGON_GATE)
                .add(RDFoodItems.SKINNY_HORSE_DUMPLING)
                .add(RDFoodItems.LUOHAN_VEGETARIAN)
                .add(RDFoodItems.SHIRAGA_SADAMATSU)
                .add(RDFoodItems.TAICHI_BAGUA_FISH_MAW)
                .add(RDFoodItems.LOTUS_FISH_RICE_BOWL)
                .add(RDFoodItems.THE_BEAUTY_OF_HAN_PALACE)
                .add(RDFoodItems.GREEN_BAMBOO_WELCOMES_SPRING)
                .add(RDFoodItems.GREEN_FAIRY_MUSHROOM)
                .add(RDFoodItems.MOONLIGHT_OVER_LOTUS_POND)
                .add(RDFoodItems.THE_MARS)
                .build();
        this.createFactory(FoodProperties.DARK_CUISINE)
                .add(RDFoodItems.DARK_CUISINE)
                .build();
        this.createFactory(FoodProperties.DREAMLIKE)
                .add(RDFoodItems.UDUMBARA_CAKE)
                .add(RDFoodItems.COLORFUL_JADE_FRIED_BUNS)
                .add(RDFoodItems.MAOYU_TRICOLOR_ICE_CREAM)
                .add(RDFoodItems.SCARLET_DEVILS_CAKE)
                .add(RDFoodItems.UNCONSCIOUS_MONSTER_MOUSSE)
                .add(RDFoodItems.PSEUDO_JIRITAMA)
                .add(RDFoodItems.SEVEN_COLORED_YOKAN)
                .add(RDFoodItems.BURNT_PUDDING)
                .add(RDFoodItems.FISH_LEAPS_OVER_DRAGON_GATE)
                .add(RDFoodItems.FRIGHT_ADVENTURE)
                .add(RDFoodItems.LUOHAN_VEGETARIAN)
                .add(RDFoodItems.GENSOKYO_STAR_LOTUS_SHIP)
                .add(RDFoodItems.LOTUS_FISH_RICE_BOWL)
                .add(RDFoodItems.REVERSING_THE_WORLD)
                .add(RDFoodItems.FLOWERS_BIRDS_WIND_AND_MOON)
                .add(RDFoodItems.THE_DREAM)
                .add(RDFoodItems.A_LITTLE_SWEET_POISON)
                .add(RDFoodItems.CATS_PLAYING_IN_WATER)
                .add(RDFoodItems.SEA_URCHIN_SHINGEN_PANCAKE)
                .add(RDFoodItems.MAD_HATTER_TEA_PARTY)
                .add(RDFoodItems.PEACH_BLOSSOM_GLAZE_ROLL)
                .build();
        this.createFactory(FoodProperties.ECONOMICAL)
                .add(RDFoodItems.SEAFOOD_MISO_SOUP)
                .add(RDFoodItems.RICE_BALL)
                .add(RDFoodItems.PORK_RICE)
                .add(RDFoodItems.FRIED_PORK_SHREDS)
                .add(RDFoodItems.TOFU_POT)
                .add(RDFoodItems.BISCAY_BISCUITS)
                .add(RDFoodItems.FRIED_TOFU)
                .add(RDFoodItems.ROASTED_MUSHROOMS)
                .add(RDFoodItems.PICKLED_CUCUMBERS)
                .build();
        this.createFactory(FoodProperties.EXPENSIVE)
                .add(RDFoodItems.GAME_SOUP)
                .add(RDFoodItems.TWO_HEAVENS_ONE_STYLE)
                .add(RDFoodItems.SNOW_WHITE)
                .add(RDFoodItems.SASHIMI_PLATTER)
                .add(RDFoodItems.GRAND_BANQUET)
                .add(RDFoodItems.MAGMA)
                .add(RDFoodItems.DEW_BOILED_EGGS)
                .add(RDFoodItems.UDUMBARA_CAKE)
                .add(RDFoodItems.BEAR_PAW)
                .add(RDFoodItems.RISOTTO)
                .add(RDFoodItems.BEEF_WELLINGTON)
                .add(RDFoodItems.HONEY_BBQ_PORK)
                .add(RDFoodItems.GINKGO_AND_RADISH_PORK_RIB_SOUP)
                .add(RDFoodItems.TAKETORIHIME)
                .add(RDFoodItems.PHOENIX)
                .add(RDFoodItems.MOONLIGHT_DUMPLINGS)
                .add(RDFoodItems.MOON_LOVERS)
                .add(RDFoodItems.PIG_DEER_BUTTERFLY)
                .add(RDFoodItems.FLOWING_WATER_NOODLES)
                .add(RDFoodItems.HORAI_DAMA_NO_EDA)
                .add(RDFoodItems.COLORFUL_JADE_FRIED_BUNS)
                .add(RDFoodItems.BOILED_FISH)
                .add(RDFoodItems.MAOYU_TRICOLOR_ICE_CREAM)
                .add(RDFoodItems.MAOYU_LAVA_TOFU)
                .add(RDFoodItems.ALL_MEAT_FEAST)
                .add(RDFoodItems.BAKED_CRAB_WITH_CREAM)
                .add(RDFoodItems.PSEUDO_JIRITAMA)
                .add(RDFoodItems.SEA_URCHIN_SHINGEN_PANCAKE)
                .add(RDFoodItems.SECRET_MUSHROOM_CASSEROLE)
                .add(RDFoodItems.MUSHROOM_GIRLS_DANCE_STEW)
                .add(RDFoodItems.SEVEN_COLORED_YOKAN)
                .add(RDFoodItems.GENSOKYO_BUDDHA_JUMPS_OVER_THE_WALL)
                .add(RDFoodItems.SCREAMING_ODEN)
                .add(RDFoodItems.LOOKING_UP_AT_THE_CEILING_FRUIT_PIE)
                .add(RDFoodItems.BEETLE_STEAMED_CAKE)
                .add(RDFoodItems.OEDO_BOAT_FESTIVAL)
                .add(RDFoodItems.BURNT_PUDDING)
                .add(RDFoodItems.FISH_LEAPS_OVER_DRAGON_GATE)
                .add(RDFoodItems.ONE_HIT_KILL)
                .add(RDFoodItems.HELL_THRILL_WARNING)
                .add(RDFoodItems.FRIGHT_ADVENTURE)
                .add(RDFoodItems.LUOHAN_VEGETARIAN)
                .add(RDFoodItems.GENSOKYO_STAR_LOTUS_SHIP)
                .add(RDFoodItems.SHIRAGA_SADAMATSU)
                .add(RDFoodItems.TAICHI_BAGUA_FISH_MAW)
                .add(RDFoodItems.LOTUS_FISH_RICE_BOWL)
                .add(RDFoodItems.PAN_FRIED_MUSHROOM_MEAT_ROLL)
                .add(RDFoodItems.ASSORTED_TEMPURA)
                .add(RDFoodItems.REVERSING_THE_WORLD)
                .add(RDFoodItems.THE_BEAUTY_OF_HAN_PALACE)
                .add(RDFoodItems.BAMBOO_TUBE_STEAMED_PORK)
                .add(RDFoodItems.GREEN_BAMBOO_WELCOMES_SPRING)
                .add(RDFoodItems.STEAMED_EGG_WITH_SEA_URCHIN)
                .add(RDFoodItems.FANTASY_IS_ALL_THE_RAGE)
                .add(RDFoodItems.FLOWERS_BIRDS_WIND_AND_MOON)
                .add(RDFoodItems.A_LITTLE_SWEET_POISON)
                .add(RDFoodItems.BEEF_HOT_POT)
                .add(RDFoodItems.CAT_PIZZA)
                .add(RDFoodItems.CATS_PLAYING_IN_WATER)
                .add(RDFoodItems.SEA_URCHIN_SHINGEN_PANCAKE)
                .add(RDFoodItems.MAD_HATTER_TEA_PARTY)
                .add(RDFoodItems.VEGETABLE_SPECIAL)
                .add(RDFoodItems.MOONLIGHT_OVER_LOTUS_POND)
                .add(RDFoodItems.LONGYIN_PEACH)
                .add(RDFoodItems.MOLECULAR_EGG)
                .add(RDFoodItems.THE_SOURCE_OF_LIFE)
                .add(RDFoodItems.THE_MARS)
                .add(RDFoodItems.SUPERME_SEAFOOD_NOODLES)
                .build();
        this.createFactory(FoodProperties.FIERY)
                .add(RDFoodItems.STRENGTH_SOUP)
                .add(RDFoodItems.WARM_RICE_BALL)
                .add(RDFoodItems.GAME_SOUP)
                .add(RDFoodItems.TOFU_POT)
                .add(RDFoodItems.ZHAJI)
                .add(RDFoodItems.MAGMA)
                .add(RDFoodItems.ROASTED_MUSHROOMS)
                .add(RDFoodItems.GINKGO_AND_RADISH_PORK_RIB_SOUP)
                .add(RDFoodItems.MAPO_TOFU)
                .add(RDFoodItems.BOILED_FISH)
                .add(RDFoodItems.ALL_MEAT_FEAST)
                .add(RDFoodItems.PSEUDO_JIRITAMA)
                .add(RDFoodItems.MUSHROOM_GIRLS_DANCE_STEW)
                .add(RDFoodItems.SCREAMING_ODEN)
                .add(RDFoodItems.HELL_THRILL_WARNING)
                .add(RDFoodItems.BISCAY_BISCUITS)
                .add(RDFoodItems.PAN_FRIED_MUSHROOM_MEAT_ROLL)
                .add(RDFoodItems.BEEF_HOT_POT)
                .add(RDFoodItems.HULA_SOUP)
                .build();
        this.createFactory(FoodProperties.FILLING)
                .add(RDFoodItems.ENERGY_STRING)
                .add(RDFoodItems.RICE_BALL)
                .add(RDFoodItems.GAME_SOUP)
                .add(RDFoodItems.PORK_RICE)
                .add(RDFoodItems.BEEF_RICE)
                .add(RDFoodItems.GRAND_BANQUET)
                .add(RDFoodItems.TONKOTSU_RAMEN)
                .add(RDFoodItems.MAGMA)
                .add(RDFoodItems.FRIED_PORK_CUTLET)
                .add(RDFoodItems.BUTTER_STEAK)
                .add(RDFoodItems.RISOTTO)
                .add(RDFoodItems.EGGS_BENEDICT)
                .add(RDFoodItems.HOT_WAFFLES)
                .add(RDFoodItems.MOON_CAKE)
                .add(RDFoodItems.TAKOYAKI)
                .add(RDFoodItems.PUMPKIN_SHRIMP_CAKE)
                .add(RDFoodItems.SCREAMING_ODEN)
                .add(RDFoodItems.CRISP_CYCLONE)
                .add(RDFoodItems.BEETLE_STEAMED_CAKE)
                .add(RDFoodItems.GIANT_TAMAGOYAKI)
                .add(RDFoodItems.ONE_HIT_KILL)
                .add(RDFoodItems.BAKED_SWEET_POTATOES)
                .add(RDFoodItems.BISCAY_BISCUITS)
                .add(RDFoodItems.CANDIED_SWEET_POTATO)
                .add(RDFoodItems.BAMBOO_SHOOTS_STEWED_IN_STONE_POT)
                .add(RDFoodItems.FANTASY_IS_ALL_THE_RAGE)
                .add(RDFoodItems.CAT_KULULI)
                .add(RDFoodItems.CAT_PIZZA)
                .add(RDFoodItems.RAPUNZEL)
                .add(RDFoodItems.WARM_RICE_BALL)
                .add(RDFoodItems.SKINNY_HORSE_DUMPLING)
                .add(RDFoodItems.SUPERME_SEAFOOD_NOODLES)
                .build();
        this.createFactory(FoodProperties.FLAMING)
                .add(RDFoodItems.PHOENIX)
                .add(RDFoodItems.BOILED_FISH)
                .add(RDFoodItems.REVERSING_THE_WORLD)
                .add(RDFoodItems.TWO_HEAVENS_ONE_STYLE)
                .add(RDFoodItems.HULA_SOUP)
                .build();
        this.createFactory(FoodProperties.FRUITY)
                .add(RDFoodItems.PEACH_BLOSSOM_SOUP)
                .add(RDFoodItems.ARCTIC_SWEET_SHRIMP_AND_PEACH_SALAD)
                .add(RDFoodItems.WHITE_PEACH_EIGHT_BRIDGE)
                .add(RDFoodItems.MILKY_MUSHROOM_SOUP)
                .add(RDFoodItems.ORDINARY_SMALL_CAKE)
                .add(RDFoodItems.SEVEN_COLORED_YOKAN)
                .add(RDFoodItems.GLOOMY_FRUIT_PIE)
                .add(RDFoodItems.SAKURA_PUDDING)
                .add(RDFoodItems.REFRESHING_PUDDING)
                .add(RDFoodItems.BURNT_PUDDING)
                .add(RDFoodItems.YUNSHAN_COTTON_CANDY)
                .add(RDFoodItems.BRAISED_PORK_WITH_PEACH)
                .add(RDFoodItems.LONGYIN_PEACH)
                .add(RDFoodItems.THE_MARS)
                .build();
        this.createFactory(FoodProperties.GOURMET)
                .add(RDFoodItems.TWO_HEAVENS_ONE_STYLE)
                .add(RDFoodItems.FAILING_SAKURA_SNOW)
                .add(RDFoodItems.SNOW_WHITE)
                .add(RDFoodItems.SASHIMI_PLATTER)
                .add(RDFoodItems.GRAND_BANQUET)
                .add(RDFoodItems.MAGMA)
                .add(RDFoodItems.UDUMBARA_CAKE)
                .add(RDFoodItems.BEAR_PAW)
                .add(RDFoodItems.BEEF_WELLINGTON)
                .add(RDFoodItems.TAKETORIHIME)
                .add(RDFoodItems.PHOENIX)
                .add(RDFoodItems.PIG_DEER_BUTTERFLY)
                .add(RDFoodItems.HORAI_DAMA_NO_EDA)
                .add(RDFoodItems.COLORFUL_JADE_FRIED_BUNS)
                .add(RDFoodItems.UNCONSCIOUS_MONSTER_MOUSSE)
                .add(RDFoodItems.ALL_MEAT_FEAST)
                .add(RDFoodItems.BAKED_CRAB_WITH_CREAM)
                .add(RDFoodItems.SEA_URCHIN_SHINGEN_PANCAKE)
                .add(RDFoodItems.MILKY_MUSHROOM_SOUP)
                .add(RDFoodItems.ORDINARY_SMALL_CAKE)
                .add(RDFoodItems.SEVEN_COLORED_YOKAN)
                .add(RDFoodItems.GENSOKYO_BUDDHA_JUMPS_OVER_THE_WALL)
                .add(RDFoodItems.SCREAMING_ODEN)
                .add(RDFoodItems.BEETLE_STEAMED_CAKE)
                .add(RDFoodItems.GIANT_TAMAGOYAKI)
                .add(RDFoodItems.OEDO_BOAT_FESTIVAL)
                .add(RDFoodItems.SALMON_TEMPURA)
                .add(RDFoodItems.FISH_LEAPS_OVER_DRAGON_GATE)
                .add(RDFoodItems.LUOHAN_VEGETARIAN)
                .add(RDFoodItems.GENSOKYO_STAR_LOTUS_SHIP)
                .add(RDFoodItems.TAICHI_BAGUA_FISH_MAW)
                .add(RDFoodItems.THE_BEAUTY_OF_HAN_PALACE)
                .add(RDFoodItems.GREEN_BAMBOO_WELCOMES_SPRING)
                .add(RDFoodItems.THE_DREAM)
                .add(RDFoodItems.A_LITTLE_SWEET_POISON)
                .add(RDFoodItems.SEA_URCHIN_SHINGEN_PANCAKE)
                .add(RDFoodItems.LONGYIN_PEACH)
                .add(RDFoodItems.SHIRAGA_SADAMATSU)
                .add(RDFoodItems.FLOWERS_BIRDS_WIND_AND_MOON)
                .add(RDFoodItems.PEACH_BLOSSOM_GLAZE_ROLL)
                .add(RDFoodItems.MOONLIGHT_OVER_LOTUS_POND)
                .add(RDFoodItems.MOLECULAR_EGG)
                .add(RDFoodItems.THE_SOURCE_OF_LIFE)
                .add(RDFoodItems.THE_MARS)
                .add(RDFoodItems.SUPERME_SEAFOOD_NOODLES)
                .build();
        this.createFactory(FoodProperties.GREASY)
                .add(RDFoodItems.FRIED_PORK_SHREDS)
                .add(RDFoodItems.BRAISED_EEL)
                .add(RDFoodItems.POTATO_CROQUETTES)
                .add(RDFoodItems.GAME_SOUP)
                .add(RDFoodItems.FRIED_HAGFISH)
                .add(RDFoodItems.BISCAY_BISCUITS)
                .add(RDFoodItems.FRIED_TOFU)
                .add(RDFoodItems.FRIED_PORK_CUTLET)
                .add(RDFoodItems.BUTTER_STEAK)
                .add(RDFoodItems.HONEY_BBQ_PORK)
                .add(RDFoodItems.FRIED_SHRIMP_TEMPURA)
                .add(RDFoodItems.GOLDEN_CRISPY_FISH_CAKE)
                .add(RDFoodItems.MUSHROOM_GIRLS_DANCE_STEW)
                .add(RDFoodItems.SALMON_TEMPURA)
                .add(RDFoodItems.CHEESE_EGG)
                .add(RDFoodItems.ONE_HIT_KILL)
                .add(RDFoodItems.HELL_THRILL_WARNING)
                .add(RDFoodItems.PAN_FRIED_MUSHROOM_MEAT_ROLL)
                .add(RDFoodItems.ASSORTED_TEMPURA)
                .add(RDFoodItems.FANTASY_IS_ALL_THE_RAGE)
                .build();
        this.createFactory(FoodProperties.GRILLED)
                .add(RDFoodItems.PORK_AND_TROUT_SMOKED)
                .add(RDFoodItems.GRILLED_HAGFISH)
                .add(RDFoodItems.ENERGY_STRING)
                .add(RDFoodItems.TWO_HEAVENS_ONE_STYLE)
                .add(RDFoodItems.ROASTED_MUSHROOMS)
                .add(RDFoodItems.PHOENIX)
                .add(RDFoodItems.HORAI_DAMA_NO_EDA)
                .add(RDFoodItems.ONE_HIT_KILL)
                .build();
        this.createFactory(FoodProperties.GOOD_WITH_ALCOHOL)
                .add(RDFoodItems.FRIED_PORK_SHREDS)
                .add(RDFoodItems.BAMBOO_SHOOTS_FRIED_MEAT)
                .add(RDFoodItems.FRIED_SHRIMP_TEMPURA)
                .add(RDFoodItems.GOLDEN_CRISPY_FISH_CAKE)
                .add(RDFoodItems.ALL_MEAT_FEAST)
                .add(RDFoodItems.PSEUDO_JIRITAMA)
                .add(RDFoodItems.DEPRESSED_CHEESE_STICKS)
                .add(RDFoodItems.LOOKING_UP_AT_THE_CEILING_FRUIT_PIE)
                .add(RDFoodItems.LION_HEAD)
                .add(RDFoodItems.OEDO_BOAT_FESTIVAL)
                .add(RDFoodItems.PAN_FRIED_MUSHROOM_MEAT_ROLL)
                .add(RDFoodItems.ASSORTED_TEMPURA)
                .add(RDFoodItems.BRAISED_PORK_WITH_PEACH)
                .build();
        this.createFactory(FoodProperties.HOMESTYLE)
                .add(RDFoodItems.TONKOTSU_RAMEN)
                .add(RDFoodItems.SEAFOOD_MISO_SOUP)
                .add(RDFoodItems.TOFU_MISO)
                .add(RDFoodItems.PORK_AND_TROUT_SMOKED)
                .add(RDFoodItems.RICE_BALL)
                .add(RDFoodItems.WARM_RICE_BALL)
                .add(RDFoodItems.FRIED_PORK_SHREDS)
                .add(RDFoodItems.COLD_TOFU)
                .add(RDFoodItems.POTATO_CROQUETTES)
                .add(RDFoodItems.PORK_RICE)
                .add(RDFoodItems.BEEF_RICE)
                .add(RDFoodItems.ZHAJI)
                .add(RDFoodItems.FRIED_TOFU)
                .add(RDFoodItems.REAL_SEAFOOD_MISO_SOUP)
                .add(RDFoodItems.COOKING_TOFU)
                .add(RDFoodItems.FRIED_PORK_CUTLET)
                .add(RDFoodItems.BAMBOO_SHOOTS_FRIED_MEAT)
                .add(RDFoodItems.BAMBOO_STEAMED_EGG)
                .add(RDFoodItems.DUMPLING)
                .add(RDFoodItems.GLUTINOUS_RICE_BALLS)
                .add(RDFoodItems.MUSHROOM_MEAT_SLICES)
                .add(RDFoodItems.MILKY_MUSHROOM_SOUP)
                .add(RDFoodItems.BAKED_SWEET_POTATOES)
                .add(RDFoodItems.TIANSHI_BRAISED_CHESTNUT_MUSHROOMS)
                .add(RDFoodItems.CANDIED_SWEET_POTATO)
                .add(RDFoodItems.PAN_FRIED_MUSHROOM_MEAT_ROLL)
                .add(RDFoodItems.ASSORTED_TEMPURA)
                .add(RDFoodItems.BAMBOO_SHOOTS_STEWED_IN_STONE_POT)
                .add(RDFoodItems.BAMBOO_TUBE_STEAMED_PORK)
                .add(RDFoodItems.PLUM_TEA_RICE)
                .add(RDFoodItems.BEEF_HOT_POT)
                .add(RDFoodItems.HULA_SOUP)
                .add(RDFoodItems.SUPERME_SEAFOOD_NOODLES)
                .build();
        this.createFactory(FoodProperties.JAPANESE_STYLE)
                .add(RDFoodItems.TOFU_MISO)
                .add(RDFoodItems.RICE_BALL)
                .add(RDFoodItems.PORK_RICE)
                .add(RDFoodItems.WARM_RICE_BALL)
                .add(RDFoodItems.FAILING_SAKURA_SNOW)
                .add(RDFoodItems.SNOW_WHITE)
                .add(RDFoodItems.TOFU_POT)
                .add(RDFoodItems.FRIED_TOFU)
                .add(RDFoodItems.MOONLIGHT_DUMPLINGS)
                .add(RDFoodItems.MOCHI)
                .add(RDFoodItems.WHITE_PEACH_EIGHT_BRIDGE)
                .add(RDFoodItems.OKONOMIYAKI)
                .add(RDFoodItems.SECRET_MUSHROOM_CASSEROLE)
                .add(RDFoodItems.NIGIRI_SUSHI)
                .add(RDFoodItems.GIANT_TAMAGOYAKI)
                .add(RDFoodItems.OEDO_BOAT_FESTIVAL)
                .add(RDFoodItems.ASSORTED_TEMPURA)
                .add(RDFoodItems.RED_BEAN_DAIFUKU)
                .add(RDFoodItems.DORAYAKI)
                .add(RDFoodItems.PLUM_TEA_RICE)
                .add(RDFoodItems.PEACH_BLOSSOM_GLAZE_ROLL)
                .build();
        this.createFactory(FoodProperties.LARGE_PARTITION)
                .add(RDFoodItems.BEEF_WELLINGTON)
                .add(RDFoodItems.TAKETORIHIME)
                .add(RDFoodItems.PHOENIX)
                .add(RDFoodItems.HORAI_DAMA_NO_EDA)
                .add(RDFoodItems.ALL_MEAT_FEAST)
                .add(RDFoodItems.GENSOKYO_BUDDHA_JUMPS_OVER_THE_WALL)
                .add(RDFoodItems.SCREAMING_ODEN)
                .add(RDFoodItems.OEDO_BOAT_FESTIVAL)
                .add(RDFoodItems.FISH_LEAPS_OVER_DRAGON_GATE)
                .add(RDFoodItems.HELL_THRILL_WARNING)
                .add(RDFoodItems.PIRATE_BACON)
                .add(RDFoodItems.LUOHAN_VEGETARIAN)
                .add(RDFoodItems.GENSOKYO_STAR_LOTUS_SHIP)
                .add(RDFoodItems.TAICHI_BAGUA_FISH_MAW)
                .add(RDFoodItems.REVERSING_THE_WORLD)
                .add(RDFoodItems.THE_BEAUTY_OF_HAN_PALACE)
                .add(RDFoodItems.GREEN_BAMBOO_WELCOMES_SPRING)
                .add(RDFoodItems.FANTASY_IS_ALL_THE_RAGE)
                .add(RDFoodItems.THE_DREAM)
                .add(RDFoodItems.BEEF_HOT_POT)
                .add(RDFoodItems.CATS_PLAYING_IN_WATER)
                .add(RDFoodItems.MAD_HATTER_TEA_PARTY)
                .add(RDFoodItems.LONGYIN_PEACH)
                .add(RDFoodItems.SUPERME_SEAFOOD_NOODLES)
                .build();
        this.createFactory(FoodProperties.LEGENDARY)
                .add(RDFoodItems.UDUMBARA_CAKE)
                .add(RDFoodItems.BEEF_WELLINGTON)
                .add(RDFoodItems.TAKETORIHIME)
                .add(RDFoodItems.PHOENIX)
                .add(RDFoodItems.HORAI_DAMA_NO_EDA)
                .add(RDFoodItems.COLORFUL_JADE_FRIED_BUNS)
                .add(RDFoodItems.PSEUDO_JIRITAMA)
                .add(RDFoodItems.GENSOKYO_BUDDHA_JUMPS_OVER_THE_WALL)
                .add(RDFoodItems.OEDO_BOAT_FESTIVAL)
                .add(RDFoodItems.PIRATE_BACON)
                .add(RDFoodItems.LOTUS_FISH_RICE_BOWL)
                .add(RDFoodItems.THE_BEAUTY_OF_HAN_PALACE)
                .add(RDFoodItems.LONGYIN_PEACH)
                .add(RDFoodItems.THE_SOURCE_OF_LIFE)
                .add(RDFoodItems.THE_MARS)
                .build();
        this.createFactory(FoodProperties.LIGHT)
                .add(RDFoodItems.TOFU_MISO)
                .add(RDFoodItems.COLD_TOFU)
                .add(RDFoodItems.TOFU_POT)
                .add(RDFoodItems.DEW_BOILED_EGGS)
                .add(RDFoodItems.COLD_DISH_CARVING)
                .add(RDFoodItems.ARCTIC_SWEET_SHRIMP_AND_PEACH_SALAD)
                .add(RDFoodItems.REAL_SEAFOOD_MISO_SOUP)
                .add(RDFoodItems.COOKING_TOFU)
                .add(RDFoodItems.MOON_LOVERS)
                .add(RDFoodItems.BAMBOO_STEAMED_EGG)
                .add(RDFoodItems.NIGIRI_SUSHI)
                .add(RDFoodItems.PUMPKIN_SHRIMP_CAKE)
                .add(RDFoodItems.LUOHAN_VEGETARIAN)
                .add(RDFoodItems.HOLY_WHITE_LOTUS_SEED_CAKE)
                .add(RDFoodItems.PINE_NUT_CAKE)
                .add(RDFoodItems.TAICHI_BAGUA_FISH_MAW)
                .add(RDFoodItems.CANDIED_CHESTNUTS)
                .add(RDFoodItems.LOTUS_FISH_RICE_BOWL)
                .add(RDFoodItems.GREEN_FAIRY_MUSHROOM)
                .add(RDFoodItems.THE_DREAM)
                .add(RDFoodItems.LONGYIN_PEACH)
                .add(RDFoodItems.MOLECULAR_EGG)
                .add(RDFoodItems.THE_SOURCE_OF_LIFE)
                .add(RDFoodItems.HEART_PORRIDGE_GRUEL)
                .build();
        this.createFactory(FoodProperties.LOCAL_SPECIALTY)
                .add(RDFoodItems.TAKETORIHIME)
                .add(RDFoodItems.MOONLIGHT_DUMPLINGS)
                .add(RDFoodItems.MOON_LOVERS)
                .add(RDFoodItems.SEA_URCHIN_SHINGEN_PANCAKE)
                .add(RDFoodItems.SECRET_MUSHROOM_CASSEROLE)
                .add(RDFoodItems.PUMPKIN_SHRIMP_CAKE)
                .add(RDFoodItems.GENSOKYO_BUDDHA_JUMPS_OVER_THE_WALL)
                .add(RDFoodItems.DEPRESSED_CHEESE_STICKS)
                .add(RDFoodItems.GLOOMY_FRUIT_PIE)
                .add(RDFoodItems.SCREAMING_ODEN)
                .add(RDFoodItems.CRISP_CYCLONE)
                .add(RDFoodItems.LOOKING_UP_AT_THE_CEILING_FRUIT_PIE)
                .add(RDFoodItems.BEETLE_STEAMED_CAKE)
                .add(RDFoodItems.LION_HEAD)
                .add(RDFoodItems.SAKURA_PUDDING)
                .add(RDFoodItems.FRIGHT_ADVENTURE)
                .add(RDFoodItems.PIRATE_BACON)
                .add(RDFoodItems.LUOHAN_VEGETARIAN)
                .add(RDFoodItems.YUNSHAN_COTTON_CANDY)
                .add(RDFoodItems.HOLY_WHITE_LOTUS_SEED_CAKE)
                .add(RDFoodItems.GENSOKYO_STAR_LOTUS_SHIP)
                .add(RDFoodItems.PINE_NUT_CAKE)
                .add(RDFoodItems.SHIRAGA_SADAMATSU)
                .add(RDFoodItems.CANDIED_CHESTNUTS)
                .add(RDFoodItems.TIANSHI_BRAISED_CHESTNUT_MUSHROOMS)
                .add(RDFoodItems.DORAYAKI)
                .add(RDFoodItems.GREEN_FAIRY_MUSHROOM)
                .add(RDFoodItems.FLOWERS_BIRDS_WIND_AND_MOON)
                .add(RDFoodItems.TOON_PANCAKES)
                .add(RDFoodItems.MAD_HATTER_TEA_PARTY)
                .add(RDFoodItems.PEACH_BLOSSOM_GLAZE_ROLL)
                .add(RDFoodItems.LONGYIN_PEACH)
                .add(RDFoodItems.HEART_PORRIDGE_GRUEL)
                .build();
        this.createFactory(FoodProperties.MEAT)
                .add(RDFoodItems.STRENGTH_SOUP)
                .add(RDFoodItems.PORK_AND_TROUT_SMOKED)
                .add(RDFoodItems.ENERGY_STRING)
                .add(RDFoodItems.TWO_HEAVENS_ONE_STYLE)
                .add(RDFoodItems.GRILLED_PORK_RICE_BALLS)
                .add(RDFoodItems.FRIED_PORK_SHREDS)
                .add(RDFoodItems.GAME_SOUP)
                .add(RDFoodItems.PORK_RICE)
                .add(RDFoodItems.BEEF_RICE)
                .add(RDFoodItems.SNOW_WHITE)
                .add(RDFoodItems.ZHAJI)
                .add(RDFoodItems.GRAND_BANQUET)
                .add(RDFoodItems.TONKOTSU_RAMEN)
                .add(RDFoodItems.MAGMA)
                .add(RDFoodItems.BEAR_PAW)
                .add(RDFoodItems.FRIED_PORK_CUTLET)
                .add(RDFoodItems.BUTTER_STEAK)
                .add(RDFoodItems.BEEF_WELLINGTON)
                .add(RDFoodItems.PAN_FRIED_SALMON)
                .add(RDFoodItems.HONEY_BBQ_PORK)
                .add(RDFoodItems.GINKGO_AND_RADISH_PORK_RIB_SOUP)
                .add(RDFoodItems.TAKETORIHIME)
                .add(RDFoodItems.PIG_DEER_BUTTERFLY)
                .add(RDFoodItems.BAMBOO_SHOOTS_FRIED_MEAT)
                .add(RDFoodItems.HORAI_DAMA_NO_EDA)
                .add(RDFoodItems.COLORFUL_JADE_FRIED_BUNS)
                .add(RDFoodItems.ALL_MEAT_FEAST)
                .add(RDFoodItems.MUSHROOM_MEAT_SLICES)
                .add(RDFoodItems.GENSOKYO_BUDDHA_JUMPS_OVER_THE_WALL)
                .add(RDFoodItems.SCREAMING_ODEN)
                .add(RDFoodItems.LION_HEAD)
                .add(RDFoodItems.FISH_LEAPS_OVER_DRAGON_GATE)
                .add(RDFoodItems.ONE_HIT_KILL)
                .add(RDFoodItems.HELL_THRILL_WARNING)
                .add(RDFoodItems.PIRATE_BACON)
                .add(RDFoodItems.SHIRAGA_SADAMATSU)
                .add(RDFoodItems.PAN_FRIED_MUSHROOM_MEAT_ROLL)
                .add(RDFoodItems.ASSORTED_TEMPURA)
                .add(RDFoodItems.BRAISED_PORK_WITH_PEACH)
                .add(RDFoodItems.BAMBOO_SHOOTS_STEWED_IN_STONE_POT)
                .add(RDFoodItems.BAMBOO_TUBE_STEAMED_PORK)
                .add(RDFoodItems.FANTASY_IS_ALL_THE_RAGE)
                .add(RDFoodItems.BEEF_HOT_POT)
                .build();
        this.createFactory(FoodProperties.MUSHROOMS)
                .add(RDFoodItems.MAGMA)
                .add(RDFoodItems.ROASTED_MUSHROOMS)
                .add(RDFoodItems.RISOTTO)
                .add(RDFoodItems.CREAM_STEW)
                .add(RDFoodItems.BAMBOO_STEAMED_EGG)
                .add(RDFoodItems.COLORFUL_JADE_FRIED_BUNS)
                .add(RDFoodItems.MUSHROOM_MEAT_SLICES)
                .add(RDFoodItems.SECRET_MUSHROOM_CASSEROLE)
                .add(RDFoodItems.MUSHROOM_GIRLS_DANCE_STEW)
                .add(RDFoodItems.MILKY_MUSHROOM_SOUP)
                .add(RDFoodItems.GENSOKYO_BUDDHA_JUMPS_OVER_THE_WALL)
                .add(RDFoodItems.FISH_LEAPS_OVER_DRAGON_GATE)
                .add(RDFoodItems.TIANSHI_BRAISED_CHESTNUT_MUSHROOMS)
                .add(RDFoodItems.PAN_FRIED_MUSHROOM_MEAT_ROLL)
                .add(RDFoodItems.ASSORTED_TEMPURA)
                .add(RDFoodItems.REVERSING_THE_WORLD)
                .add(RDFoodItems.GREEN_FAIRY_MUSHROOM)
                .add(RDFoodItems.BEEF_HOT_POT)
                .add(RDFoodItems.CAT_PIZZA)
                .add(RDFoodItems.MAD_HATTER_TEA_PARTY)
                .add(RDFoodItems.THE_SOURCE_OF_LIFE)
                .build();
        this.createFactory(FoodProperties.MOUNTAIN_DELICACY)
                .add(RDFoodItems.STRENGTH_SOUP)
                .add(RDFoodItems.TWO_HEAVENS_ONE_STYLE)
                .add(RDFoodItems.GAME_SOUP)
                .add(RDFoodItems.GRAND_BANQUET)
                .add(RDFoodItems.BEEF_WELLINGTON)
                .add(RDFoodItems.ALL_MEAT_FEAST)
                .add(RDFoodItems.GENSOKYO_BUDDHA_JUMPS_OVER_THE_WALL)
                .add(RDFoodItems.ONE_HIT_KILL)
                .add(RDFoodItems.SHIRAGA_SADAMATSU)
                .add(RDFoodItems.REVERSING_THE_WORLD)
                .add(RDFoodItems.BAMBOO_TUBE_STEAMED_PORK)
                .add(RDFoodItems.GREEN_BAMBOO_WELCOMES_SPRING)
                .add(RDFoodItems.BEEF_HOT_POT)
                .build();
        this.createFactory(FoodProperties.OCEAN_FLAVOR)
                .add(RDFoodItems.FAILING_SAKURA_SNOW)
                .add(RDFoodItems.BAKED_CRAB_WITH_CREAM)
                .add(RDFoodItems.SEA_URCHIN_SHINGEN_PANCAKE)
                .add(RDFoodItems.LOOKING_UP_AT_THE_CEILING_FRUIT_PIE)
                .add(RDFoodItems.OEDO_BOAT_FESTIVAL)
                .add(RDFoodItems.FISH_LEAPS_OVER_DRAGON_GATE)
                .add(RDFoodItems.STEAMED_EGG_WITH_SEA_URCHIN)
                .add(RDFoodItems.THE_MARS)
                .add(RDFoodItems.SUPERME_SEAFOOD_NOODLES)
                .build();
        this.createFactory(FoodProperties.PETITE)
                .add(RDFoodItems.FAILING_SAKURA_SNOW)
                .add(RDFoodItems.COLD_TOFU)
                .add(RDFoodItems.SECRET_DRIED_FISH)
                .add(RDFoodItems.EGGS_BENEDICT)
                .add(RDFoodItems.MOCHI)
                .add(RDFoodItems.MOON_CAKE)
                .add(RDFoodItems.PICKLED_CUCUMBERS)
                .add(RDFoodItems.PSEUDO_JIRITAMA)
                .add(RDFoodItems.OKONOMIYAKI)
                .add(RDFoodItems.TAKOYAKI)
                .add(RDFoodItems.SEA_URCHIN_SHINGEN_PANCAKE)
                .add(RDFoodItems.SAKURA_PUDDING)
                .add(RDFoodItems.REFRESHING_PUDDING)
                .add(RDFoodItems.BURNT_PUDDING)
                .add(RDFoodItems.CAT_FOOD)
                .add(RDFoodItems.SALMON_TEMPURA)
                .add(RDFoodItems.HOLY_WHITE_LOTUS_SEED_CAKE)
                .add(RDFoodItems.CANDIED_CHESTNUTS)
                .add(RDFoodItems.FRIED_TOMATO_STRIPS)
                .add(RDFoodItems.RED_BEAN_DAIFUKU)
                .add(RDFoodItems.A_LITTLE_SWEET_POISON)
                .add(RDFoodItems.SEA_URCHIN_SHINGEN_PANCAKE)
                .add(RDFoodItems.PEACH_BLOSSOM_GLAZE_ROLL)
                .add(RDFoodItems.MOLECULAR_EGG)
                .build();
        this.createFactory(FoodProperties.PHOTOGENIC)
                .add(RDFoodItems.FAILING_SAKURA_SNOW)
                .add(RDFoodItems.SASHIMI_PLATTER)
                .add(RDFoodItems.UDUMBARA_CAKE)
                .add(RDFoodItems.COLD_DISH_CARVING)
                .add(RDFoodItems.PEACH_BLOSSOM_SOUP)
                .add(RDFoodItems.ARCTIC_SWEET_SHRIMP_AND_PEACH_SALAD)
                .add(RDFoodItems.TAKETORIHIME)
                .add(RDFoodItems.PHOENIX)
                .add(RDFoodItems.MOON_LOVERS)
                .add(RDFoodItems.PIG_DEER_BUTTERFLY)
                .add(RDFoodItems.MAOYU_TRICOLOR_ICE_CREAM)
                .add(RDFoodItems.MAOYU_LAVA_TOFU)
                .add(RDFoodItems.SCARLET_DEVILS_CAKE)
                .add(RDFoodItems.UNCONSCIOUS_MONSTER_MOUSSE)
                .add(RDFoodItems.ALL_MEAT_FEAST)
                .add(RDFoodItems.BAKED_CRAB_WITH_CREAM)
                .add(RDFoodItems.OKONOMIYAKI)
                .add(RDFoodItems.TAKOYAKI)
                .add(RDFoodItems.SEA_URCHIN_SHINGEN_PANCAKE)
                .add(RDFoodItems.MUSHROOM_GIRLS_DANCE_STEW)
                .add(RDFoodItems.MILKY_MUSHROOM_SOUP)
                .add(RDFoodItems.ORDINARY_SMALL_CAKE)
                .add(RDFoodItems.SEVEN_COLORED_YOKAN)
                .add(RDFoodItems.PUMPKIN_SHRIMP_CAKE)
                .add(RDFoodItems.GENSOKYO_BUDDHA_JUMPS_OVER_THE_WALL)
                .add(RDFoodItems.LOOKING_UP_AT_THE_CEILING_FRUIT_PIE)
                .add(RDFoodItems.BEETLE_STEAMED_CAKE)
                .add(RDFoodItems.OEDO_BOAT_FESTIVAL)
                .add(RDFoodItems.SAKURA_PUDDING)
                .add(RDFoodItems.HELL_THRILL_WARNING)
                .add(RDFoodItems.SKINNY_HORSE_DUMPLING)
                .add(RDFoodItems.FRIGHT_ADVENTURE)
                .add(RDFoodItems.HOLY_WHITE_LOTUS_SEED_CAKE)
                .add(RDFoodItems.GENSOKYO_STAR_LOTUS_SHIP)
                .add(RDFoodItems.GREEN_BAMBOO_WELCOMES_SPRING)
                .add(RDFoodItems.STEAMED_EGG_WITH_SEA_URCHIN)
                .add(RDFoodItems.FANTASY_IS_ALL_THE_RAGE)
                .add(RDFoodItems.THE_DREAM)
                .add(RDFoodItems.A_LITTLE_SWEET_POISON)
                .add(RDFoodItems.CAT_KULULI)
                .add(RDFoodItems.CAT_PIZZA)
                .add(RDFoodItems.CATS_PLAYING_IN_WATER)
                .add(RDFoodItems.RAPUNZEL)
                .add(RDFoodItems.MAD_HATTER_TEA_PARTY)
                .add(RDFoodItems.PEACH_BLOSSOM_GLAZE_ROLL)
                .add(RDFoodItems.MOONLIGHT_OVER_LOTUS_POND)
                .add(RDFoodItems.THE_MARS)
                .build();
        this.createFactory(FoodProperties.POPULAR_NEGATIVE)
                .build();
        this.createFactory(FoodProperties.POPULAR_POSITIVE)
                .build();
        this.createFactory(FoodProperties.POWER_SURGE)
                .add(RDFoodItems.STRENGTH_SOUP)
                .add(RDFoodItems.MAGMA)
                .add(RDFoodItems.GOLDEN_CRISPY_FISH_CAKE)
                .add(RDFoodItems.GENSOKYO_BUDDHA_JUMPS_OVER_THE_WALL)
                .add(RDFoodItems.SCREAMING_ODEN)
                .add(RDFoodItems.BEETLE_STEAMED_CAKE)
                .add(RDFoodItems.GIANT_TAMAGOYAKI)
                .add(RDFoodItems.REFRESHING_PUDDING)
                .add(RDFoodItems.BURNT_PUDDING)
                .add(RDFoodItems.HELL_THRILL_WARNING)
                .add(RDFoodItems.FRIGHT_ADVENTURE)
                .add(RDFoodItems.PIRATE_BACON)
                .add(RDFoodItems.ASSORTED_TEMPURA)
                .add(RDFoodItems.FANTASY_IS_ALL_THE_RAGE)
                .add(RDFoodItems.BEEF_HOT_POT)
                .build();
        this.createFactory(FoodProperties.RAW)
                .add(RDFoodItems.FAILING_SAKURA_SNOW)
                .add(RDFoodItems.VEGETABLE_SPECIAL)
                .add(RDFoodItems.SASHIMI_PLATTER)
                .add(RDFoodItems.DEW_BOILED_EGGS)
                .add(RDFoodItems.EGGS_BENEDICT)
                .add(RDFoodItems.NIGIRI_SUSHI)
                .add(RDFoodItems.CRISP_CYCLONE)
                .add(RDFoodItems.BEETLE_STEAMED_CAKE)
                .add(RDFoodItems.CHEESE_EGG)
                .add(RDFoodItems.GENSOKYO_STAR_LOTUS_SHIP)
                .add(RDFoodItems.FANTASY_IS_ALL_THE_RAGE)
                .add(RDFoodItems.EEL_EGG_DONBURI)
                .add(RDFoodItems.BAMBOO_TUBE_ROASTED_DRUNKEN_SHRIMP)
                .add(RDFoodItems.THE_SOURCE_OF_LIFE)
                .build();
        this.createFactory(FoodProperties.SALTY)
                .add(RDFoodItems.TONKOTSU_RAMEN)
                .add(RDFoodItems.SECRET_DRIED_FISH)
                .add(RDFoodItems.ROASTED_MUSHROOMS)
                .add(RDFoodItems.ALL_MEAT_FEAST)
                .add(RDFoodItems.PICKLED_CUCUMBERS)
                .add(RDFoodItems.MUSHROOM_GIRLS_DANCE_STEW)
                .add(RDFoodItems.DEPRESSED_CHEESE_STICKS)
                .add(RDFoodItems.GLOOMY_FRUIT_PIE)
                .add(RDFoodItems.CHEESE_EGG)
                .add(RDFoodItems.HELL_THRILL_WARNING)
                .add(RDFoodItems.BISCAY_BISCUITS)
                .build();
        this.createFactory(FoodProperties.SIGNATURE)
                .add(RDFoodItems.GRILLED_HAGFISH)
                .add(RDFoodItems.BRAISED_EEL)
                .add(RDFoodItems.FRIED_HAGFISH)
                .add(RDFoodItems.TAKOYAKI)
                .add(RDFoodItems.LOOKING_UP_AT_THE_CEILING_FRUIT_PIE)
                .add(RDFoodItems.BEETLE_STEAMED_CAKE)
                .add(RDFoodItems.BAKED_CRAB_WITH_CREAM)
                .add(RDFoodItems.LION_HEAD)
                .add(RDFoodItems.OEDO_BOAT_FESTIVAL)
                .add(RDFoodItems.BURNT_PUDDING)
                .add(RDFoodItems.GENSOKYO_STAR_LOTUS_SHIP)
                .add(RDFoodItems.PAN_FRIED_MUSHROOM_MEAT_ROLL)
                .add(RDFoodItems.ASSORTED_TEMPURA)
                .add(RDFoodItems.GREEN_BAMBOO_WELCOMES_SPRING)
                .add(RDFoodItems.FANTASY_IS_ALL_THE_RAGE)
                .add(RDFoodItems.TOON_PANCAKES)
                .add(RDFoodItems.POISONOUS_GARDEN)
                .add(RDFoodItems.EEL_EGG_DONBURI)
                .build();
        this.createFactory(FoodProperties.SOUR)
                .add(RDFoodItems.GLOOMY_FRUIT_PIE)
                .add(RDFoodItems.REFRESHING_PUDDING)
                .add(RDFoodItems.BURNT_PUDDING)
                .build();
        this.createFactory(FoodProperties.SPICY)
                .add(RDFoodItems.STINKY_TOFU)
                .add(RDFoodItems.MAPO_TOFU)
                .add(RDFoodItems.MUSHROOM_GIRLS_DANCE_STEW)
                .add(RDFoodItems.SCREAMING_ODEN)
                .add(RDFoodItems.HELL_THRILL_WARNING)
                .add(RDFoodItems.BEEF_HOT_POT)
                .add(RDFoodItems.HULA_SOUP)
                .build();
        this.createFactory(FoodProperties.SWEET)
                .add(RDFoodItems.UDUMBARA_CAKE)
                .add(RDFoodItems.PEACH_BLOSSOM_SOUP)
                .add(RDFoodItems.ARCTIC_SWEET_SHRIMP_AND_PEACH_SALAD)
                .add(RDFoodItems.POETRY_AND_GINKGO)
                .add(RDFoodItems.HOT_WAFFLES)
                .add(RDFoodItems.MOONLIGHT_DUMPLINGS)
                .add(RDFoodItems.MOCHI)
                .add(RDFoodItems.WHITE_PEACH_EIGHT_BRIDGE)
                .add(RDFoodItems.MOON_LOVERS)
                .add(RDFoodItems.MOON_CAKE)
                .add(RDFoodItems.MAOYU_TRICOLOR_ICE_CREAM)
                .add(RDFoodItems.SCARLET_DEVILS_CAKE)
                .add(RDFoodItems.HONEY_BBQ_PORK)
                .add(RDFoodItems.UNCONSCIOUS_MONSTER_MOUSSE)
                .add(RDFoodItems.SEA_URCHIN_SHINGEN_PANCAKE)
                .add(RDFoodItems.MILKY_MUSHROOM_SOUP)
                .add(RDFoodItems.ORDINARY_SMALL_CAKE)
                .add(RDFoodItems.SEVEN_COLORED_YOKAN)
                .add(RDFoodItems.PUMPKIN_SHRIMP_CAKE)
                .add(RDFoodItems.GIANT_TAMAGOYAKI)
                .add(RDFoodItems.SAKURA_PUDDING)
                .add(RDFoodItems.REFRESHING_PUDDING)
                .add(RDFoodItems.BURNT_PUDDING)
                .add(RDFoodItems.FISH_LEAPS_OVER_DRAGON_GATE)
                .add(RDFoodItems.BAKED_SWEET_POTATOES)
                .add(RDFoodItems.YUNSHAN_COTTON_CANDY)
                .add(RDFoodItems.CANDIED_CHESTNUTS)
                .add(RDFoodItems.CANDIED_SWEET_POTATO)
                .add(RDFoodItems.RED_BEAN_DAIFUKU)
                .add(RDFoodItems.DORAYAKI)
                .add(RDFoodItems.THE_DREAM)
                .add(RDFoodItems.A_LITTLE_SWEET_POISON)
                .add(RDFoodItems.CAT_KULULI)
                .add(RDFoodItems.CATS_PLAYING_IN_WATER)
                .add(RDFoodItems.MAD_HATTER_TEA_PARTY)
                .add(RDFoodItems.PEACH_BLOSSOM_GLAZE_ROLL)
                .add(RDFoodItems.MOONLIGHT_OVER_LOTUS_POND)
                .add(RDFoodItems.LONGYIN_PEACH)
                .add(RDFoodItems.MOLECULAR_EGG)
                .add(RDFoodItems.HEART_PORRIDGE_GRUEL)
                .build();
        this.createFactory(FoodProperties.SOUP_AND_STEW)
                .add(RDFoodItems.SEAFOOD_MISO_SOUP)
                .add(RDFoodItems.TOFU_MISO)
                .add(RDFoodItems.STRENGTH_SOUP)
                .add(RDFoodItems.PEACH_BLOSSOM_SOUP)
                .add(RDFoodItems.REAL_SEAFOOD_MISO_SOUP)
                .add(RDFoodItems.CREAM_STEW)
                .add(RDFoodItems.GINKGO_AND_RADISH_PORK_RIB_SOUP)
                .add(RDFoodItems.THE_BEAUTY_OF_HAN_PALACE)
                .add(RDFoodItems.THE_SOURCE_OF_LIFE)
                .add(RDFoodItems.HULA_SOUP)
                .build();
        this.createFactory(FoodProperties.TOXIC)
                .build();
        this.createFactory(FoodProperties.UMAMI)
                .add(RDFoodItems.BRAISED_EEL)
                .add(RDFoodItems.ZHAJI)
                .add(RDFoodItems.BEAR_PAW)
                .add(RDFoodItems.SECRET_DRIED_FISH)
                .add(RDFoodItems.RISOTTO)
                .add(RDFoodItems.PAN_FRIED_SALMON)
                .add(RDFoodItems.MAOYU_LAVA_TOFU)
                .add(RDFoodItems.BAKED_CRAB_WITH_CREAM)
                .add(RDFoodItems.SECRET_MUSHROOM_CASSEROLE)
                .add(RDFoodItems.MUSHROOM_GIRLS_DANCE_STEW)
                .add(RDFoodItems.NIGIRI_SUSHI)
                .add(RDFoodItems.PUMPKIN_SHRIMP_CAKE)
                .add(RDFoodItems.DEPRESSED_CHEESE_STICKS)
                .add(RDFoodItems.GLOOMY_FRUIT_PIE)
                .add(RDFoodItems.SCREAMING_ODEN)
                .add(RDFoodItems.BEETLE_STEAMED_CAKE)
                .add(RDFoodItems.LION_HEAD)
                .add(RDFoodItems.OEDO_BOAT_FESTIVAL)
                .add(RDFoodItems.CAT_FOOD)
                .add(RDFoodItems.SALMON_TEMPURA)
                .add(RDFoodItems.FISH_LEAPS_OVER_DRAGON_GATE)
                .add(RDFoodItems.CHEESE_EGG)
                .add(RDFoodItems.LUOHAN_VEGETARIAN)
                .add(RDFoodItems.GENSOKYO_STAR_LOTUS_SHIP)
                .add(RDFoodItems.TAICHI_BAGUA_FISH_MAW)
                .add(RDFoodItems.STEAMED_EGG_WITH_SEA_URCHIN)
                .add(RDFoodItems.BAMBOO_TUBE_ROASTED_DRUNKEN_SHRIMP)
                .add(RDFoodItems.SUPERME_SEAFOOD_NOODLES)
                .build();
        this.createFactory(FoodProperties.UNBELIEVABLE)
                .add(RDFoodItems.UDUMBARA_CAKE)
                .add(RDFoodItems.BEAR_PAW)
                .add(RDFoodItems.ARCTIC_SWEET_SHRIMP_AND_PEACH_SALAD)
                .add(RDFoodItems.HONEY_BBQ_PORK)
                .add(RDFoodItems.FLOWING_WATER_NOODLES)
                .add(RDFoodItems.MOON_CAKE)
                .add(RDFoodItems.MAOYU_LAVA_TOFU)
                .add(RDFoodItems.SEA_URCHIN_SHINGEN_PANCAKE)
                .add(RDFoodItems.SEVEN_COLORED_YOKAN)
                .add(RDFoodItems.FRIGHT_ADVENTURE)
                .add(RDFoodItems.YUNSHAN_COTTON_CANDY)
                .add(RDFoodItems.GENSOKYO_STAR_LOTUS_SHIP)
                .add(RDFoodItems.LOTUS_FISH_RICE_BOWL)
                .add(RDFoodItems.FRIED_TOMATO_STRIPS)
                .add(RDFoodItems.BRAISED_PORK_WITH_PEACH)
                .add(RDFoodItems.REVERSING_THE_WORLD)
                .add(RDFoodItems.FLOWERS_BIRDS_WIND_AND_MOON)
                .add(RDFoodItems.CATS_PLAYING_IN_WATER)
                .add(RDFoodItems.MAD_HATTER_TEA_PARTY)
                .add(RDFoodItems.LONGYIN_PEACH)
                .add(RDFoodItems.MOLECULAR_EGG)
                .add(RDFoodItems.THE_SOURCE_OF_LIFE)
                .add(RDFoodItems.THE_MARS)
                .build();
        this.createFactory(FoodProperties.VEGETARIAN)
                .add(RDFoodItems.SEAFOOD_MISO_SOUP)
                .add(RDFoodItems.TOFU_MISO)
                .add(RDFoodItems.RICE_BALL)
                .add(RDFoodItems.COLD_TOFU)
                .add(RDFoodItems.BRAISED_EEL)
                .add(RDFoodItems.POTATO_CROQUETTES)
                .add(RDFoodItems.VEGETABLE_SPECIAL)
                .add(RDFoodItems.TOFU_POT)
                .add(RDFoodItems.COLD_DISH_CARVING)
                .add(RDFoodItems.PEACH_BLOSSOM_SOUP)
                .add(RDFoodItems.ARCTIC_SWEET_SHRIMP_AND_PEACH_SALAD)
                .add(RDFoodItems.FRIED_TOFU)
                .add(RDFoodItems.POETRY_AND_GINKGO)
                .add(RDFoodItems.ROASTED_MUSHROOMS)
                .add(RDFoodItems.COOKING_TOFU)
                .add(RDFoodItems.CREAM_STEW)
                .add(RDFoodItems.FLOWING_WATER_NOODLES)
                .add(RDFoodItems.STINKY_TOFU)
                .add(RDFoodItems.MAPO_TOFU)
                .add(RDFoodItems.MAOYU_LAVA_TOFU)
                .add(RDFoodItems.DUMPLING)
                .add(RDFoodItems.GLUTINOUS_RICE_BALLS)
                .add(RDFoodItems.PICKLED_CUCUMBERS)
                .add(RDFoodItems.HOLY_WHITE_LOTUS_SEED_CAKE)
                .add(RDFoodItems.TIANSHI_BRAISED_CHESTNUT_MUSHROOMS)
                .add(RDFoodItems.CANDIED_SWEET_POTATO)
                .add(RDFoodItems.DORAYAKI)
                .add(RDFoodItems.CATS_PLAYING_IN_WATER)
                .add(RDFoodItems.MOLECULAR_EGG)
                .build();
        this.createFactory(FoodProperties.WESTERN_STYLE)
                .add(RDFoodItems.BUTTER_STEAK)
                .add(RDFoodItems.RISOTTO)
                .add(RDFoodItems.BEEF_WELLINGTON)
                .add(RDFoodItems.EGGS_BENEDICT)
                .add(RDFoodItems.HOT_WAFFLES)
                .add(RDFoodItems.PAN_FRIED_SALMON)
                .add(RDFoodItems.CREAM_STEW)
                .add(RDFoodItems.PHOENIX)
                .add(RDFoodItems.MAOYU_TRICOLOR_ICE_CREAM)
                .add(RDFoodItems.SCARLET_DEVILS_CAKE)
                .add(RDFoodItems.UNCONSCIOUS_MONSTER_MOUSSE)
                .add(RDFoodItems.THE_DREAM)
                .add(RDFoodItems.CAT_PIZZA)
                .add(RDFoodItems.MAD_HATTER_TEA_PARTY)
                .build();
    }

    @Override
    public String method_10321() {
        return "Ingredient";
    }
}
