package cc.thonly.reverie_dreams.datagen.generator;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.data.CraftingConflict;
import com.google.common.hash.HashCode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import lombok.extern.slf4j.Slf4j;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_7923;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

@Slf4j
public abstract class AbstractCraftingConflictProvider implements class_2405 {
    public final FabricDataOutput output;
    public final CompletableFuture<class_7225.class_7874> future;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Map<class_2960, CraftingConflict> registries = new Object2ObjectOpenHashMap<>();

    public AbstractCraftingConflictProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> future) {
        this.output = output;
        this.future = future;
        this.configured();
    }

    @Override
    public CompletableFuture<?> method_10319(class_7403 writer) {
        return CompletableFuture.runAsync(() -> {
            this.configured();
            this.export(writer);
        });
    }

    protected AbstractCraftingConflictProvider registerEntry(CraftingConflict craftingConflict) {
        var id = class_7923.field_41178.method_10221(craftingConflict.getItem());
        id = class_2960.method_60655(id.getNamespace(), id.getPath().replaceAll("/","-"));
        return this.registerEntry(id, craftingConflict);
    }

    protected AbstractCraftingConflictProvider registerEntry(class_2960 key, CraftingConflict craftingConflict) {
        this.registries.put(key, craftingConflict);
        return this;
    }

    protected abstract void configured();

    public void export(class_7403 writer) {
        Path path = Paths.get(DataGeneratorUtil.OUTPUT_DIR);
        try {
            for (var entry : this.registries.entrySet()) {
                class_2960 key = entry.getKey();
                CraftingConflict craftingConflict = entry.getValue();
                DataResult<JsonElement> result = CraftingConflict.CODEC.encodeStart(JsonOps.INSTANCE, craftingConflict);
                Optional<JsonElement> optional = result.result();
                Path gPath = DataGeneratorUtil.getData(path, ReverieDreams.MOD_ID, "crafting_conflict", null);

                if (optional.isPresent()) {
                    JsonElement element = optional.get();
                    Path output = gPath.resolve(key.method_12832() + ".json");
                    String jsonString = this.gson.toJson(element);
                    byte[] bytes = jsonString.getBytes(StandardCharsets.UTF_8);
                    Files.createDirectories(output.getParent());

                    writer.method_43346(output, bytes, HashCode.fromBytes(bytes));
                }
            }
        } catch (Exception err) {
            log.error("Error: ", err);
        }
    }
}
