package cc.thonly.reverie_dreams.datagen.generator;

import com.google.common.hash.HashCode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import lombok.extern.slf4j.Slf4j;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@Slf4j
public abstract class AbstractJsonElementWriterProvider implements class_2405 {
    protected final Map<String, JsonElement> path2JsonElement = new Object2ObjectLinkedOpenHashMap<>();
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
    public final FabricDataOutput output;
    public final CompletableFuture<class_7225.class_7874> future;

    public AbstractJsonElementWriterProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> future) {
        this.output = output;
        this.future = future;
    }

    @Override
    public CompletableFuture<?> method_10319(class_7403 cachedOutput) {
        this.configured();
        this.export(cachedOutput);
        return CompletableFuture.completedFuture(null);
    }

    public void export(class_7403 cachedOutput) {
        Path basePath = Paths.get(DataGeneratorUtil.OUTPUT_DIR);
        for (var entry : path2JsonElement.entrySet()) {
            String relativePath = entry.getKey();
            JsonElement element = entry.getValue();

            byte[] bytes = GSON.toJson(element).getBytes(StandardCharsets.UTF_8);
            Path exportPath = basePath.resolve(relativePath);

            try {
                Files.createDirectories(exportPath.getParent());
                cachedOutput.method_43346(exportPath, bytes, HashCode.fromBytes(bytes));
            } catch (Exception err) {
                log.error("Failed to export JSON file: {}", exportPath, err);
            }
        }
    }

    protected abstract void configured();

    public void addElement(Type type, class_2960 location, String subPath, JsonElement element) {
        String relativePath = type.path + location.method_12836() + "/" + subPath + "/" + location.method_12832() + ".json";
        this.path2JsonElement.put(relativePath, element);
    }

    @Override
    public String method_10321() {
        return "Json Element Writer";
    }

    public enum Type {
        ASSETS("assets/"),
        DATA("data/");

        final String path;
        Type(String path) { this.path = path; }
    }
}