package cc.thonly.reverie_dreams.datagen.generator;

import cc.thonly.reverie_dreams.datagen.entry.SoundEventBuilder;
import cc.thonly.reverie_dreams.sound.JukeBoxEntry;
import com.google.common.hash.HashCode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import lombok.extern.slf4j.Slf4j;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.minecraft.class_2405;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_7225;
import net.minecraft.class_7403;
import net.minecraft.class_9793;
import org.jetbrains.annotations.Nullable;

import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@Slf4j
public abstract class AbstractSoundProvider implements class_2405 {
    public final FabricDataOutput output;
    public final CompletableFuture<class_7225.class_7874> future;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Map<class_2960, SoundEventBuilder> identifierSoundEventMap = new Object2ObjectOpenHashMap<>();

    public AbstractSoundProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> future) {
        this.output = output;
        this.future = future;
    }

    @Override
    public CompletableFuture<?> method_10319(class_7403 writer) {
        return CompletableFuture.runAsync(() -> {
            this.configured();
            this.export(writer);
        });
    }

    public AbstractSoundProvider add(class_2960 id, SoundEventBuilder entry) {
        this.identifierSoundEventMap.put(id, entry);
        return this;
    }

    public AbstractSoundProvider addWithSoundEvent(class_3414 soundEvent, @Nullable String soundPath) {
        class_2960 id = soundEvent.comp_3319();
        SoundEventBuilder entry = new SoundEventBuilder(id);
        entry.setSubtitle(id);
        if (soundPath != null) {
            entry.addSounds(soundPath);
        } else {
            entry.addSounds(id.toString());
        }
        this.identifierSoundEventMap.put(id, entry);
        return this;
    }

    public AbstractSoundProvider addWithRecords(JukeBoxEntry jukeBoxEntry, @Nullable String soundPath) {
        class_9793 ref = jukeBoxEntry.getRef();
        class_2960 id = ref.comp_2835().comp_349().comp_3319();
        SoundEventBuilder entry = new SoundEventBuilder(id);
        entry.setSubtitle(id);
        if (soundPath != null) {
            entry.addSoundsByName(soundPath);
        } else {
            entry.addSoundsByName(id.method_12836()  + ":" + "records/"+ id.method_12832());
        }
        this.identifierSoundEventMap.put(id, entry);
        return this;
    }

    public abstract void configured();

//    @SuppressWarnings("deprecation")
    public void export(class_7403 writer) {
        try {
            Path path = Paths.get(DataGeneratorUtil.OUTPUT_DIR);
            Map<String, List<SoundEventBuilder>> namespaceToBuild = new LinkedHashMap<>();
            for (var entry : this.identifierSoundEventMap.entrySet()) {
                String namespace = entry.getKey().method_12836();
                SoundEventBuilder ref = entry.getValue();
                List<SoundEventBuilder> list = namespaceToBuild.computeIfAbsent(namespace, k -> new LinkedList<>());
                list.add(ref);
            }
            for (var entry : namespaceToBuild.entrySet()) {
                String namespace = entry.getKey();
                Path generatePath = DataGeneratorUtil.getAssetsByNullable(path, namespace, null, null);
                Path output = generatePath.resolve("sounds.json");
                Files.createDirectories(generatePath);
                List<SoundEventBuilder> list = entry.getValue();
                JsonObject object = new JsonObject();
                for (var builder : list) {
                    class_2960 key = builder.getKey();
                    JsonElement element = builder.toJsonElement();
                    object.add(key.method_12832(), element);
                }
                String jsonString = this.gson.toJson(object);
                byte[] bytes = jsonString.getBytes(StandardCharsets.UTF_8);
                writer.method_43346(output, bytes, HashCode.fromBytes(bytes));
            }
        } catch (Exception err) {
            log.error("Can't export sounds.json: ", err);
        }
    }

    @Override
    public String method_10321() {
        return "Sounds JSON Provider";
    }
}
