package cc.thonly.reverie_dreams.engine;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.registry.RegistryHandlers;
import cc.thonly.reverie_dreams.registry.impl.RegistryHandler;
import cc.thonly.reverie_dreams.util.ConstantInfo;
import lombok.extern.slf4j.Slf4j;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import org.jetbrains.annotations.Nullable;

import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

@Slf4j
public class JavaScriptManager {
    private static final String DIRNAME = "javascript_src";
    private static final RegistryHandler<JavaScriptElement> REGISTRY = RegistryHandlers.JAVASCRIPT_ELEMENT;
    private static final JavaScriptManager INSTANCE = new JavaScriptManager();
    private static final Supplier<ScriptEngine> ENGINE = () -> new ScriptEngineManager().getEngineByName("JavaScript");

    public static JavaScriptManager getInstance() {
        return INSTANCE;
    }

    public boolean run(@Nullable class_3222 player,
                       @Nullable class_1937 world,
                       @Nullable class_2338 blockPos,
                       @Nullable class_1297 target,
                       @Nullable Map<?, ?> args,
                       JavaScriptElement element) {
        try {
            ScriptEngine scriptEngine = ENGINE.get();
            String src = element.getSrc();
            scriptEngine.eval(src);

            Invocable invocable = (Invocable) scriptEngine;

            invocable.invokeFunction("main", player, world, blockPos, target, args);
            return true;
        } catch (Exception e) {
            log.error("Can't run script key {}", element.getSrc(), e);
            return false;
        }
    }

    public String getClassPath(String classPath) {
        return this.getIntermediaryClass(classPath);
    }

    public String getIntermediaryClass(String classPath) {
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            return classPath.replace('.', '/');
        } else {
            return ConstantInfo.MAPPING_RESOLVER.mapClassName("intermediary", classPath.replace('.', '/'));
        }
    }

    public Optional<JavaScriptElement> get(class_2960 key) {
        return Optional.ofNullable(REGISTRY.method_63535(key));
    }

    public static void reload(class_3300 manager) {
        Map<class_2960, class_3298> resources = manager.method_14488(DIRNAME, id ->
                id.method_12836().equals(ReverieDreams.MOD_ID) && id.method_12832().endsWith(".js")
        );
        for (Map.Entry<class_2960, class_3298> entry : resources.entrySet()) {
            class_2960 fileId = entry.getKey();
            class_3298 resource = entry.getValue();
            class_2960 key = class_2960.method_60655(fileId.method_12836(), fileId.method_12832().replace(DIRNAME + "/", "").replace(".json", ""));
            try (InputStream inputStream = resource.method_14482()) {
                String src = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                RegistryHandlers.register(REGISTRY, key, new JavaScriptElement(src));
            } catch (Exception e) {
                log.error("Can't load script {}", key, e);
            }
        }
    }

    public static void bootstrap(RegistryHandler<JavaScriptElement> registry) {

    }
}
