package cc.thonly.reverie_dreams.entity;

import cc.thonly.reverie_dreams.entity.npc.BaseNPCLikeEntity;
import cc.thonly.reverie_dreams.registry.content.skin.MobSkinTypes;
import cc.thonly.reverie_dreams.inventory.NPCInventoryImpl;
import java.util.*;
import java.util.stream.Collectors;
import net.minecraft.class_1268;
import net.minecraft.class_1299;
import net.minecraft.class_1321;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1386;
import net.minecraft.class_1391;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1439;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class GoblinEntity extends BaseNPCLikeEntity {
    public static final Set<class_1792> GOLDEN_ITEMS = new HashSet<>();
    public static List<class_1792> PICKAXE_POOL = new ArrayList<>();
    public static List<class_1792> OFFHAND_POOL = new ArrayList<>();

    static {
        PICKAXE_POOL.add(class_1802.field_8162);
        PICKAXE_POOL.add(class_1802.field_8647);
        PICKAXE_POOL.add(class_1802.field_8387);
        PICKAXE_POOL.add(class_1802.field_8403);
        PICKAXE_POOL.add(class_1802.field_8335);
        PICKAXE_POOL.add(class_1802.field_8377);
        PICKAXE_POOL.add(class_1802.field_22024);
        OFFHAND_POOL.add(class_1802.field_8162);
        OFFHAND_POOL.add(class_1802.field_8162);
        OFFHAND_POOL.add(class_1802.field_8810);
        OFFHAND_POOL.add(class_1802.field_8255);
    }

    public GoblinEntity(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world, MobSkinTypes.GOBLIN);
        this.inventory.setMainHand(this.getRandomPickaxe());
        this.inventory.setOffHand(this.getRandomOffHand());
        if (GOLDEN_ITEMS.isEmpty()) {
            this.tryGetGoldenItem();
        }
    }

    private void tryGetGoldenItem() {
        Set<class_2960> ids = class_7923.field_41178.method_10235();
        Set<class_2960> collect = ids.stream().filter(id -> {
                    String path = id.method_12832();
                    return path.startsWith("gold_") || path.startsWith("golden_");
                })
                .collect(Collectors.toSet());
        collect.forEach((id) -> GOLDEN_ITEMS.add(class_7923.field_41178.method_63535(id)));
    }

    @Override
    protected void method_5959() {
        super.method_5959();

        this.field_6201.method_6277(0, new class_1347(this));
        this.field_6201.method_6277(1, new class_1386(this));

        this.field_6201.method_6277(4, new class_1391(this, 1.2, stack -> GOLDEN_ITEMS.contains(stack.method_7909()), false));

        this.field_6201.method_6277(7, new class_1341(this, 1.0));
        this.field_6201.method_6277(8, new class_1394(this, 1.0));

        this.field_6201.method_6277(10, new class_1361(this, class_1657.class, 12.0f));
        this.field_6201.method_6277(10, new class_1361(this, BaseNPCLikeEntity.class, 8.0f));
        this.field_6201.method_6277(10, new class_1376(this));

        this.field_6185.method_6277(2, new class_1400<>(this, class_1657.class, true));
        this.field_6185.method_6277(3, new class_1400<>(this, class_1439.class, true));
        this.field_6185.method_6277(3, new class_1399(this).method_6318());
    }

    public class_1799 getRandomPickaxe() {
        final Random random = new Random();
        if (PICKAXE_POOL == null || PICKAXE_POOL.isEmpty()) {
            return null;
        }
        class_1792 item = PICKAXE_POOL.get(random.nextInt(PICKAXE_POOL.size()));
        class_1799 itemStack = new class_1799(item);
//        itemStack.set(DataComponentTypes.UNBREAKABLE, Unit.INSTANCE);
        if (itemStack.method_7986()) {
            itemStack.method_71012(itemStack.method_7936() - 50, this, class_1268.field_5808);
        }
        return itemStack;
    }

    public class_1799 getRandomOffHand() {
        final Random random = new Random();
        if (OFFHAND_POOL == null || OFFHAND_POOL.isEmpty()) {
            return null;
        }
        class_1792 item = OFFHAND_POOL.get(random.nextInt(OFFHAND_POOL.size()));
        class_1799 itemStack = new class_1799(item);
        if (itemStack.method_7986()) {
            itemStack.method_71012(itemStack.method_7936() - 50, this, class_1268.field_5810);
        }
        return itemStack;
    }

    @Override
    public boolean method_5936() {
        return false;
    }

    @Override
    public Set<Integer> getDonDropSlotIndex() {
        return Set.of(NPCInventoryImpl.MAIN_HAND, NPCInventoryImpl.OFF_HAND);
    }

    public KeepInventoryTypes getKeepInventoryType() {
        return KeepInventoryTypes.NOT_DROP_ANY;
    }

    @Override
    public boolean method_17326() {
        return false;
    }
}
