package cc.thonly.reverie_dreams.entity.ai.goal;

import cc.thonly.reverie_dreams.block.entity.FoodDisplayBlockEntity;
import cc.thonly.reverie_dreams.entity.npc.BaseNPCLikeEntity;
import cc.thonly.reverie_dreams.interfaces.IItemStack;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import net.minecraft.class_1268;
import net.minecraft.class_1367;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4174;
import net.minecraft.class_4538;
import net.minecraft.class_9323;
import net.minecraft.class_9334;

public class NPCEatFoodDispalyGoal extends class_1367 {

    protected int timer;

    public NPCEatFoodDispalyGoal(BaseNPCLikeEntity maid, final double speed, final int range, final int maxYDifference) {
        super(maid, speed, range, maxYDifference);
    }

    @Override
    public double method_6291() {
        return 2.0;
    }

    @Override
    public boolean method_6294() {
        return this.field_6517 % 100 == 0;
    }

    private boolean isFoodDisplay(class_4538 world, class_2338 pos) {
        if (world.method_8321(pos) instanceof FoodDisplayBlockEntity isdBlockEntity) {
            ItemStackWrapper item = isdBlockEntity.getItem();
            return ((IItemStack) (Object) item.getItemStack()).isFood();
        }
        return false;
    }

    @Override
    protected boolean method_6296(class_4538 world, class_2338 pos) {
        return isFoodDisplay(world, pos);
    }

    @Override
    public void method_6268() {
        if (this.method_6295()) {
            if (this.timer >= 40) {
                this.eatBerries();
            } else {
                this.timer++;
            }
        } else if (!this.method_6295() && field_6516.method_59922().method_43057() < 0.05F) {
            this.field_6516.method_5783(class_3417.field_18063, 1.0F, 1.0F);
        }

        super.method_6268();
    }

    protected void eatBerries() {
        BaseNPCLikeEntity maid = (BaseNPCLikeEntity) this.field_6516;
        class_1937 world = maid.method_37908();
        if (method_64452(world).method_64395().method_8355(class_1928.field_19388)) {
            if (isFoodDisplay(world, this.field_6512)) {
                FoodDisplayBlockEntity displayBlockEntity = (FoodDisplayBlockEntity) world.method_8321(field_6512);
                ItemStackWrapper item = displayBlockEntity.getItem();
                class_9323 components = item.getItemStack().getComponents();
                class_4174 foodComponent = components.method_58694(class_9334.field_50075);
                if (foodComponent != null) {
                    maid.method_6104(class_1268.field_5808);
                    int nutritionValue = foodComponent.comp_2491();
                    int saturationValue = Math.round(foodComponent.comp_2492());
                    maid.setNutrition(maid.getNutrition() + nutritionValue);
                    maid.setSaturation(maid.getSaturation() + saturationValue);
                    //displayBlockEntity.setItem(new ItemStackRecipeWrapper(new ItemStack(Blocks.AIR)));
                    displayBlockEntity.setItem(ItemStackWrapper.empty());
                    world.method_43128(
                            null,
                            maid.method_23317(),
                            maid.method_23318(),
                            maid.method_23321(),
                            class_3417.field_19149,
                            class_3419.field_15256,
                            0.5F,
                            class_3532.method_32750(world.field_9229, 0.9F, 1.0F)
                    );
                }
            }
        }
    }


    @Override
    public boolean method_6264() {
        BaseNPCLikeEntity maid = (BaseNPCLikeEntity) this.field_6516;
        return ((maid.getNutrition() < 20 && maid.method_6032() < 20) || maid.getNutrition() < 10) && super.method_6264();
    }

    @Override
    public void method_6269() {
        this.timer = 0;
        super.method_6269();
    }
}