package cc.thonly.reverie_dreams.entity.ai.goal;

import org.jetbrains.annotations.Nullable;

import java.util.EnumSet;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1352;
import net.minecraft.class_1391;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_4051;
import net.minecraft.class_5134;

public class NPCTemptGoal extends class_1352 {
    private static final class_4051 TEMPTING_ENTITY_PREDICATE = class_4051.method_36626().method_36627();
    private final class_4051 predicate;
    protected final class_1314 mob;
    private final double speed;
    private double lastPlayerX;
    private double lastPlayerY;
    private double lastPlayerZ;
    private double lastPlayerPitch;
    private double lastPlayerYaw;
    @Nullable
    protected class_1657 closestPlayer;
    private int cooldown;
    private boolean active;
    private final Predicate<class_1799> foodPredicate;
    private final boolean canBeScared;

    public NPCTemptGoal(class_1314 entity, double speed, Predicate<class_1799> foodPredicate, boolean canBeScared) {
        this.mob = entity;
        this.speed = speed;
        this.foodPredicate = foodPredicate;
        this.canBeScared = canBeScared;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        this.predicate = TEMPTING_ENTITY_PREDICATE.method_33335().method_18420((entityx, world) -> this.isTemptedBy(entityx));
    }

    @Override
    public boolean method_6264() {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        this.closestPlayer = NPCTemptGoal.method_64451(this.mob).method_64388(this.predicate.method_18418(this.mob.method_45325(class_5134.field_52450)), this.mob);
        if (this.mob instanceof class_1321 entitySelf) {
            if(!entitySelf.method_6181()) {
                return this.closestPlayer != null;
            } else if (!(entitySelf.method_35057() == this.closestPlayer)) {
                return false;
            }
        }
        return this.closestPlayer != null;
    }

    private boolean isTemptedBy(class_1309 entity) {
        return this.foodPredicate.test(entity.method_6047()) || this.foodPredicate.test(entity.method_6079());
    }

    @Override
    public boolean method_6266() {
        if (this.closestPlayer == null) {
            return false;
        }
        if (this.canBeScared()) {
            if (this.mob.method_5858(this.closestPlayer) < 36.0) {
                if (this.closestPlayer.method_5649(this.lastPlayerX, this.lastPlayerY, this.lastPlayerZ) > 0.010000000000000002) {
                    return false;
                }
                if (Math.abs((double) this.closestPlayer.method_36455() - this.lastPlayerPitch) > 5.0 || Math.abs((double) this.closestPlayer.method_36454() - this.lastPlayerYaw) > 5.0) {
                    return false;
                }
            } else {
                this.lastPlayerX = this.closestPlayer.method_23317();
                this.lastPlayerY = this.closestPlayer.method_23318();
                this.lastPlayerZ = this.closestPlayer.method_23321();
            }
            this.lastPlayerPitch = this.closestPlayer.method_36455();
            this.lastPlayerYaw = this.closestPlayer.method_36454();
        }
        return this.method_6264();
    }

    protected boolean canBeScared() {
        return this.canBeScared;
    }

    @Override
    public void method_6269() {
        if (this.closestPlayer != null) {
            this.lastPlayerX = this.closestPlayer.method_23317();
            this.lastPlayerY = this.closestPlayer.method_23318();
            this.lastPlayerZ = this.closestPlayer.method_23321();
        }
        this.active = true;
    }

    @Override
    public void method_6270() {
        this.closestPlayer = null;
        this.mob.method_5942().method_6340();
        this.cooldown = class_1391.method_38848(100);
        this.active = false;
    }

    @Override
    public void method_6268() {
        this.mob.method_5988().method_6226(this.closestPlayer, this.mob.method_5986() + 20, this.mob.method_5978());
        if (this.mob.method_5858(this.closestPlayer) < 6.25) {
            this.mob.method_5942().method_6340();
        } else {
            this.mob.method_5942().method_6335(this.closestPlayer, this.speed);
        }
    }



}

