package cc.thonly.reverie_dreams.entity.ai.goal.attack;

import cc.thonly.reverie_dreams.component.DanmakuProperties;
import cc.thonly.reverie_dreams.registry.content.component.RDDataComponentTypes;
import cc.thonly.reverie_dreams.entity.interfaces.DanmakuShooter;
import cc.thonly.reverie_dreams.entity.npc.BaseNPCLikeEntity;
import cc.thonly.reverie_dreams.item.danmaku.AbstractDanmakuItem;
import cc.thonly.reverie_dreams.item.danmaku.DanmakuItem;
import cc.thonly.reverie_dreams.sound.SoundEventInit;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1352;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import java.util.EnumSet;

@Setter
@Getter
public class NPCDanmakuItemGoal<T extends BaseNPCLikeEntity> extends class_1352 {
    private final T actor;
    private final double speed;
    private int attackInterval;
    private final float squaredRange;

    private final int minDelayTicks = 10;
    private final int maxDelayTicks = 10 * 2;
    private int updateCountdownTicks = -1;

    public NPCDanmakuItemGoal(T actor, double speed, int attackInterval, float range) {
        this.actor = actor;
        this.speed = speed;
        this.attackInterval = attackInterval;
        this.squaredRange = range * range;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    @Override
    public boolean method_6264() {
        if ((this.actor).method_5968() == null) {
            return false;
        }
        if (this.actor.method_5968() == this.actor.method_35057()) {
            return false;
        }
        if (this.actor.method_5968() instanceof class_1321 tameableEntity) {
            if (tameableEntity.method_35057() == this.actor.method_35057()) {
                return false;
            }
        }
        return this.isHoldingDanmaku();
    }

    private boolean isHoldingDanmaku() {
        return this.actor.method_6047().method_7909() instanceof DanmakuItem;
    }

    @Override
    public boolean method_6266() {
        return (this.method_6264() || !this.actor.method_5942().method_6357()) && this.isHoldingDanmaku();
    }

    @Override
    public boolean method_38846() {
        return true;
    }

    @Override
    public void method_6270() {
        super.method_6270();
        this.actor.method_19540(false);
        this.actor.method_6021();
    }

    @Override
    public void method_6268() {
        class_1309 target = this.actor.method_5968();
        if (target == null || !target.method_5805()) {
            this.method_6270();
            return;
        }
        float[] pitchYaw = DanmakuShooter.getPitchYaw(this.actor, target);
        this.actor.method_5988().method_35111(target);
        this.actor.method_36457(pitchYaw[0]);
        this.actor.method_36456(pitchYaw[1]);

        if (!this.method_6264()) return;

        double distanceSq = this.actor.method_5858(target);
        if (distanceSq > 64.0) {
            if (this.actor.method_5942().method_6357()) {
                this.actor.method_5942().method_6335(target, 1.5);
            }
        } else {
            this.actor.method_5942().method_6340();
        }

        if (--this.updateCountdownTicks <= 0) {
            class_1937 world = this.actor.method_37908();
            if (world instanceof class_3218 serverWorld) {
                class_1799 itemStack = this.actor.method_6047();
                DanmakuProperties properties = itemStack.method_58694(RDDataComponentTypes.DANMAKU_PROPERTIES);
                if (properties == null) {
                    return;
                }
                class_1792 item = itemStack.method_7909();
                if (!(item instanceof AbstractDanmakuItem polymerDanmakuItem)) {
                    return;
                }
                for (int i = 0; i < properties.getCount(); i++) {
                    polymerDanmakuItem.shoot(serverWorld, this.actor, class_1268.field_5808);
                }
                if (!properties.isInfinite()) {
                    itemStack.method_71012(1, this.actor, class_1268.field_5808);
                    if (itemStack.method_7963() && itemStack.method_7919() >= itemStack.method_7936()) {
                        itemStack.method_7934(1);
                    }
                }

                world.method_43128(null, this.actor.method_23317(), this.actor.method_23318(), this.actor.method_23321(), SoundEventInit.FIRE, class_3419.field_15254, 1f, 1.0f);
            }
            this.resetCooldown();
        }
    }

    private void resetCooldown() {
        this.updateCountdownTicks = minDelayTicks + this.actor.method_59922().method_43048(maxDelayTicks - minDelayTicks + 1);
    }

}
