package cc.thonly.reverie_dreams.entity.ai.goal.work;

import cc.thonly.reverie_dreams.entity.ai.goal.util.EntityTargetUtil;
import cc.thonly.reverie_dreams.entity.npc.BaseNPCLikeEntity;
import cc.thonly.reverie_dreams.registry.content.NPCWorkModes;
import cc.thonly.reverie_dreams.server.CookingInputRecipeManager;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1352;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2609;
import net.minecraft.class_3341;
import net.minecraft.class_3720;
import net.minecraft.class_3723;
import net.minecraft.class_3866;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

import java.util.*;

public class NPCSmeltGoal extends class_1352 {
    private final BaseNPCLikeEntity roleEntity;
    @Nullable
    private OperationalTarget operationalTarget;

    public NPCSmeltGoal(BaseNPCLikeEntity roleEntity) {
        this.roleEntity = roleEntity;
        this.method_6265(EnumSet.of(class_4134.field_18405, class_4134.field_18406));
    }

    /** 找到实体身上所有可熔炼的物品 */
    private List<Integer> findAllInputSlots() {
        List<Integer> slots = new ArrayList<>();
        class_1277 inventory = this.roleEntity.getInventory();
        for (int i = 0; i < inventory.method_5439(); i++) {
            class_1799 stack = inventory.method_5438(i);
            if (!stack.method_7960() && CookingInputRecipeManager.getInstance().contains(stack.method_7909())) {
                slots.add(i);
            }
        }
        return slots;
    }

    /** 找到附近的熔炉 */
    private List<class_2338> findFurnaceBlockPosList() {
        List<class_2338> blockPosList = new ArrayList<>();
        class_1937 world = this.roleEntity.method_37908();
        class_2338 center = this.roleEntity.getWorkingPos();
        int r = 8;

        class_3341 box = new class_3341(
                center.method_10263() - r, center.method_10264() - r, center.method_10260() - r,
                center.method_10263() + r, center.method_10264() + r, center.method_10260() + r
        );
        class_2338.class_2339 pos = new class_2338.class_2339();

        for (int x = box.method_35415(); x <= box.method_35418(); x++) {
            for (int y = box.method_35416(); y <= box.method_35419(); y++) {
                for (int z = box.method_35417(); z <= box.method_35420(); z++) {
                    pos.method_10103(x, y, z);
                    if (world.method_8321(pos) instanceof class_2609) {
                        blockPosList.add(pos.method_10062());
                    }
                }
            }
        }
        return blockPosList;
    }

    @Override
    public boolean method_6264() {
        if (!EntityTargetUtil.isThisWorkMode(this.roleEntity, NPCWorkModes.SMELT)) {
            return false;
        }

        MinecraftServer server = this.roleEntity.method_5682();
        CookingInputRecipeManager instance = CookingInputRecipeManager.getInstance();
        if (server != null && instance.isEmpty()) {
            instance.load(server);
        }

        // 如果已有目标继续执行
        if (this.operationalTarget != null) {
            return true;
        }

        // 尝试设置新目标
        return this.trySetTarget();
    }

    @Override
    public boolean method_6266() {
        return this.operationalTarget != null &&
                EntityTargetUtil.isThisWorkMode(this.roleEntity, NPCWorkModes.SMELT);
    }

    @Override
    public boolean method_38846() {
        return true;
    }

    /** 选择一个熔炉目标 */
    private boolean trySetTarget() {
        class_1937 world = this.roleEntity.method_37908();
        List<class_2338> furnaceList = this.findFurnaceBlockPosList();
        List<Integer> inputSlots = this.findAllInputSlots();

        for (class_2338 blockPos : furnaceList) {
            class_2586 be = world.method_8321(blockPos);
            if (!(be instanceof class_2609 furnace)) continue;

            // ===== 输入槽 (slot 0) =====
            class_1799 furnaceStack = furnace.method_5438(0);
            boolean isEmpty = furnaceStack.method_7960();

            for (int invSlot : inputSlots) {
                class_1799 npcStack = this.roleEntity.getInventory().getItem(invSlot);
                if (npcStack.method_7960()) continue;
                class_1792 item = npcStack.method_7909();

                // 匹配炉子类型
                if (isSmeltingFurnace(furnace) && !CookingInputRecipeManager.getInstance().isSmelting(item)) continue;
                if (isSmokerFurnace(furnace) && !CookingInputRecipeManager.getInstance().isSmoker(item)) continue;
                if (isBlastFurnace(furnace) && !CookingInputRecipeManager.getInstance().isBlast(item)) continue;

                if (isEmpty || (class_1799.method_31577(furnaceStack, npcStack) &&
                        furnaceStack.method_7947() < furnaceStack.method_7914())) {
                    this.operationalTarget = new OperationalTarget(invSlot, blockPos, furnace, 0);
                    return true;
                }
            }

            // ===== 燃料槽 (slot 1) =====
            class_1799 fuelSlot = furnace.method_5438(1);
            for (int i = 0; i < this.roleEntity.getInventory().getContainerSize(); i++) {
                class_1799 npcStack = this.roleEntity.getInventory().getItem(i);
                if (npcStack.method_7960()) continue;
                if (CookingInputRecipeManager.isFuel(npcStack)) {
                    if (fuelSlot.method_7960() || (class_1799.method_31577(fuelSlot, npcStack) &&
                            fuelSlot.method_7947() < fuelSlot.method_7914())) {
                        this.operationalTarget = new OperationalTarget(i, blockPos, furnace, 1);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean isSmeltingFurnace(class_2609 be) {
        return be instanceof class_3866;
    }
    private boolean isSmokerFurnace(class_2609 be) {
        return be instanceof class_3723;
    }
    private boolean isBlastFurnace(class_2609 be) {
        return be instanceof class_3720;
    }

    @Override
    public void method_6268() {
        if (this.operationalTarget == null) {
            this.trySetTarget();
            return;
        }

        class_2338 pos = this.operationalTarget.blockPos();
        class_2609 furnace = this.operationalTarget.furnaceBlockEntity();
        int npcSlot = this.operationalTarget.inventorySlot();
        int furnaceSlotIndex = this.operationalTarget.slotIndex();

        class_1799 npcStack = this.roleEntity.getInventory().getItem(npcSlot);
        if (npcStack.method_7960()) {
            this.operationalTarget = null;
            return;
        }

        if (!isReached(pos)) {
            this.roleEntity.method_5942().method_6337(pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5, 1.0D);
            this.roleEntity.method_5988().method_20248(pos.method_10263() + 0.5, pos.method_10264() + 0.5, pos.method_10260() + 0.5);
            return;
        }

        class_1799 furnaceSlot = furnace.method_5438(furnaceSlotIndex);

        if (furnaceSlot.method_7960()) {
            furnace.method_5447(furnaceSlotIndex, npcStack.method_7971(1));
        } else if (class_1799.method_31577(furnaceSlot, npcStack)) {
            int space = furnaceSlot.method_7914() - furnaceSlot.method_7947();
            if (space > 0) {
                int move = Math.min(npcStack.method_7947(), space);
                furnaceSlot.method_7933(move);
                npcStack.method_7934(move);
            }
        }

        furnace.method_5431();
        this.roleEntity.method_6104(class_1268.field_5808);

        // 炉子已满 或者 NPC 没货了 -> 清空目标
        if (npcStack.method_7960() || furnaceSlot.method_7947() >= furnaceSlot.method_7914()) {
            this.operationalTarget = null;
        }
    }

    private boolean isReached(class_2338 blockPos) {
        double distSq = blockPos.method_19770(this.roleEntity.method_19538());
        return distSq <= 9; // 半径 3 格
    }

    /** 保存目标信息 */
    public record OperationalTarget(
            int inventorySlot, // NPC 背包槽位
            class_2338 blockPos,
            class_2609 furnaceBlockEntity,
            int slotIndex // 0 = 输入, 1 = 燃料
    ) {}
}
