package cc.thonly.reverie_dreams.entity.interfaces;

import cc.thonly.reverie_dreams.component.DanmakuProperties;
import cc.thonly.reverie_dreams.registry.content.component.RDDataComponentTypes;
import cc.thonly.reverie_dreams.registry.content.danmaku.DanmakuTypes;
import cc.thonly.reverie_dreams.entity.misc.DanmakuEntity;
import cc.thonly.reverie_dreams.item.danmaku.AbstractDanmakuItem;
import cc.thonly.reverie_dreams.item.prop.Knife;
import cc.thonly.reverie_dreams.sound.SoundEventInit;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3218;

@FunctionalInterface
public interface DanmakuShooter {
    DanmakuShooter DEFAULT = (self, target, world) -> {
        class_1799 stack = DanmakuTypes.random(DanmakuTypes.FIREBALL_GLOWY);
        float[] pitchYaw = getPitchYaw(self, target);
        spawn(world, self, stack, pitchYaw[0], pitchYaw[1] - 15.0f, 1.0f, 0f, 0.35f);
        spawn(world, self, stack, pitchYaw[0], pitchYaw[1], 1.05f, 0f, 0.35f);
        spawn(world, self, stack, pitchYaw[0], pitchYaw[1] + 15.0f, 1.0f, 0f, 0.35f);
    };

    void fire(class_1309 self, class_1297 target, class_3218 world);

    default void sound(class_1309 self) {
        self.method_56078(SoundEventInit.FIRE);
    }

    static float[] getPitchYaw(class_1297 self, class_1297 target) {
        double dx = target.method_23317() - self.method_23317();
        double dy = target.method_23318() - self.method_23320();
        double dz = target.method_23321() - self.method_23321();

        double horizontalDistance = Math.sqrt(dx * dx + dz * dz);


        float pitch = (float) (-Math.toDegrees(Math.atan2(dy, horizontalDistance)));
        float yaw = (float) (Math.toDegrees(Math.atan2(dz, dx))) - 90.0f;
        return new float[]{pitch, yaw};
    }

    static DanmakuEntity spawn(class_3218 world, class_1309 entity, class_1799 stack, float pitch, float yaw, float speed, float divergence, float offsetDist) {
        class_1792 item = stack.method_7909();
        DanmakuProperties properties = stack.method_58695(RDDataComponentTypes.DANMAKU_PROPERTIES, DanmakuProperties.ofDefault());
        properties = properties.withSpeed(speed);
        if (item instanceof AbstractDanmakuItem danmakuItem) {
            DanmakuEntity danmakuEntity = new DanmakuEntity(
                    entity,
                    world,
                    entity.method_23317(),
                    entity.method_23318(),
                    entity.method_23321(),
                    stack.method_7972(),
                    properties,
                    pitch,
                    yaw,
                    divergence,
                    offsetDist
            );
            world.method_8649(danmakuEntity);
            return danmakuEntity;
        }
        if (item instanceof Knife knife) {
            DanmakuEntity danmakuEntity = new DanmakuEntity(
                    entity,
                    world,
                    entity.method_23317(),
                    entity.method_23318(),
                    entity.method_23321(),
                    stack.method_7972(),
                    properties,
                    pitch,
                    yaw,
                    divergence,
                    offsetDist
            );
            world.method_8649(danmakuEntity);
            return danmakuEntity;
        }
        return null;
    }
}
