package cc.thonly.reverie_dreams.gui;

import cc.thonly.reverie_dreams.gui.recipe.GuiOpeningPrevCallback;
import cc.thonly.reverie_dreams.gui.recipe.GuiStackBuilder;
import cc.thonly.reverie_dreams.gui.recipe.RecipeTypeGuiInfo;
import cc.thonly.reverie_dreams.gui.recipe.RecipeTypeInfo;
import cc.thonly.reverie_dreams.registry.content.item.RDGuiItems;
import cc.thonly.reverie_dreams.recipe.view.RecipeEntryWrapper;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.gui.SimpleGui;
import lombok.Getter;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

@Getter
public class BasePageGui extends SimpleGui {
    public static final String[][] GRID = {
            {"X", "X", "X", "X", "X", "X", "X", "X", "X"},
            {"X", "X", "X", "X", "X", "X", "X", "X", "X"},
            {"X", "X", "X", "X", "X", "X", "X", "X", "X"},
            {"X", "X", "X", "X", "X", "X", "X", "X", "X"},
            {"X", "X", "X", "X", "X", "X", "X", "X", "X"},
            {"P", "W", "W", "W", "B", "W", "W", "W", "N"},
    };
    public static final int PER_PAGE_SIZE = 5 * 9;
    public final GuiElementBuilder back = new GuiElementBuilder(RDGuiItems.BACK).setItemName(class_2561.method_30163("Back")).setCallback(this::back);
    public final GuiElementBuilder next = new GuiElementBuilder(RDGuiItems.NEXT).setItemName(class_2561.method_30163("Next Page")).setCallback(this::next);
    public final GuiElementBuilder prev = new GuiElementBuilder(RDGuiItems.PREV).setItemName(class_2561.method_30163("Prev Page")).setCallback(this::prev);
    public int page = 0;
    public final int maxSize;
    public final List<GuiElementBuilder> displayList = new LinkedList<>();
    public final RecipeTypeGuiInfo<? extends BasePageGui> recipeGuiInfo;
    public final RecipeTypeInfo recipeTypeInfo;
    public final List<RecipeEntryWrapper<?>> entries;
    public boolean updated = true;
    public GuiOpeningPrevCallback prevGuiCallback;

    public BasePageGui(class_3222 player, RecipeTypeGuiInfo<? extends BasePageGui> recipeGuiInfo, RecipeTypeInfo recipeTypeInfo, GuiOpeningPrevCallback prevGuiCallback) {
        super(class_3917.field_17327, player, false);
        this.recipeGuiInfo = recipeGuiInfo;
        this.recipeTypeInfo = recipeTypeInfo;
        this.entries = new LinkedList<>();
        Map<class_2960, ?> registryView = this.recipeTypeInfo.getRecipeType().getRegistryView();
        for (Map.Entry<class_2960, ?> entry : registryView.entrySet()) {
            this.entries.add(new RecipeEntryWrapper<>(entry.getKey(), entry.getValue()));
        }
        this.maxSize = this.entries.size();
        this.prevGuiCallback = prevGuiCallback;
        this.init();
        this.setTitle(class_2561.method_43473().method_27693(class_2561.method_43471(this.recipeGuiInfo.getId().toLanguageKey())).append(class_2561.method_30163(" (" + (this.page + 1) + "/" + (getMaxPage() + 1) + ")")));

    }

    public void init() {
        this.setTitle(class_2561.method_43473().method_27693(class_2561.method_43471(this.recipeGuiInfo.getId().toLanguageKey())).append(class_2561.method_30163(" (" + (this.page + 1) + "/" + (getMaxPage() + 1) + ")")));
        for (int row = 0; row < GRID.length; row++) {
            for (int col = 0; col < GRID[row].length; col++) {
                String c = GRID[row][col];
                int slot = row * 9 + col;
                if (c.equalsIgnoreCase("X")) {
                    GuiElementBuilder builder = new GuiElementBuilder().setItem(class_1802.field_8162);
                    builder.setCallback(this::clickIcon);
                    this.displayList.add(builder);
                    this.setSlot(slot, builder);
                }
                if (c.equalsIgnoreCase("B")) {
                    this.setSlot(slot, this.back);
                }
                if (c.equalsIgnoreCase("N")) {
                    this.setSlot(slot, this.next);
                }
                if (c.equalsIgnoreCase("P")) {
                    this.setSlot(slot, this.prev);
                }
                if (c.equalsIgnoreCase("W")) {
                    this.setSlot(slot, new GuiElementBuilder().setItem(RDGuiItems.EMPTY_SLOT));
                }
            }
        }
    }

    @Override
    public boolean onAnyClick(int index, ClickType type, net.minecraft.class_1713 action) {
        this.updated = true;
        return super.onAnyClick(index, type, action);
    }

    public void clickIcon(int index, ClickType clickType, net.minecraft.class_1713 action) {
        int iconIndex = this.page * PER_PAGE_SIZE + index;
        if (this.maxSize > iconIndex) {

        }
    }

    public void back(int index, ClickType clickType, net.minecraft.class_1713 action) {
        this.player.method_17356(class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
        if (this.prevGuiCallback != null) {
            SimpleGui applyGui = this.prevGuiCallback.apply();
            applyGui.open();
        }
    }

    public void next(int index, ClickType clickType, net.minecraft.class_1713 action) {
        this.player.method_17356(class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
        if (this.page < getMaxPage()) {
            this.page++;
            this.displayList.clear();
        }
    }

    public void prev(int index, ClickType clickType, net.minecraft.class_1713 action) {
        this.player.method_17356(class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);

        if (this.page > getMinPage()) {
            this.page--;
            this.displayList.clear();
        }
    }

    public int getMinPage() {
        return 0;
    }

    public int getMaxPage() {
        return Math.max(0, (this.maxSize - 1) / PER_PAGE_SIZE);
    }

    @Override
    public void onTick() {
        super.onTick();
        if (!this.updated) return;
        this.updated = false;

        this.setTitle(class_2561.method_43473().method_27693(class_2561.method_43471(this.recipeGuiInfo.getId().toLanguageKey())).append(class_2561.method_30163(" (" + (this.page + 1) + "/" + (getMaxPage() + 1) + ")")));
        int start = this.page * PER_PAGE_SIZE;

        for (int i = 0; i < PER_PAGE_SIZE; i++) {
            int slotIndex = i;
            int recipeIndex = start + i;

            if (recipeIndex < this.maxSize) {
                GuiStackBuilder stackGetter = this.recipeTypeInfo.getGetter();
                stackGetter.apply(this, slotIndex);
            } else {
                this.setSlot(getGridSlot(slotIndex), new GuiElementBuilder().setItem(class_1802.field_8162));
            }
        }
    }

    public int getGridSlot(int index) {
        int counter = 0;
        for (int row = 0; row < GRID.length; row++) {
            for (int col = 0; col < GRID[row].length; col++) {
                if (GRID[row][col].equalsIgnoreCase("X")) {
                    if (counter == index) {
                        return row * 9 + col;
                    }
                    counter++;
                }
            }
        }
        return -1;
    }
}
