package cc.thonly.reverie_dreams.gui;

import cc.thonly.reverie_dreams.entity.npc.BaseNPCLikeEntity;
import cc.thonly.reverie_dreams.registry.content.NPCStates;
import cc.thonly.reverie_dreams.data.npc.NPCWorkMode;
import cc.thonly.reverie_dreams.inventory.NPCInventoryImpl;
import cc.thonly.reverie_dreams.registry.content.item.RDGuiItems;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1304;
import net.minecraft.class_1723;
import net.minecraft.class_1735;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;
import net.minecraft.class_9334;
import net.minecraft.class_9692;

public class NPCGui extends SimpleGui implements GuiCommon {
    public static final String[][] GRID = {
            {"I", "I", "I", "I", "I", "I", "X", "Q", "W"},
            {"I", "I", "I", "I", "I", "I", "X", "E", "R"},
            {"I", "I", "I", "I", "I", "I", "X", "T", "Y"},
            {"X", "X", "X", "X", "X", "X", "X", "U", "O"},
            {"/", "*", "-", "+", "I", "I", "X", "P", "M"},
            {"X", "X", "X", "X", "X", "X", "X", "N", "B"},
    };
    private final Map<GuiElementBuilder, Integer> builder2index = new HashMap<>();
    private final class_3222 player;
    private final BaseNPCLikeEntity npcEntity;

    private GuiElementBuilder npcName;
    private GuiElementBuilder npcMode;
    private GuiElementBuilder npcWorkMode;
    private GuiElementBuilder npcFood;
    private GuiElementBuilder npcHealth;
    private GuiElementBuilder npcArmor;
    private GuiElementBuilder npcXp;
    private GuiElementBuilder npcAutoPick;

    public NPCGui(class_3222 player, BaseNPCLikeEntity npcEntity) {
        super(class_3917.field_17327, player, false);
        this.player = player;
        this.npcEntity = npcEntity;
        init();
    }

    public void init() {
        int inventory_index = 0;

        this.setTitle(getRoleName());
        for (int row = 0; row < GRID.length; row++) {
            for (int col = 0; col < GRID[row].length; col++) {
                int slotIndex = row * 9 + col;
                String posChar = GRID[row][col];
                if (posChar.equalsIgnoreCase("X")) {
                    this.setSlot(slotIndex, new GuiElementBuilder()
                            .setItem(RDGuiItems.EMPTY_SLOT));
                }
                if (posChar.equalsIgnoreCase("Q")) {
                    this.npcName = new GuiElementBuilder()
                            .setItem(class_1802.field_8448)
                            .setItemName(class_2561.method_43471("gui.npc.info"))
                            .setCallback((index, type, action) -> {
                                this.player.method_17356(class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
                            });
                    this.builder2index.put(this.npcName, slotIndex);
                    this.setSlot(slotIndex, this.npcName);
                }
                if (posChar.equalsIgnoreCase("W")) {
                    this.npcFood = new GuiElementBuilder()
                            .setItem(class_1802.field_8544)
                            .setItemName(class_2561.method_43471("gui.npc.info"))
                            .setCallback((index, type, action) -> {
                                this.player.method_17356(class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
                            });
                    this.builder2index.put(this.npcFood, slotIndex);
                    this.setSlot(slotIndex, this.npcFood);
                }
                if (posChar.equalsIgnoreCase("E")) {
                    this.npcHealth = new GuiElementBuilder()
                            .setItem(class_1802.field_8463)
                            .setItemName(class_2561.method_43471("gui.npc.info"))
                            .setCallback((index, type, action) -> {
                                this.player.method_17356(class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
                            });
                    this.builder2index.put(this.npcHealth, slotIndex);
                    this.setSlot(slotIndex, this.npcHealth);
                }
                if (posChar.equalsIgnoreCase("R")) {
                    this.npcArmor = new GuiElementBuilder()
                            .setItem(class_1802.field_8743)
                            .setItemName(class_2561.method_43469("gui.npc.info", getRoleName().getString()))
                            .setCallback((index, type, action) -> {
                                this.player.method_17356(class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
                            });
                    this.builder2index.put(this.npcArmor, slotIndex);
                    this.setSlot(slotIndex, this.npcArmor);
                }

                if (posChar.equalsIgnoreCase("T")) {
                    class_2338 workingPos = this.npcEntity.getWorkingPos();
                    this.npcMode = new GuiElementBuilder()
                            .setItem(class_1802.field_8477)
                            .setItemName(class_2561.method_43471("gui.npc.work.button"))
                            .setLore(List.of
                                    (
                                            this.npcEntity.getNpcState().getTranslateText(),
                                            this.npcEntity.getNpcState() == NPCStates.WORKING ? class_2561.method_43471("gui.npc.mode.work.originpos")
                                                    .method_27693(" : (" + workingPos.method_10263() + " " + workingPos.method_10264() + " " + workingPos.method_10260() + ")") : class_2561.method_30163("")

                                    )
                            )
                            .setCallback((index, type, action) -> {
                                this.npcEntity.setNpcState(type.isRight ? this.npcEntity.getPreviousState() : this.npcEntity.getNextState());
                                this.player.playNotifySound(SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                            })
                    ;
                    this.builder2index.put(this.npcMode, slotIndex);
                    this.setSlot(slotIndex, this.npcMode);
                }
                // 工作模式
                if (posChar.equalsIgnoreCase("Y")) {
                    NPCWorkMode currentWorkMode = this.npcEntity.getWorkMode();
                    this.npcWorkMode = new GuiElementBuilder()
                            .setItem(currentWorkMode.getItemDisplay())
                            .setItemName(class_2561.method_43471("gui.npc.work.mode"))
                            .setLore(List.of
                                    (
                                            this.npcEntity.getNpcState().getTranslateText()
                                    )
                            ).setCallback((index, type, action) -> {
                                this.npcEntity.setWorkMode(type.isRight ? this.npcEntity.getWorkMode().getPrevious() : this.npcEntity.getWorkMode().getNext());
                                this.player.playNotifySound(SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                            });
                    this.builder2index.put(this.npcWorkMode, slotIndex);
                    this.setSlot(slotIndex, this.npcWorkMode);
                }
                if (posChar.equalsIgnoreCase("U")) {
                    this.npcXp = new GuiElementBuilder()
                            .setItem(class_1802.field_8287)
                            .setItemName(class_2561.method_43469("gui.npc.info.xp", this.npcEntity.getStoredExperience()))
                            .setLore(List.of(
                                    class_2561.method_43471("gui.npc.info.xp.button")
                            ))
                            .setCallback((index, type, action) -> {
                                int experienceAmount = this.npcEntity.getStoredExperience();
                                if (experienceAmount > 0) {
                                    this.player.playNotifySound(SoundEvents.EXPERIENCE_ORB_PICKUP, SoundSource.PLAYERS, 1.0f, 1.0f);
                                }
                                this.player.giveExperiencePoints(experienceAmount);
                                this.npcEntity.setStoredExperience(0);
                                this.player.playNotifySound(SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                            });
                    this.builder2index.put(this.npcXp, slotIndex);
                    this.setSlot(slotIndex, this.npcXp);
                }
                if (posChar.equalsIgnoreCase("O")) {
                    this.npcAutoPick = new GuiElementBuilder()
                            .setItem(class_1802.field_22021)
                            .setName(class_2561.method_43471("gui.npc.info.auto-pick"))
                            .setComponent(class_9334.field_49641, this.npcEntity.isAutoPick())
                            .setCallback((index, type, action) -> {
                                this.npcEntity.setAutoPick(!this.npcEntity.isAutoPick());
                                this.player.playNotifySound(SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                            });
                    this.builder2index.put(this.npcAutoPick, slotIndex);
                    this.setSlot(slotIndex, this.npcAutoPick);
                }

                if (posChar.equalsIgnoreCase("I")) {
                    this.setSlotRedirect(
                            slotIndex,
                            new class_1735(this.npcEntity.getInventory(), inventory_index, 0, 0)
                    );
                    inventory_index++;
                }
                if (posChar.equalsIgnoreCase("/")) {
                    this.setSlotRedirect(
                            slotIndex,
                            new class_9692(this.npcEntity.getInventory(), this.npcEntity, class_1304.field_6169, NPCInventoryImpl.HEAD, 0, 0, class_1723.field_21669)
                    );
                    inventory_index++;
                }
                if (posChar.equalsIgnoreCase("*")) {
                    this.setSlotRedirect(
                            slotIndex,
                            new class_9692(this.npcEntity.getInventory(), this.npcEntity, class_1304.field_6174, NPCInventoryImpl.CHEST, 0, 0, class_1723.field_21670)
                    );
                    inventory_index++;
                }

                if (posChar.equalsIgnoreCase("-")) {
                    this.setSlotRedirect(
                            slotIndex,
                            new class_9692(this.npcEntity.getInventory(), this.npcEntity, class_1304.field_6172, NPCInventoryImpl.LEGS, 0, 0, class_1723.field_21671)
                    );
                    inventory_index++;
                }
                if (posChar.equalsIgnoreCase("+")) {
                    this.setSlotRedirect(
                            slotIndex,
                            new class_9692(this.npcEntity.getInventory(), this.npcEntity, class_1304.field_6166, NPCInventoryImpl.FEET, 0, 0, class_1723.field_21672)
                    );
                    inventory_index++;
                }
            }
        }
    }

    public class_2561 getRoleName() {
        return this.npcEntity.method_16914() ? this.npcEntity.method_5797() : this.npcEntity.method_5477();
    }

    @Override
    public void onTick() {
        super.onTick();
        this.npcName.setItemName(class_2561.method_43469("gui.npc.info.name", getRoleName().getString()));
        this.npcFood.setItemName(class_2561.method_43471("gui.npc.info.food"));
        this.npcFood.setLore(
                List.of(
                        class_2561.method_43469("gui.npc.info.food.nutrition", this.npcEntity.getNutrition() + " / 20.0"),
                        class_2561.method_43469("gui.npc.info.food.saturation", this.npcEntity.getSaturation() + " / 20.0")
                )
        );
        this.npcHealth.setItemName(class_2561.method_43469("gui.npc.info.health", this.npcEntity.method_6032(), this.npcEntity.method_6063()));
        this.npcArmor.setItemName(class_2561.method_43469("gui.npc.info.armor", this.npcEntity.method_6096()));
        class_2338 workingPos = this.npcEntity.getWorkingPos();
        this.npcMode.setLore(List.of
                (
                        this.npcEntity.getNpcState().getTranslateText(),
                        this.npcEntity.getNpcState() == NPCStates.WORKING ? class_2561.method_43471("gui.npc.mode.work.originpos").method_27693(" : (" + workingPos.method_10263() + " " + workingPos.method_10264() + " " + workingPos.method_10260() + ")") : class_2561.method_30163("")
                )
        );
        NPCWorkMode currentWorkMode = this.npcEntity.getWorkMode();
        this.npcWorkMode.setItem(currentWorkMode.getItemDisplay());
        this.npcWorkMode.setLore(List.of
                (
                        this.npcEntity.getWorkMode().translationKey()
                )
        );

        this.npcXp.setItemName(class_2561.method_43469("gui.npc.info.xp", this.npcEntity.getStoredExperience()));
        this.npcAutoPick.setItem(class_1802.field_22021);
        this.npcAutoPick.setItemName(class_2561.method_43471("gui.npc.info.auto-pick"));
        this.npcAutoPick.setComponent(class_9334.field_49641, this.npcEntity.isAutoPick());
        //        System.out.println( this.npcEntity.getNpcState().getId());
        this.builder2index.forEach((builder, index) -> {
            this.setSlot(index, builder);
        });

    }

    @Override
    public void onOpen() {
        super.onOpen();
        this.npcEntity.setPaused(true);
    }

    @Override
    public void onClose() {
        super.onClose();
        this.npcEntity.setPaused(false);
    }

    public static int size() {
        return NPCInventoryImpl.MAX_SIZE;
    }
}
