package cc.thonly.reverie_dreams.gui.recipe;

import cc.thonly.reverie_dreams.gui.BasePageGui;
import cc.thonly.reverie_dreams.gui.PlayerHeadInfo;
import cc.thonly.reverie_dreams.gui.RecipeTypeCategoryManager;
import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3917;

public class RecipeTypeCategoryGui extends SimpleGui {
    public static final String[][] GRID = {
            {"X", "X", "X", "X", "X", "X", "X", "X", "X"},
            {"X", "X", "X", "X", "X", "X", "X", "X", "X"},
            {"X", "X", "X", "X", "X", "X", "X", "X", "X"},
            {"X", "X", "X", "X", "X", "X", "X", "X", "X"},
            {"X", "X", "X", "X", "X", "X", "X", "X", "X"},
            {"P", "W", "W", "W", "W", "W", "W", "W", "N"},
    };
    public static final int PER_PAGE_SIZE = 5 * 9;

    public final List<GuiElementBuilder> recipeElements = new LinkedList<>();
    public final GuiElementBuilder next = new GuiElementBuilder().setItem(class_1802.field_8575).setSkullOwner(PlayerHeadInfo.GUI_NEXT_PAGE).setItemName(class_2561.method_30163("Next Page")).setCallback(this::next);
    public final GuiElementBuilder prev = new GuiElementBuilder().setItem(class_1802.field_8575).setSkullOwner(PlayerHeadInfo.GUI_PREVIOUS_PAGE).setItemName(class_2561.method_30163("Prev Page")).setCallback(this::prev);
    public int page = 0;

    public RecipeTypeCategoryGui(class_3222 player) {
        super(class_3917.field_17327, player, false);
        this.init();
    }

    public RecipeTypeCategoryGui(class_3222 player, int page) {
        this(player);
        this.page = page;
    }

    public static RecipeTypeCategoryGui create(class_3222 player) {
        RecipeTypeCategoryGui recipeTypeCategoryGui = new RecipeTypeCategoryGui(player);
        recipeTypeCategoryGui.open();
        return recipeTypeCategoryGui;
    }

    public void init() {
        for (int row = 0; row < GRID.length; row++) {
            for (int col = 0; col < GRID[row].length; col++) {
                String c = GRID[row][col];
                int slot = row * 9 + col;
                if (c.equalsIgnoreCase("X")) {
                    GuiElementBuilder builder = new GuiElementBuilder().setItem(class_1802.field_8162);
                    builder.setCallback(this::clickIcon);
                    this.recipeElements.add(builder);
                    this.setSlot(slot, builder);
                }
                if (c.equalsIgnoreCase("N")) {
                    this.setSlot(slot, this.next);
                }
                if (c.equalsIgnoreCase("P")) {
                    this.setSlot(slot, this.prev);
                }
                if (c.equalsIgnoreCase("W")) {
                    this.setSlot(slot, new GuiElementBuilder().setItem(class_1802.field_8736));
                }
            }
        }
    }

    public void clickIcon(int index, ClickType clickType, net.minecraft.class_1713 action) {
        int iconIndex = this.page * PER_PAGE_SIZE + index;
        if (RecipeTypeCategoryManager.CATEGORY_ENTRIES.size() > iconIndex) {
            RecipeTypeGuiInfo<? extends BasePageGui> info = RecipeTypeCategoryManager.CATEGORY_ENTRIES.get(iconIndex);
        }
    }

    public void next(int index, ClickType clickType, net.minecraft.class_1713 action) {
        this.player.method_17356(class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);
        if (this.page < getMaxPage()) {
            this.page++;
        }
    }

    public void prev(int index, ClickType clickType, net.minecraft.class_1713 action) {
        this.player.method_17356(class_3417.field_15015.comp_349(), class_3419.field_15248, 1.0f, 1.0f);

        if (this.page > getMinPage()) {
            this.page--;
        }
    }

    public int getMinPage() {
        return 0;
    }

    public int getMaxPage() {
        return Math.max(0, (this.recipeElements.size() - 1) / PER_PAGE_SIZE);
    }

    @Override
    public void onTick() {
        super.onTick();
        this.setTitle(class_2561.method_30163("Recipes Manager" + " " + "(" + (this.page + 1) + "/" + (getMaxPage() + 1) + ")"));

        int start = this.page * PER_PAGE_SIZE;

        for (int i = 0; i < PER_PAGE_SIZE; i++) {
            int slotIndex = i;
            int recipeIndex = start + i;

            if (recipeIndex < RecipeTypeCategoryManager.CATEGORY_ENTRIES.size()) {
                RecipeTypeGuiInfo<? extends BasePageGui> recipeTypeGuiInfo = RecipeTypeCategoryManager.CATEGORY_ENTRIES.get(recipeIndex + this.page * PER_PAGE_SIZE);
                GuiElementBuilder icon = new GuiElementBuilder()
                        .setItem(recipeTypeGuiInfo.getIcon().getItem())
                        .setItemName(class_2561.method_43471(recipeTypeGuiInfo.getId().toLanguageKey()))
                        .setLore(List.of())
                        .setCallback((slot, click, action) -> {
                            this.close();
                            this.player.playNotifySound(SoundEvents.UI_BUTTON_CLICK.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                            recipeTypeGuiInfo.create(player, () -> new RecipeTypeCategoryGui(player, this.page));
                        });
                this.setSlot(getGridSlot(slotIndex), icon);
            } else {
                this.setSlot(getGridSlot(slotIndex), new GuiElementBuilder().setItem(class_1802.field_8162));
            }
        }
    }

    private int getGridSlot(int index) {
        int count = 0;
        for (int row = 0; row < GRID.length; row++) {
            for (int col = 0; col < GRID[row].length; col++) {
                if (GRID[row][col].equalsIgnoreCase("X")) {
                    if (count == index) {
                        return row * 9 + col;
                    }
                    count++;
                }
            }
        }
        return -1;
    }

}
