package cc.thonly.reverie_dreams.gui.recipe;

import cc.thonly.reverie_dreams.gui.BasePageGui;
import cc.thonly.reverie_dreams.gui.recipe.display.DisplayView;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import java.lang.reflect.Constructor;

@AllArgsConstructor
@Getter
@Slf4j
public class RecipeTypeGuiInfo<T extends BasePageGui> {
    private final class_1799 icon;
    private final class_2960 id;
    private final Class<T> clazz;
    private final Class<? extends DisplayView> viewClazz;
    private final RecipeTypeGetter registryGetter;
    private final GuiStackBuilder getter;

    public T create(class_3222 player, GuiOpeningPrevCallback callback) {
        T result = null;
        try {
            Constructor<T> constructor = this.clazz.getConstructor(class_3222.class, RecipeTypeGuiInfo.class, RecipeTypeInfo.class, GuiOpeningPrevCallback.class);
            T gui = constructor.newInstance(player, this, new RecipeTypeInfo(this.id.method_42094(), this.registryGetter.get(), this.getter), callback);
            gui.open();
            result = gui;
        } catch (Exception exception) {
            log.error("Can't open gui", exception);
        }
        return result;
    }

    public T newInstance(class_3222 player, GuiOpeningPrevCallback callback) {
        T result = null;
        try {
            Constructor<T> constructor = this.clazz.getConstructor(class_3222.class, RecipeTypeGuiInfo.class, RecipeTypeInfo.class, GuiOpeningPrevCallback.class);
            result = constructor.newInstance(player, this, new RecipeTypeInfo(this.id.method_42094(), this.registryGetter.get(), this.getter), callback);
        } catch (Exception exception) {
            log.error("Can't open gui", exception);
        }
        return result;
    }

}
