package cc.thonly.reverie_dreams.gui.recipe.gui;

import cc.thonly.reverie_dreams.registry.content.block.RDBlocks;
import cc.thonly.reverie_dreams.block.entity.StrengthenTableBlockEntity;
import cc.thonly.reverie_dreams.gui.GuiCommon;
import cc.thonly.reverie_dreams.interfaces.IGuiElementBuilderAccessor;
import cc.thonly.reverie_dreams.recipe.ItemStackWrapper;
import cc.thonly.reverie_dreams.recipe.RecipeManager;
import cc.thonly.reverie_dreams.recipe.entry.StrengthTableRecipe;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.gui.AnvilInputGui;
import lombok.Getter;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import java.util.List;

@Getter
public class StrengthTableGui extends AnvilInputGui implements GuiCommon {
    StrengthenTableBlockEntity blockEntity;
    GuiElementBuilder output;
    String inputText = "";

    public StrengthTableGui(class_3222 player, StrengthenTableBlockEntity blockEntity, boolean manipulatePlayerSlots) {
        super(player, manipulatePlayerSlots);
        this.blockEntity = blockEntity;
        this.init();
    }

    public void init() {
        this.setSlotRedirect(0, new class_1735(this.blockEntity.getInventory(), 0, 0, 0));
        this.setSlotRedirect(1, new class_1735(this.blockEntity.getInventory(), 1, 0, 0));
        this.output = new GuiElementBuilder()
                .setItem(class_1802.field_8162)
                .setCallback((index, type, action) -> click()
                );
        this.setSlot(2, this.output);
    }

    @Override
    public void onTick() {
        super.onTick();
        if (this.blockEntity == null) return;
        if (this.blockEntity.method_10997() != null && this.blockEntity.method_10997().method_8320(this.blockEntity.method_11016()).method_26204() != RDBlocks.STRENGTH_TABLE) {
            this.close();
        }
//        this.inputText = this.getInput();
        class_1799 mainStack = this.blockEntity.getInventory().getItem(0).copy();
        class_1799 offStack = this.blockEntity.getInventory().getItem(1).copy();
        ItemStackWrapper mainSlot = new ItemStackWrapper(mainStack);
        ItemStackWrapper offSlot = new ItemStackWrapper(offStack);
        List<StrengthTableRecipe> entries = RecipeManager.STRENGTH_TABLE.getMatches(List.of(mainSlot, offSlot));
        if (entries.isEmpty()) {
            return;
        }
        StrengthTableRecipe entry = entries.getFirst();
        if (entry != null) {
            ItemStackWrapper outputItemWrapper = entry.getOutput();
            this.output = new GuiElementBuilder()
                    .setCallback((index, type, action) -> click());
            IGuiElementBuilderAccessor outputAccessor = (IGuiElementBuilderAccessor) this.output;
            outputAccessor.setItemStack(outputItemWrapper.getItemStack().copy());
        } else {
            this.output = new GuiElementBuilder().setItem(class_1802.field_8162);
        }
        this.setSlot(2, this.output);
    }

    public void click() {
        if (this.blockEntity == null) return;
        class_1799 mainStack = this.blockEntity.getInventory().getItem(0);
        class_1799 offStack = this.blockEntity.getInventory().getItem(1);
        ItemStackWrapper mainSlot = new ItemStackWrapper(mainStack);
        ItemStackWrapper offSlot = new ItemStackWrapper(offStack);
        List<StrengthTableRecipe> entries = RecipeManager.STRENGTH_TABLE.getMatches(List.of(mainSlot, offSlot));
        if (entries.isEmpty()) {
            return;
        }
        StrengthTableRecipe entry = entries.getFirst();
        if (entry != null) {
            ItemStackWrapper mainItem = entry.getMainItem();
            ItemStackWrapper offItem = entry.getOffItem();
            ItemStackWrapper resultItem = entry.getOutput();

            this.blockEntity.getInventory().removeItem(0, mainItem.getCount());
            this.blockEntity.getInventory().removeItem(1, offItem.getCount());
            class_1799 itemStack = resultItem.getItemStack().copy();
//            itemStack.set(DataComponentTypes.CUSTOM_NAME, Text.literal(this.inputText));
            this.player.method_7270(itemStack);
        } else {
            this.output.setItem(class_1802.field_8162);
        }
        this.player.method_17356(class_3417.field_14559, class_3419.field_15245, 1.0f, 1.0f);
    }

    @Override
    public void onOpen() {
        super.onOpen();
    }

    @Override
    public void onClose() {
        super.onClose();
        this.blockEntity.method_5431();
    }


}
