package cc.thonly.reverie_dreams.inventory;

import lombok.Getter;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1799;
import javax.annotation.Nonnull;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;

@Getter
public class NPCInventoryImpl extends class_1277 {
    public static final int MAX_SIZE = 24;
    public static final int HEAD = 18;
    public static final int CHEST = 19;
    public static final int LEGS = 20;
    public static final int FEET = 21;
    public static final int MAIN_HAND = 22;
    public static final int OFF_HAND = 23;

    public NPCInventoryImpl(int size) {
        super(size);
        init();
    }

    public NPCInventoryImpl(class_1799... items) {
        super(items);
        init();
    }

    protected void init() {

    }

    public class_1799 getHand(class_1268 hand) {
        if (hand == class_1268.field_5808) {
            return getMainHand();
        } else if (hand == class_1268.field_5810) {
            return getOffHand();
        }
        return class_1799.field_8037;
    }

    public class_1799 getMainHand() {
        return this.method_5438(MAIN_HAND);
    }

    public class_1799 getOffHand() {
        return this.method_5438(OFF_HAND);
    }

    public class_1799 getHead() {
        return this.method_5438(HEAD);
    }

    public class_1799 getChest() {
        return this.method_5438(CHEST);
    }

    public class_1799 getLegs() {
        return this.method_5438(LEGS);
    }

    public class_1799 getFeet() {
        return this.method_5438(FEET);
    }

    public void setHand(class_1268 hand, class_1799 stack) {
        if (hand == class_1268.field_5808) {
            setMainHand(stack);
        } else if (hand == class_1268.field_5810) {
            setOffHand(stack);
        }
    }

    public void setMainHand(class_1799 stack) {
        this.method_5447(MAIN_HAND, stack.method_7972());
    }

    public void setOffHand(class_1799 stack) {
        this.method_5447(OFF_HAND, stack.method_7972());
    }

    public void setHead(class_1799 stack) {
        this.method_5447(HEAD, stack.method_7972());
    }

    public void setChest(class_1799 stack) {
        this.method_5447(CHEST, stack.method_7972());
    }

    public void setLegs(class_1799 stack) {
        this.method_5447(LEGS, stack.method_7972());
    }

    public void setFeet(class_1799 stack) {
        this.method_5447(FEET, stack.method_7972());
    }

    public boolean isArmorSlot(int slot) {
        return HEAD == slot || CHEST == slot || LEGS == slot || FEET == slot;
    }

    @Override
    public boolean method_27070(class_1799 stack) {
        return super.method_27070(stack);
    }

    public int insertStack(class_1799 stack) {
        if (stack.method_7960()) return 0;
        int remaining = stack.method_7947();
        int inserted = 0;

        for (int i = 0; i < this.field_5828.size(); i++) {
            if (this.isArmorSlot(i)) {
                continue;
            }
            class_1799 slot = this.field_5828.get(i);
            if (slot.method_7960()) {
                int toInsert = Math.min(remaining, stack.method_7914());
                this.field_5828.set(i, stack.method_7972());
                this.field_5828.get(i).method_7939(toInsert);
                inserted += toInsert;
                remaining -= toInsert;
            } else if (class_1799.method_31577(slot, stack) && slot.method_7947() < slot.method_7914()) {
                int space = slot.method_7914() - slot.method_7947();
                int toInsert = Math.min(remaining, space);
                slot.method_7933(toInsert);
                inserted += toInsert;
                remaining -= toInsert;
            }
            if (remaining <= 0) break;
        }

        stack.method_7934(inserted);
        return inserted;
    }

    @Nonnull
    public List<Integer> findItemSlots(int maxLength, Predicate<class_1799> isGood, Predicate<Integer> isExcludeIndex) {
        List<Integer> itemSlots = new LinkedList<>();
        for (int i = MAX_SIZE - 1; i >= 0; i--) {
            if (itemSlots.size() >= maxLength) break;
            class_1799 stack = this.method_5438(i);
            if ((!stack.method_7960()) && (!isExcludeIndex.test(i)) && isGood.test(stack))
                itemSlots.add(i);
        }
        return itemSlots;
    }

    public Integer findSlot(Predicate<class_1799> isGood) {
        List<Integer> slots = findItemSlots(1, isGood, (i) -> i >= 18 && i <= 21);
        return slots.isEmpty() ? null : slots.getFirst();
    }

    public Integer findHand(Predicate<class_1799> isGood) {
        return isGood.test(method_5438(23))
                ? Integer.valueOf(23) : isGood.test(method_5438(22)) ? 22 : null;
    }
}
