package cc.thonly.reverie_dreams.item.prop;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.registry.content.component.RDDataComponentTypes;
import cc.thonly.reverie_dreams.entity.npc.NPCRoleEntity;
import cc.thonly.reverie_dreams.registry.content.NPCWorkModes;
import cc.thonly.reverie_dreams.util.TouhouNotaUtils;
import com.mojang.serialization.Codec;
import net.fabricmc.fabric.api.event.player.AttackBlockCallback;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2766;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3542;
import java.util.List;

public class MusicalInstrumentItem extends class_1792 {
    public static final Codec<class_2766> NOTE_BLOCK_INSTRUMENT_CODEC = class_3542.method_28140(class_2766::values);
    public static final class_2338 NONE = new class_2338(0, 0, 0);
    public static final AttackBlockCallback BLOCK_CALLBACK = (player, world, hand, blockPos, direction) -> {
        if (!world.method_8608() && world instanceof class_3218 serverWorld) {
            class_1799 mainStack = player.method_6047();
            class_1799 offStack = player.method_6079();
            class_1799 stack = null;

            if (mainStack.method_7909() instanceof MusicalInstrumentItem) {
                stack = mainStack;
            } else if (offStack.method_7909() instanceof MusicalInstrumentItem) {
                stack = offStack;
            }

            if (stack != null && !player.method_7325() && player.method_5715()) {
                List<String> fileNames = TouhouNotaUtils.getFileNames();
                if (fileNames.isEmpty()) {
                    player.method_7353(class_2561.method_43471("item.reverie_dreams.music.no_files"), false);
                    return class_1269.field_5812;
                }

                String playingMusic = stack.method_58695(RDDataComponentTypes.PLAYING_MUSIC, null);
                int index = playingMusic == null ? -1 : fileNames.indexOf(playingMusic);
                index = (index - 1 + fileNames.size()) % fileNames.size(); // 向上翻页

                String previous = fileNames.get(index);
                stack.method_57379(RDDataComponentTypes.PLAYING_MUSIC, previous);
                player.method_7353(class_2561.method_43469("item.reverie_dreams.music.switch_music", previous), false);
                player.method_6104(hand);

                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    };

    static {
        AttackBlockCallback.EVENT.register(BLOCK_CALLBACK);
        AttackEntityCallback.EVENT.register((player, world, hand, entity, result) -> BLOCK_CALLBACK.interact(player, world, hand, NONE, player.method_5755()));
    }

    public MusicalInstrumentItem(class_1793 settings) {
        super(settings);
    }

    public class_1269 useByEntity(class_1937 world, class_1309 user, class_1268 hand) {
        boolean isSneaking = user.method_5715();
        class_1799 itemStack = user.method_5998(hand);
        List<String> fileNames = TouhouNotaUtils.getFileNames();
        if (fileNames.isEmpty()) {
            if (user instanceof class_3222 player) {
                player.method_7353(class_2561.method_43471("item.reverie_dreams.music.no_files"), false);
            }
            return class_1269.field_5814;
        }

        String playingMusic = itemStack.method_58695(RDDataComponentTypes.PLAYING_MUSIC, null);
        class_2766 noteBlockInstrument = itemStack.method_58695(RDDataComponentTypes.NOTE_TYPE, class_2766.field_18289);

        if (isSneaking) {
            int index = playingMusic == null ? -1 : fileNames.indexOf(playingMusic);
            index = (index + 1) % fileNames.size();
            String next = fileNames.get(index);
            itemStack.method_57379(RDDataComponentTypes.PLAYING_MUSIC, next);
            if (user instanceof class_3222 player) {
                player.method_7353(class_2561.method_43469("item.reverie_dreams.music.switch_music", next), false);
            }
        } else {
            if (playingMusic == null) {
                if (user instanceof class_3222 player) {
                    player.method_7353(class_2561.method_43471("item.reverie_dreams.music.no_music_selected"), false);
                }
           } else {
                TouhouNotaUtils.play(user, playingMusic, noteBlockInstrument);
                if (user instanceof class_3222 player && ReverieDreams.getServer() != null) {
                    player.method_7353(class_2561.method_43469("item.reverie_dreams.music.playing_music", playingMusic, noteBlockInstrument.method_15434()), false);
                    ReverieDreams.getServer().method_40000(()-> {
                        class_238 box = player.method_5829().method_1014(TouhouNotaUtils.MAX_DISTANCE);
                        List<NPCRoleEntity> entities = world.method_8390(
                                NPCRoleEntity.class,
                                box,
                                e -> e.method_5805() && e.method_6171(player) && e.getWorkMode() == NPCWorkModes.PLAYING_MUSIC
                        );
                        for (NPCRoleEntity e : entities) {
                            class_1799 mainHandStack = e.method_6047();
                            class_1799 offHandStack = e.method_6079();
                            if (mainHandStack.method_7909() instanceof MusicalInstrumentItem) {
                                mainHandStack.method_57379(RDDataComponentTypes.PLAYING_MUSIC, playingMusic);
                                this.useByEntity(world, e, class_1268.field_5808);
                            } else if (offHandStack.method_7909() instanceof MusicalInstrumentItem) {
                                offHandStack.method_57379(RDDataComponentTypes.PLAYING_MUSIC, playingMusic);
                                this.useByEntity(world, e, class_1268.field_5810);
                            }
                        }
                    });
                }
            }
        }
        user.method_6104(hand);
        return class_1269.field_52422;
    }

    @Override
    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (!world.field_9236) {
            return this.useByEntity(world, user , hand);
        }
        return super.method_7836(world, user, hand);
    }
}
