package cc.thonly.reverie_dreams.mixin;


import cc.thonly.reverie_dreams.test.AsyncCountdown;
import com.mojang.serialization.Codec;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import org.spongepowered.asm.mixin.*;
import org.spongepowered.asm.mixin.gen.Invoker;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import net.minecraft.class_3902;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import net.minecraft.class_9326;
import net.minecraft.class_9331;

@Mixin(class_9326.class)
@SuppressWarnings({"unchecked", "rawtypes"})
public class ComponentChangesMixin {

    @Shadow
    @Final
    @Mutable
    public static Codec<class_9326> CODEC;

    @Shadow
    @Final
    @Mutable
    public static class_9139<class_9129, class_9326> STREAM_CODEC;

    @Shadow
    @Final
    @Mutable
    public static class_9139<class_9129, class_9326> DELIMITED_STREAM_CODEC;

    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();


    @Inject(method = "<clinit>", at = @At("TAIL"))
    private static void onClinit(CallbackInfo ci) {
        System.out.println("除错模式: 重定向Codec > ComponentChanges");
        AsyncCountdown countdown = new AsyncCountdown();
        countdown.startCountdown(2,
                (remaining) -> System.out.println("剩余秒数: " + remaining),
                () -> {
                    System.out.println(111);
                    CODEC = makeFixedCodec();
                    DELIMITED_STREAM_CODEC = new class_9139<class_9129, class_9326>() {
                        public class_9326 decode(class_9129 registryByteBuf) {
                            int i = registryByteBuf.method_10816();
                            int j = registryByteBuf.method_10816();
                            if (i == 0 && j == 0) {
                                return class_9326.field_49588;
                            } else {
                                int k = i + j;
                                Reference2ObjectMap<class_9331<?>, Optional<?>> reference2ObjectMap = new Reference2ObjectArrayMap<>(Math.min(k, 65536));

                                int l;
                                class_9331 componentType;
                                for(l = 0; l < i; ++l) {
                                    try {
                                        componentType = class_9331.field_49601.decode(registryByteBuf);
                                        System.out.println(componentType);
                                        Object object = componentType.method_57878().decode(registryByteBuf);
                                        System.out.println(object);
                                        reference2ObjectMap.put(componentType, Optional.ofNullable(object));
                                    } catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }

                                for(l = 0; l < j; ++l) {
                                    componentType = class_9331.field_49601.decode(registryByteBuf);
                                    reference2ObjectMap.put(componentType, Optional.empty());
                                }

                                return invokeInit(reference2ObjectMap);
                            }
                        }

                        public void encode(class_9129 registryByteBuf, class_9326 componentChanges) {
                            if (componentChanges.method_57848()) {
                                registryByteBuf.method_10804(0);
                                registryByteBuf.method_10804(0);
                            } else {
                                int i = 0;
                                int j = 0;
                                ObjectIterator var5 = Reference2ObjectMaps.fastIterable(componentChanges.field_49591).iterator();

                                Reference2ObjectMap.Entry block;
                                while(var5.hasNext()) {
                                    block = (Reference2ObjectMap.Entry)var5.next();
                                    if (((Optional)block.getValue()).isPresent()) {
                                        ++i;
                                    } else {
                                        ++j;
                                    }
                                }

                                registryByteBuf.method_10804(i);
                                registryByteBuf.method_10804(j);
                                var5 = Reference2ObjectMaps.fastIterable(componentChanges.field_49591).iterator();

                                while(var5.hasNext()) {
                                    block = (Reference2ObjectMap.Entry)var5.next();
                                    Optional<?> optional = (Optional)block.getValue();
                                    if (optional.isPresent()) {
                                        class_9331<?> componentType = (class_9331)block.getKey();
                                        class_9331.field_49601.encode(registryByteBuf, componentType);
                                        encode(registryByteBuf, componentType, optional.get());
                                    }
                                }

                                var5 = Reference2ObjectMaps.fastIterable(componentChanges.field_49591).iterator();

                                while(var5.hasNext()) {
                                    block = (Reference2ObjectMap.Entry)var5.next();
                                    if (((Optional)block.getValue()).isEmpty()) {
                                        class_9331<?> componentType2 = (class_9331)block.getKey();
                                        class_9331.field_49601.encode(registryByteBuf, componentType2);
                                    }
                                }

                            }
                        }

                        private static <T> void encode(class_9129 buf, class_9331<T> type, Object value) {
                            type.method_57878().encode(buf, (T) value);
                        }
                    };
                });

    }

    @Invoker("<init>")
    static class_9326 invokeInit(Reference2ObjectMap<class_9331<?>, Optional<?>> map) {
        throw new AssertionError(); // 实际调用时 Mixin 会替换
    }

    @Unique
    @SuppressWarnings("unchecked")
    private static Codec<class_9326> makeFixedCodec() {
        Codec<Map<class_9326.class_9328, Object>> baseCodec =
                (Codec<Map<class_9326.class_9328, Object>>) (Object)
                        Codec.dispatchedMap(class_9326.class_9328.field_49594, class_9326.class_9328::method_57856);

        return baseCodec.xmap(
                (changes) -> {
                    if (changes.isEmpty()) {
                        return class_9326.field_49588;
                    } else {
                        Reference2ObjectMap<class_9331<?>, Optional<?>> reference2ObjectMap = new Reference2ObjectArrayMap<>(changes.size());
                        for (Map.Entry<class_9326.class_9328, Object> block : changes.entrySet()) {
                            class_9326.class_9328 type = block.getKey();
                            if (type.comp_2442()) {
                                reference2ObjectMap.put(type.comp_2441(), Optional.empty());
                            } else {
                                if (block.getValue() == null) {
                                    System.out.println(123456789);
                                    System.out.println(class_7923.field_49658.method_10221(type.comp_2441()));
                                }
                                reference2ObjectMap.put(type.comp_2441(), Optional.ofNullable(block.getValue()));
                            }
                        }
                        return invokeInit(reference2ObjectMap);
                    }
                },
                (componentChanges) -> {
                    Reference2ObjectMap<class_9326.class_9328, Object> reference2ObjectMap = new Reference2ObjectArrayMap<>(componentChanges.field_49591.size());
                    for (Map.Entry<class_9331<?>, Optional<?>> block : componentChanges.field_49591.entrySet()) {
                        class_9331<?> componentType = block.getKey();
                        if (!componentType.method_57877()) {
                            Optional<?> optional = block.getValue();
                            if (optional.isPresent()) {
                                reference2ObjectMap.put(new class_9326.class_9328(componentType, false), optional.get());
                            } else {
                                reference2ObjectMap.put(new class_9326.class_9328(componentType, true), class_3902.field_17274);
                            }
                        }
                    }
                    return reference2ObjectMap;
                }
        );
    }


}
