package cc.thonly.reverie_dreams.mixin.registry;

import cc.thonly.reverie_dreams.datafixer.DataFixerContentManager;
import cc.thonly.reverie_dreams.interfaces.SimpleRegistrySetter;
import net.fabricmc.fabric.api.event.registry.FabricRegistry;
import net.minecraft.class_2370;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.Map;

@Mixin(class_2370.class)
public abstract class SimpleRegistryMixin<T> implements SimpleRegistrySetter, class_2385<T> {

    @Shadow
    private boolean frozen;

    @Shadow
    private @Nullable Map<T, class_6880.class_6883<T>> unregisteredIntrusiveHolders;

    @Shadow @Final public Map<class_2960, class_6880.class_6883<T>> byLocation;

    @Shadow @Final public Map<T, class_6880.class_6883<T>> byValue;

    @Override
    public void setFrozen(boolean value) {
        this.frozen = value;
    }

    @Inject(method = "freeze", at = @At("HEAD"))
    public void onFreeze(CallbackInfoReturnable<class_2378<T>> cir) {
        for (Map.Entry<class_2378<?>, Map<class_2960, class_2960>> registryMapEntry : DataFixerContentManager.ENTRIES.entrySet()) {
            class_2378<?> key = registryMapEntry.getKey();
            FabricRegistry fabricRegistry = this;
            if (key.equals(fabricRegistry)) {
                Map<class_2960, class_2960> old2new = registryMapEntry.getValue();
                for (Map.Entry<class_2960, class_2960> old2newEntry : old2new.entrySet()) {
                    class_2960 oldId = old2newEntry.getKey();
                    class_2960 newId = old2newEntry.getValue();
                    this.addAlias(oldId, newId);
                }
            }
        }
    }

//    @Inject(method = "add", at = @At("HEAD"), cancellable = true)
//    public void add(RegistryKey<T> key, T value, RegistryEntryInfo info, CallbackInfoReturnable<RegistryEntry.Reference<T>> cir) {
//        Objects.requireNonNull(key);
//        Objects.requireNonNull(value);
//        if (this.idToEntry.containsKey(key.getValue())) {
//            cir.setReturnValue(this.idToEntry.get(key.getValue()));
//            cir.cancel();
//        }
//        if (this.valueToEntry.containsKey(value)) {
//            cir.setReturnValue(this.idToEntry.get(key.getValue()));
//            cir.cancel();
//        }
//    }

//    @Inject(method = "add", at = @At("HEAD"), cancellable = true)
//    public void add(RegistryKey<T> key, T value, RegistryEntryInfo info, CallbackInfoReturnable<RegistryEntry.Reference<T>> cir) {
//        if(intrusiveValueToEntry == null) {
//            this.intrusiveValueToEntry = new IdentityHashMap<>();
//        }
//    }
//
//    @Inject(method = "createEntry", at = @At("HEAD"), cancellable = true)
//    public void createEntry(T value, CallbackInfoReturnable<RegistryEntry.Reference<T>> cir) {
//        if(intrusiveValueToEntry == null) {
//            this.intrusiveValueToEntry = new IdentityHashMap<>();
//        }
//        cir.setReturnValue(this.intrusiveValueToEntry.computeIfAbsent(value, valuex -> RegistryEntry.Reference.intrusive((net.minecraft.registry.block.RegistryEntryOwner<T>) this, valuex)));
//        cir.cancel();
//    }
}
