package cc.thonly.reverie_dreams.mixin.server;

import cc.thonly.reverie_dreams.server.PlayerInputManager;
import cc.thonly.reverie_dreams.util.PairWrapper;
import net.minecraft.class_2848;
import net.minecraft.class_2851;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_3244.class)
public abstract class ServerPlayNetworkHandlerMixin {
    @Shadow
    public abstract class_3222 getPlayer();

    @Inject(method = "handlePlayerInput", at = @At("TAIL"))
    public void onPlayerInput(class_2851 packet, CallbackInfo ci) {
        class_3222 player = this.getPlayer();
        PlayerInputManager.TICK_PLAYER_QUEUE.add(new PairWrapper<>(player, packet));
    }

    @Inject(method = "handlePlayerCommand", at = @At("TAIL"))
    public void onClientCommand(class_2848 packet, CallbackInfo ci) {
        class_3222 player = this.getPlayer();
        PlayerInputManager.TICK_PLAYER_QUEUE.add(new PairWrapper<>(player, packet));
    }
}
