package cc.thonly.reverie_dreams.recipe;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.minecraft.class_9290;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import java.util.*;
import java.util.function.Supplier;

@SuppressWarnings("MethodDoesntCallSuperMethod")
@Getter
@Setter
@ToString
public class ItemStackWrapper {
    public static final Gson GSON = new Gson();
    public static final Codec<class_1792> ITEM_CODEC_ALLOWING_AIR = Codec.STRING.xmap(
            id -> {
                class_2960 identifier = class_2960.method_12829(id);
                if (identifier == null) {
                    return class_1802.field_8162;
                }
                class_1792 item = class_7923.field_41178.method_63535(identifier);
                if (item == null) {
                    return class_1802.field_8162;
                }
                return item;
            },
            item -> class_7923.field_41178.method_10221(item).toString()
    );
    public static final Codec<class_1799> FLEXIBLE_ITEMSTACK_CODEC = Codec.lazyInitialized(() ->
            RecordCodecBuilder.create(instance -> instance.group(
                    ITEM_CODEC_ALLOWING_AIR.fieldOf("id").forGetter(class_1799::method_7909),
                    Codec.INT.optionalFieldOf("count", 0).forGetter(class_1799::method_7947),
                    class_9326.field_49589.optionalFieldOf("components", class_9326.field_49588)
                            .forGetter(stack -> stack.field_49270.method_57940())
            ).apply(instance, (item, count, components) -> {
                class_1799 stack = new class_1799(item, count);
                stack.field_49270.method_59772(components);
                return stack;
            }))
    );
    public static final Codec<List<class_1799>> LIST_CODEC = ItemStackWrapper.FLEXIBLE_ITEMSTACK_CODEC.listOf();

    public static final ItemStackWrapper EMPTY = new ItemStackWrapper(class_1799.field_8037);
    public static final ItemStackWrapper ERROR = new ItemStackWrapper(createErrorItem());
    public static final Codec<ItemStackWrapper> CODEC =
            FLEXIBLE_ITEMSTACK_CODEC
                    .xmap(ItemStackWrapper::new, ItemStackWrapper::getItemStack)
                    .orElse(EMPTY);

    private final class_1799 itemStack;

    public ItemStackWrapper(class_1799 itemStack) {
        if (itemStack == null) {
            itemStack = class_1799.field_8037;
        }
        this.itemStack = itemStack;
    }

    public boolean isEmpty() {
        return this == EMPTY || this.itemStack.method_7960();
    }

    public static ItemStackWrapper empty() {
        return EMPTY;
    }

    public static ItemStackWrapper error() {
        return ERROR;
    }

    public static ItemStackWrapper of(class_1799 itemStack) {
        return new ItemStackWrapper(itemStack);
    }

    public static ItemStackWrapper of(class_1792 item) {
        return of(new class_1799(item));
    }

    public static ItemStackWrapper of(class_1792 item, int amount) {
        return of(new class_1799(item, amount));
    }

    public static ItemStackWrapper of(class_1792 item, int amount, class_9326 components) {
        return of(new class_1799(class_7923.field_41178.method_47983(item), amount, components));
    }

    public static class_1799 createErrorItem() {
        class_1799 stack = class_1802.field_8446.method_7854();
        stack.method_57379(class_9334.field_54199, class_7923.field_41178.method_10221(class_1802.field_8077));
        stack.method_57379(class_9334.field_50239, class_2561.method_43470("§cError Item"));
        stack.method_57379(class_9334.field_49632, new class_9290(
                new ArrayList<>(List.of(class_2561.method_43470("§cThis item failed to be serialized")))
        ));
        return stack;
    }

    public ItemStackWrapper copy() {
        return this.clone();
    }

    public <T> T get(class_9331<T> type) {
        return this.itemStack.method_58694(type);
    }

    public <T> T getOrCreate(class_9331<T> type, Supplier<T> supplier) {
        T val = this.get(type);
        if (val == null) {
            T newVal = supplier.get();
            this.itemStack.method_57379(type, newVal);
            val = newVal;
        }
        return val;
    }

    public <T> T getOrDefault(class_9331<T> type, T value) {
        return this.itemStack.method_58695(type, value);
    }

    @Override
    public ItemStackWrapper clone() {
        return new ItemStackWrapper(this.itemStack.method_7972());
    }

    public class_1792 getItem() {
        return this.itemStack.method_7909();
    }

    public Integer getCount() {
        return this.itemStack.method_7947();
    }

    public Boolean test(class_1799 other) {
        return class_1799.method_7973(this.itemStack, other);
    }

    public Boolean greaterThan(class_1799 other) {
        if (this.itemStack == other) {
            return true;
        }
        if (this.itemStack.method_7960()) {
            return true;
        }
        if (this.itemStack.method_7909() != other.method_7909()) {
            return false;
        }

        return class_1799.method_31577(this.itemStack, other) && (other.method_7947() >= this.itemStack.method_7947());
    }

    public static ItemStackWrapper findEquivalentKey(Map<ItemStackWrapper, ?> map, ItemStackWrapper key) {
        for (ItemStackWrapper candidate : map.keySet()) {
            if (candidate.test(key.getItemStack())) {
                return candidate;
            }
        }
        return key;
    }


    public boolean matchesAndSufficient(class_1799 other) {
        if (other == null) return false;
        if (!other.method_31574(itemStack.method_7909())) return false;
        if (!Objects.equals(other.field_49270, itemStack.field_49270)) return false;
        return other.method_7947() >= itemStack.method_7947();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (!(obj instanceof ItemStackWrapper other)) return false;
        return class_1799.method_7973(this.itemStack, other.itemStack);
    }

    @Override
    public int hashCode() {
        int result = 17;
        result = 31 * result + class_1792.method_7880(itemStack.method_7909());
        result = 31 * result + (itemStack.method_57353() != null ? itemStack.method_57353().hashCode() : 0);
        result = 31 * result + itemStack.method_7947();
        return result;
    }

    public class_1799 getOrThrow() {
        assert !this.itemStack.method_7960();
        return Optional.of(this.itemStack).get();
    }

    public Optional<class_1799> getOrNullable() {
        return this.itemStack.method_7960() ? Optional.empty() : Optional.of(this.itemStack);
    }

    public static Optional<String> toJson(ItemStackWrapper wrapper, Class<?> empty) {
        return Optional.ofNullable(toJson(wrapper));
    }

    public static String toJson(ItemStackWrapper wrapper) {
        DataResult<JsonElement> dataResult = ItemStackWrapper.CODEC.encodeStart(JsonOps.INSTANCE, wrapper);
        Optional<JsonElement> result = dataResult.result();
        if (result.isPresent()) {
            JsonElement element = result.get();
            return GSON.toJson(element);
        }
        return null;
    }

    public static Optional<ItemStackWrapper> toWrapper(String json) {
        if (json == null || json.isEmpty()) {
            return Optional.empty();
        }
        JsonElement jsonElement = JsonParser.parseString(json);
        Dynamic<JsonElement> input = new Dynamic<>(JsonOps.INSTANCE, jsonElement);
        DataResult<ItemStackWrapper> parse = ItemStackWrapper.CODEC.parse(input);
        return parse.result();
    }


}
