package cc.thonly.reverie_dreams.server;

import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class ArmorAttributeManager {
    public static final ArmorAttributeManager INSTANCE = new ArmorAttributeManager();
    private MinecraftServer server;
    private final List<Entry> entries = new ArrayList<>();

    private ArmorAttributeManager() {
    }

    public static List<Entry> register(ItemStackAction action, class_1792... items) {
        List<Entry> entries = INSTANCE.entries;
        List<Entry> entryList = new ArrayList<>();
        for (class_1792 item : items) {
            Entry entry = new Entry((itemStack) -> itemStack.method_7909() == item, action);
            entryList.add(entry);
            entries.add(entry);
        }
        return entryList;
    }

    public static Entry register(ItemStackAction action, Predicate<class_1799> predicate) {
        List<Entry> entries = INSTANCE.entries;
        var entry = new Entry(predicate, action);
        entries.add(entry);
        return entry;
    }

    public static boolean unregister(Entry entry) {
        return INSTANCE.entries.remove(entry);
    }

    public void onTick() {
        class_3324 playerManager = this.server.method_3760();
        for (class_3222 player : playerManager.method_14571()) {
            if (player.method_14239()) {
                continue;
            }
            class_1799[] itemStacks = {
                    player.method_6118(class_1304.field_6169),
                    player.method_6118(class_1304.field_6174),
                    player.method_6118(class_1304.field_6172),
                    player.method_6118(class_1304.field_6166),
            };
            for (class_1799 itemStack : itemStacks) {
                for (Entry entry : this.entries) {
                    Predicate<class_1799> predicate = entry.predicate();
                    if (predicate.test(itemStack)) {
                        entry.action.apply(player, itemStack);
                    }
                }
            }
        }
    }


    public static synchronized void tick(MinecraftServer server) {
        if (server == null) {
            return;
        }
        INSTANCE.server = server;
        INSTANCE.onTick();
    }

    public record Entry(Predicate<class_1799> predicate, ItemStackAction action) {

    }

    public interface ItemStackAction {
        void apply(class_1309 entity, class_1799 itemStack);
    }
}
