package cc.thonly.reverie_dreams.server;

import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_1874;
import net.minecraft.class_3489;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_6880;
import net.minecraft.class_8786;
import net.minecraft.server.MinecraftServer;
import java.util.HashSet;
import java.util.Set;

public class CookingInputRecipeManager {
    private static final CookingInputRecipeManager INSTANCE = new CookingInputRecipeManager();
    private final Set<class_1792> items = new HashSet<>();
    private final Set<class_1792> smelting = new HashSet<>();
    private final Set<class_1792> blast = new HashSet<>();
    private final Set<class_1792> smoker = new HashSet<>();

    private CookingInputRecipeManager() {
    }

    public static CookingInputRecipeManager getInstance() {
        return INSTANCE;
    }

    public static boolean isFuel(class_1799 itemStack) {
        return itemStack.method_31573(class_3489.field_17487) || itemStack.method_7909() == class_1802.field_17533;
    }

    public void clearItems() {
        this.items.clear();
        this.smelting.clear();
        this.blast.clear();
        this.smoker.clear();
    }

    public void load(MinecraftServer server) {
        this.clearItems();
        class_1863 recipeManager = server.method_3772();
        for (class_8786<?> recipeEntry : recipeManager.method_8126()) {
            class_1860<?> recipe = recipeEntry.comp_1933();
            if (recipe instanceof class_1874 cookingRecipe) {
                class_1856 ingredient = cookingRecipe.method_64720();
                for (class_6880<class_1792> entry : ingredient.field_9019) {
                    class_1792 value = entry.comp_349();
                    this.items.add(value);
                    if (recipe instanceof class_3861) {
                        this.smelting.add(value);
                    }
                    if (recipe instanceof class_3862) {
                        this.smoker.add(value);
                    }
                    if (recipe instanceof class_3859) {
                        this.blast.add(value);
                    }
                }
            }
        }
    }

    public boolean contains(class_1792 item) {
        return this.items.contains(item);
    }

    public boolean isSmelting(class_1792 item) {
        return this.smelting.contains(item);
    }
    public boolean isSmoker(class_1792 item) {
        return this.smoker.contains(item);
    }
    public boolean isBlast(class_1792 item) {
        return this.blast.contains(item);
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public Set<class_1792> items() {
        return new HashSet<>(this.items);
    }
}
