package cc.thonly.reverie_dreams.server;


import cc.thonly.reverie_dreams.util.PairWrapper;
import lombok.Getter;
import net.minecraft.class_10185;
import net.minecraft.class_2596;
import net.minecraft.class_2848;
import net.minecraft.class_2851;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import java.util.*;

@Getter
public class PlayerInputManager {
    private static PlayerInputManager INSTANCE = null;
    public static Stack<PairWrapper<class_3222, class_2596<?>>> TICK_PLAYER_QUEUE = new Stack<>();
    private final List<class_3222> FORWARDS = new ArrayList<>();
    private final List<class_3222> BACKWARDS = new ArrayList<>();
    private final List<class_3222> LEFTS = new ArrayList<>();
    private final List<class_3222> RIGHTS = new ArrayList<>();
    private final List<class_3222> JUMPS = new ArrayList<>();
    private final List<class_3222> SNEAKS = new ArrayList<>();
    private final List<class_3222> SPRINTS = new ArrayList<>();
    private final List<List<class_3222>> LIST = List.of(
            FORWARDS,
            BACKWARDS,
            LEFTS,
            RIGHTS,
            JUMPS,
            SNEAKS,
            SPRINTS
    );
    private final Map<class_3222, class_10185> currentInputs = new HashMap<>();

    private PlayerInputManager() {
    }

    public static void tick(MinecraftServer server) {
        PlayerInputManager inputManager = PlayerInputManager.getInstance();
        inputManager.tickServer(server);
    }

    public synchronized void tickServer(MinecraftServer server) {
        for (List<class_3222> playerEntities : LIST) {
            playerEntities.clear();
        }
        while (!TICK_PLAYER_QUEUE.isEmpty()) {
            PairWrapper<class_3222, class_2596<?>> wrapper = TICK_PLAYER_QUEUE.pop();
            class_3222 player = wrapper.getKey();
            class_2596<?> packet = wrapper.getValue();
            if (packet instanceof class_2851 inputC2SPacket) {
                class_10185 input = inputC2SPacket.comp_3139();
                currentInputs.put(player, input);
                if (input.comp_3159()) {
                    FORWARDS.add(player);
                }
                if (input.comp_3160()) {
                    BACKWARDS.add(player);
                }
                if (input.comp_3161()) {
                    LEFTS.add(player);
                }
                if (input.comp_3162()) {
                    RIGHTS.add(player);
                }
                if (input.comp_3163()) {
                    JUMPS.add(player);
                }
                if (input.comp_3164()) {
                    SNEAKS.add(player);
                }
                if (input.comp_3165()) {
                    SPRINTS.add(player);
                }
            }
            if (packet instanceof class_2848 cCC2SPacket) {
                class_2848.class_2849 mode = cCC2SPacket.method_12365();
//                if (mode.equals(ClientCommandC2SPacket.Mode.PRESS_SHIFT_KEY)) {
//                    SNEAKS.add(entity);
//                }
//                if (mode.equals(ClientCommandC2SPacket.Mode.RELEASE_SHIFT_KEY)) {
//                    SNEAKS.remove(entity);
//                }
                if (player.method_5715()) {
                    SNEAKS.add(player);
                } else {
                    SNEAKS.remove(player);
                }
                if (mode.equals(class_2848.class_2849.field_12981)) {
                    SPRINTS.add(player);
                }
                if (mode.equals(class_2848.class_2849.field_12985)) {
                    SPRINTS.remove(player);
                }
            }
        }
    }

    public static synchronized boolean isKeyPressed(class_3222 player, InputKey key) {
        PlayerInputManager inputManager = PlayerInputManager.getInstance();
        return switch (key) {
            case InputKey.FORWARD -> inputManager.FORWARDS.contains(player);
            case InputKey.BACKWARD -> inputManager.BACKWARDS.contains(player);
            case InputKey.LEFT -> inputManager.LEFTS.contains(player);
            case InputKey.RIGHT -> inputManager.RIGHTS.contains(player);
            case InputKey.JUMP -> inputManager.JUMPS.contains(player);
//            case InputKey.SNEAK -> inputManager.SNEAKS.contains(entity);
            case InputKey.SPRINT -> inputManager.SPRINTS.contains(player);
            default -> false;
        };
    }

    public static synchronized boolean isKeyDown(class_3222 player, InputKey key) {
        PlayerInputManager inputManager = PlayerInputManager.getInstance();
        class_10185 input = inputManager.currentInputs.get(player);
        if (input == null) return false;

        return switch (key) {
            case FORWARD -> input.comp_3159();
            case BACKWARD -> input.comp_3160();
            case LEFT -> input.comp_3161();
            case RIGHT -> input.comp_3162();
            case JUMP -> input.comp_3163();
            case SNEAK -> input.comp_3164();
            case SPRINT -> input.comp_3165();
        };
    }


    public static synchronized PlayerInputManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PlayerInputManager();
        }
        return INSTANCE;
    }

    public synchronized PlayerInputManager reload() {
        return (INSTANCE = new PlayerInputManager());
    }

    public enum InputKey {
        FORWARD(),
        BACKWARD(),
        LEFT(),
        RIGHT(),
        JUMP(),
        SNEAK(),
        SPRINT();

        public static Optional<InputKey> fromString(String str) {
            try {
                return Optional.of(InputKey.valueOf(str.trim().toUpperCase()));
            } catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        }
    }
}
