package cc.thonly.reverie_dreams.server.player;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import lombok.Getter;
import lombok.Setter;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_8824;
import org.jetbrains.annotations.Nullable;

@Setter
@Getter
public class NameComponent implements PlayerComponent<NameComponent> {
    public static final Codec<NameComponent> CODEC = RecordCodecBuilder.create(x -> x.group(
            class_8824.field_46597.optionalFieldOf("Name", class_2561.method_43470("Player")).forGetter(NameComponent::getName),
            Codec.STRING.optionalFieldOf("RealName", "Player").forGetter(NameComponent::getPlayerName)
    ).apply(x, NameComponent::new));
    private class_2561 name;
    @Nullable
    private String playerName;
    private class_3222 player;

    public NameComponent(class_2561 name) {
        this.name = name;
    }

    public NameComponent(class_2561 name, @Nullable String playerName) {
        this(name);
        this.playerName = playerName;
    }

    @Override
    public void onLoad() {
        this.name = this.player.method_5477();
        GameProfile gameProfile = this.player.method_7334();
        this.playerName = gameProfile.getName();
    }

    @Override
    public void setPlayer(class_3222 player) {
        this.player = player;
    }

    @Override
    public Codec<NameComponent> getCodec() {
        return CODEC;
    }

    public static class NameComponentInitializer implements PlayerComponentInitializer<NameComponent> {

        @Override
        public PlayerComponent<NameComponent> create(class_3222 player) {
            return new NameComponent(class_2561.method_43470("Player"));
        }

        @Override
        public Codec<NameComponent> getCodec() {
            return CODEC;
        }
    }
}
