package cc.thonly.reverie_dreams.world.gen;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.registry.content.block.RDWoodBlocks;
import java.util.List;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5450;
import net.minecraft.class_5843;
import net.minecraft.class_5925;
import net.minecraft.class_6792;
import net.minecraft.class_6793;
import net.minecraft.class_6795;
import net.minecraft.class_6796;
import net.minecraft.class_6797;
import net.minecraft.class_6799;
import net.minecraft.class_6817;
import net.minecraft.class_6819;
import net.minecraft.class_7891;
import net.minecraft.class_7924;

public class PlacedFeaturesInit {
    public static final class_5321<class_6796> DREAM_WORLD_GRID_KEY = getOrCreateRegistryKey("dream_world_grid");
    public static final class_5321<class_6796> CRATER_MEGA_KEY = getOrCreateRegistryKey("crater_mega");
    public static final class_5321<class_6796> CRATER_LARGE_KEY = getOrCreateRegistryKey("crater_large");
    public static final class_5321<class_6796> CRATER_SMALL_KEY = getOrCreateRegistryKey("crater_small");
    public static final class_5321<class_6796> FLOATING_DREAM_STONE_KEY = getOrCreateRegistryKey("floating_dream_stone_placed");
    public static final class_5321<class_6796> FLOATING_DREAM_CRYSTAL_KEY = getOrCreateRegistryKey("floating_dream_crystal_placed");
    public static final class_5321<class_6796> FLOATING_DREAM_TRIAL_ROOM_ZOMBIE_KEY = getOrCreateRegistryKey("floating_dream_trial_room_zombie_placed");
    public static final class_5321<class_6796> FLOATING_DREAM_TRIAL_ROOM_SKELETON_KEY = getOrCreateRegistryKey("floating_dream_trial_room_skeleton_placed");
    public static final class_5321<class_6796> DREAM_FLOATING_ISLAND_KEY = getOrCreateRegistryKey("dream_floating_island_placed");

    public static final class_5321<class_6796> SPIRITUAL_TREE_KEY = getOrCreateRegistryKey("spiritual_tree_placed");
    public static final class_5321<class_6796> LEMON_TREE_KEY = getOrCreateRegistryKey("lemon_tree_placed");
    public static final class_5321<class_6796> GINKGO_TREE_KEY = getOrCreateRegistryKey("ginkgo_tree_placed");
    public static final class_5321<class_6796> PEACH_TREE_KEY = getOrCreateRegistryKey("peach_tree_placed");
    public static final class_5321<class_6796> OVERWORLD_SILVER_ORE_KEY = getOrCreateRegistryKey("overworld_silver_ore_placed");
    public static final class_5321<class_6796> OVERWORLD_ORB_ORE_KEY = getOrCreateRegistryKey("overworld_orb_ore_placed");
    public static final class_5321<class_6796> UDUMBARA_FLOWER_KEY = getOrCreateRegistryKey("udumbara_flower_placed");
    public static final class_5321<class_6796> TREMELLA_KEY = getOrCreateRegistryKey("tremella_placed");

    public static final class_5321<class_6796> OUTER_SHRINE = getOrCreateRegistryKey("outer_shrine");

    public static void bootstrap(class_7891<class_6796> context) {
        var registryLookup = context.method_46799(class_7924.field_41239);

        context.method_46838(SPIRITUAL_TREE_KEY, new class_6796(
                registryLookup.method_46747(ConfigurationFeatureInit.SPIRITUAL_TREE_KEY),
                class_6819.method_39741(
                        class_6817.method_39736(0, 0.1f, 1),
                        RDWoodBlocks.SPIRITUAL.sapling()
                )
        ));

        context.method_46838(LEMON_TREE_KEY, new class_6796(
                registryLookup.method_46747(ConfigurationFeatureInit.LEMON_TREE_KEY),
                class_6819.method_39741(
                        class_6817.method_39736(0, 0.2f, 1),
                        RDWoodBlocks.LEMON.sapling()
                )
        ));

        context.method_46838(GINKGO_TREE_KEY, new class_6796(
                registryLookup.method_46747(ConfigurationFeatureInit.GINKGO_TREE_KEY),
                class_6819.method_39741(
                        class_6817.method_39736(0, 0.1f, 1),
                        RDWoodBlocks.GINKGO.sapling()
                )
        ));

        context.method_46838(PEACH_TREE_KEY, new class_6796(
                registryLookup.method_46747(ConfigurationFeatureInit.PEACH_TREE_KEY),
                class_6819.method_39741(
                        class_6817.method_39736(0, 0.1f, 1),
                        RDWoodBlocks.PEACH.sapling()
                )
        ));

        context.method_46838(OVERWORLD_SILVER_ORE_KEY, new class_6796(
                registryLookup.method_46747(ConfigurationFeatureInit.OVERWORLD_SILVER_ORE_KEY),
                Modifiers.modifiersCount(9, class_6795.method_39634(class_5843.method_33846(10), class_5843.method_33849(10)))
        ));

        context.method_46838(OVERWORLD_ORB_ORE_KEY, new class_6796(
                registryLookup.method_46747(ConfigurationFeatureInit.OVERWORLD_ORB_ORE_KEY),
                Modifiers.modifiersCount(7, class_6795.method_39637(class_5843.method_33846(-80), class_5843.method_33846(80)))
        ));

        context.method_46838(UDUMBARA_FLOWER_KEY, new class_6796(
                registryLookup.method_46747(ConfigurationFeatureInit.UDUMBARA_FLOWER_KEY),
                List.of(
                        class_6799.method_39659(5),
                        class_5450.method_39639(),
                        class_6817.field_36078,
                        class_6792.method_39614()
                )
        ));

        context.method_46838(TREMELLA_KEY, new class_6796(
                registryLookup.method_46747(ConfigurationFeatureInit.TREMELLA_KEY),
                List.of(
                        class_6799.method_39659(6),
                        class_5450.method_39639(),
                        class_6817.field_36078,
                        class_6792.method_39614()
                )
        ));

        // 世界生成
        context.method_46838(CRATER_MEGA_KEY, new class_6796(
                registryLookup.method_46747(ConfigurationFeatureInit.CRATER_MEGA_KEY),
                List.of(
                        class_6799.method_39659(256),
                        class_5450.method_39639(),
                        class_6817.field_36086,
                        class_6792.method_39614()
                )
        ));
        context.method_46838(CRATER_LARGE_KEY, new class_6796(
                registryLookup.method_46747(ConfigurationFeatureInit.CRATER_LARGE_KEY),
                List.of(
                        class_6799.method_39659(12),
                        class_5450.method_39639(),
                        class_6817.field_36086,
                        class_6792.method_39614()
                )
        ));
        context.method_46838(CRATER_SMALL_KEY, new class_6796(
                registryLookup.method_46747(ConfigurationFeatureInit.CRATER_SMALL_KEY),
                List.of(
                        class_6799.method_39659(4),
                        class_5450.method_39639(),
                        class_6817.field_36086,
                        class_6792.method_39614()
                )
        ));
        context.method_46838(DREAM_WORLD_GRID_KEY, new class_6796(
                registryLookup.method_46747(ConfigurationFeatureInit.DREAM_GRID_KEY),
                List.of(
                        class_6792.method_39614(),
                        class_5925.method_39638(class_2902.class_2903.field_13202),
                        class_6793.method_39623(1)
                )
        ));

        context.method_46838(FLOATING_DREAM_STONE_KEY, new class_6796(
                registryLookup.method_46747(ConfigurationFeatureInit.FLOATING_DREAM_STONE_KEY),
                List.of(
                        class_6799.method_39659(11),
                        class_5450.method_39639(),
                        class_6795.method_39634(class_5843.method_33841(10), class_5843.method_33841(120)),
                        class_6792.method_39614()
                )
        ));

        context.method_46838(FLOATING_DREAM_CRYSTAL_KEY, new class_6796(
                registryLookup.method_46747(ConfigurationFeatureInit.FLOATING_DREAM_CRYSTAL_KEY),
                List.of(
                        class_6799.method_39659(6),
                        class_5450.method_39639(),
                        class_6795.method_39634(class_5843.method_33841(20), class_5843.method_33841(128)),
                        class_6792.method_39614()
                )
        ));

        context.method_46838(FLOATING_DREAM_TRIAL_ROOM_ZOMBIE_KEY, new class_6796(
                registryLookup.method_46747(ConfigurationFeatureInit.FLOATING_DREAM_TRIAL_ROOM_ZOMBIE_KEY),
                List.of(
                        class_6799.method_39659(110),
                        class_5450.method_39639(),
                        class_6795.method_39634(class_5843.method_33841(50), class_5843.method_33841(200)),
                        class_6792.method_39614()
                )
        ));

        context.method_46838(FLOATING_DREAM_TRIAL_ROOM_SKELETON_KEY, new class_6796(
                registryLookup.method_46747(ConfigurationFeatureInit.FLOATING_DREAM_TRIAL_ROOM_SKELETON_KEY),
                List.of(
                        class_6799.method_39659(110),
                        class_5450.method_39639(),
                        class_6795.method_39634(class_5843.method_33841(50), class_5843.method_33841(200)),
                        class_6792.method_39614()
                )
        ));

        context.method_46838(DREAM_FLOATING_ISLAND_KEY, new class_6796(
                registryLookup.method_46747(ConfigurationFeatureInit.DREAM_FLOATING_ISLAND_KEY),
                List.of(
                        class_6799.method_39659(150),
                        class_6795.method_39634(class_5843.method_33841(40), class_5843.method_33841(180)),
                        class_6792.method_39614()
                )
        ));
    }

    public static void init() {

    }

    public static class_5321<class_6796> getOrCreateRegistryKey(String name) {
        return class_5321.method_29179(class_7924.field_41245, class_2960.method_60655(ReverieDreams.MOD_ID, name));
    }


    public static class Modifiers {
        public static List<class_6797> modifiers(class_6797 countModifier, class_6797 heightModifier) {
            return List.of(countModifier, class_5450.method_39639(), heightModifier, class_6792.method_39614());
        }

        public static List<class_6797> modifiersCount(int count, class_6797 heightModifier) {
            return modifiers(class_6793.method_39623(count), heightModifier);
        }

        public static List<class_6797> modifiersRarity(int chance, class_6797 heightModifier) {
            return modifiers(class_6799.method_39659(chance), heightModifier);
        }
    }
}
