package nota.player;

import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import nota.Nota;
import nota.model.Layer;
import nota.model.Note;
import nota.model.Playlist;
import nota.model.Song;

/**
 * SongPlayer created at a specified BlockPos
 */
public class PositionSongPlayer extends RangeSongPlayer {
	private class_2338 pos;
	class_1937 world;

	public PositionSongPlayer(Song song, class_1937 world) {
		super(song);
		this.world = world;
	}

	public PositionSongPlayer(Playlist playlist, class_1937 world) {
		super(playlist);
		this.world = world;
	}

	/**
	 * Gets location on which is the PositionSongPlayer playing
	 *
	 * @return {@link class_2338}
	 */
	public class_2338 getBlockPos() {
		return this.pos;
	}

	/**
	 * Sets location on which is the PositionSongPlayer playing
	 */
	public void setBlockPos(class_2338 pos) {
		this.pos = pos;
	}

	@Override
	public void playTick(class_1657 player, int tick) {
		if(!player.method_37908().method_27983().equals(world.method_27983())) {
			return; // not in same world
		}

		byte playerVolume = Nota.getPlayerVolume(player);

		for(Layer layer : song.getLayerHashMap().values()) {
			Note note = layer.getNote(tick);
			if(note == null) continue;

			float volume = ((layer.getVolume() * (int) this.volume * (int) playerVolume * note.getVelocity()) / 100_00_00_00F)
					* ((1F / 16F) * getDistance());

			if(isInRange(player)) {
				this.playerList.put(player.method_5667(), true);
				this.channelMode.play(player, pos, song, layer, note, volume, !enable10Octave);
			}
			else {
				this.playerList.put(player.method_5667(), false);
			}
		}
	}

	/**
	 * Returns true if the Player is able to hear the current PositionSongPlayer
	 *
	 * @param player in range
	 * @return ability to hear the current PositionSongPlayer
	 */
	@Override
	public boolean isInRange(class_1657 player) {
		return player.method_24515().method_19771(pos, getDistance());
	}
}
