package nota.utils;

import lombok.extern.slf4j.Slf4j;
import net.minecraft.class_2766;
import nota.model.CustomInstrument;
import nota.model.Layer;
import nota.model.Note;
import nota.model.Song;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.Map;

@Slf4j
public class NBSDecoderPlus extends NBSDecoder {
    private static final Map<class_2766, Byte> instrumentToByteMap = new HashMap<>();

    static {
        instrumentToByteMap.put(class_2766.field_12648, (byte) 0);
        instrumentToByteMap.put(class_2766.field_12651, (byte) 1);
        instrumentToByteMap.put(class_2766.field_12653, (byte) 2);
        instrumentToByteMap.put(class_2766.field_12643, (byte) 3);
        instrumentToByteMap.put(class_2766.field_12645, (byte) 4);
        instrumentToByteMap.put(class_2766.field_12654, (byte) 5);
        instrumentToByteMap.put(class_2766.field_12650, (byte) 6);
        instrumentToByteMap.put(class_2766.field_12644, (byte) 7);
        instrumentToByteMap.put(class_2766.field_12647, (byte) 8);
        instrumentToByteMap.put(class_2766.field_12655, (byte) 9);
        instrumentToByteMap.put(class_2766.field_18284, (byte) 10);
        instrumentToByteMap.put(class_2766.field_18285, (byte) 11);
        instrumentToByteMap.put(class_2766.field_18286, (byte) 12);
        instrumentToByteMap.put(class_2766.field_18287, (byte) 13);
        instrumentToByteMap.put(class_2766.field_18288, (byte) 14);
        instrumentToByteMap.put(class_2766.field_18289, (byte) 15);
    }

    public static Song parse(File songFile, class_2766 instrument) {
        try {
            Song song = parse(new FileInputStream(songFile), songFile);
            if (song == null) {
                log.error("Failed to parse NBS file: {}", songFile.getName());
                return null;
            }
            CustomInstrument[] customInstruments = song.getCustomInstruments();
            for (int i = 0; i < customInstruments.length; i++) {
                customInstruments[i].setSound(instrument.method_11886().comp_349());
            }
            HashMap<Integer, Layer> layerHashMap = song.getLayerHashMap();
            for (var entry : layerHashMap.entrySet()) {
                Layer layer = entry.getValue();
                for (var lay:layer.getNotesAtTicks().entrySet()) {
                    Note note = lay.getValue();
                    note.setInstrument(getByteFromInstrument(instrument));
                }
            }
            return song;
        } catch (FileNotFoundException e) {
            log.error("Failed to parse NBS File: ", e);
        }
        return null;
    }

    public static byte getByteFromInstrument(class_2766 instrument) {
        return instrumentToByteMap.getOrDefault(instrument, (byte) 0); // 默认为 0：HARP
    }

}
