/*
 * Decompiled with CFR 0.152.
 */
package cc.thonly.reverie_dreams.data;

import cc.thonly.reverie_dreams.ReverieDreams;
import cc.thonly.reverie_dreams.data.FoodProperty;
import cc.thonly.reverie_dreams.registry.RegistryHandlers;
import cc.thonly.reverie_dreams.registry.impl.RegistryHandler;
import cc.thonly.reverie_dreams.registry.interfaces.BuiltinObject;
import cc.thonly.reverie_dreams.registry.interfaces.CodecStep;
import cc.thonly.reverie_dreams.registry.interfaces.OwnerBinding;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_7923;

public class CraftingConflict
implements CodecStep<CraftingConflict>,
OwnerBinding<CraftingConflict>,
BuiltinObject {
    public static final Codec<CraftingConflict> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("item").forGetter(entry -> class_7923.field_41178.method_10221((Object)entry.item)), (App)Codec.list((Codec)class_2960.field_25139).fieldOf("values").forGetter(entry -> {
        ArrayList<class_2960> identifiers = new ArrayList<class_2960>();
        for (FoodProperty foodProperty : entry.foodProperties) {
            class_2960 id = foodProperty.getId();
            identifiers.add(id);
        }
        return identifiers;
    })).apply((Applicative)instance, CraftingConflict::new));
    private class_2960 id;
    private final class_1792 item;
    private final Set<FoodProperty> foodProperties = new ObjectOpenHashSet();
    private RegistryHandler<CraftingConflict> owner;

    private CraftingConflict() {
        this.item = class_1802.field_8162;
    }

    public CraftingConflict(class_2960 item, List<class_2960> identifiers) {
        this((class_1792)class_7923.field_41178.method_63535(item), identifiers);
    }

    public CraftingConflict(class_1792 item, List<class_2960> identifiers) {
        this.item = item;
        for (class_2960 identifier : identifiers) {
            FoodProperty property = RegistryHandlers.FOOD_PROPERTY.method_63535(identifier);
            if (property == null) continue;
            this.foodProperties.add(property);
        }
    }

    public static CraftingConflict of(class_1792 item, List<FoodProperty> foodProperties) {
        List<class_2960> list = foodProperties.stream().map(FoodProperty::getId).toList();
        return new CraftingConflict(item, list);
    }

    public boolean test(class_1799 ingredient, FoodProperty property) {
        if (!ingredient.method_7909().equals(this.item)) {
            return false;
        }
        return this.foodProperties.contains(property);
    }

    public boolean test(class_1799 ingredient) {
        if (!ingredient.method_7909().equals(this.item)) {
            return false;
        }
        ArrayList<FoodProperty> properties = new ArrayList<FoodProperty>();
        properties.addAll(FoodProperty.getFromItemStack(ingredient));
        properties.addAll(FoodProperty.getFromItemStackComponent(ingredient));
        for (FoodProperty ingredientProperty : properties) {
            if (!this.foodProperties.contains(ingredientProperty)) continue;
            return true;
        }
        return false;
    }

    public Stream<FoodProperty> stream() {
        return this.foodProperties.stream();
    }

    @Override
    public Codec<CraftingConflict> getCodec() {
        return CODEC;
    }

    public static void reload(class_3300 manager) {
        Map resources = manager.method_14488("crafting_conflict", id -> id.method_12836().equals("reverie_dreams") && id.method_12832().endsWith(".json"));
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 resId = (class_2960)entry.getKey();
            class_2960 id2 = class_2960.method_60655((String)resId.method_12836(), (String)resId.method_12832().replace("crafting_conflict/", "").replace(".json", ""));
            class_3298 resource = (class_3298)entry.getValue();
            try {
                InputStream stream = resource.method_14482();
                try {
                    JsonElement json = JsonParser.parseReader((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8));
                    DataResult result = CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
                    Optional optional = result.result();
                    if (optional.isPresent()) {
                        CraftingConflict conflict = (CraftingConflict)optional.get();
                        conflict.setId(id2);
                        RegistryHandlers.register(RegistryHandlers.CRAFTING_CONFLICT, id2, conflict);
                        continue;
                    }
                    ReverieDreams.LOGGER.error("Failed to parse crafting_conflict {}: {}", (Object)id2, (Object)result.error().map(Object::toString).orElse("Unknown error"));
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                ReverieDreams.LOGGER.error("Failed to load food_property {}: {}", new Object[]{id2, e.getMessage(), e});
            }
        }
    }

    public static void bootstrap(RegistryHandler<CraftingConflict> registry) {
    }

    @Generated
    public String toString() {
        return "CraftingConflict(id=" + String.valueOf(this.getId()) + ", item=" + String.valueOf(this.getItem()) + ", foodProperties=" + String.valueOf(this.foodProperties) + ", owner=" + String.valueOf(this.getOwner()) + ")";
    }

    @Generated
    public void setId(class_2960 id) {
        this.id = id;
    }

    @Generated
    public class_2960 getId() {
        return this.id;
    }

    @Generated
    public class_1792 getItem() {
        return this.item;
    }

    @Override
    @Generated
    public void setOwner(RegistryHandler<CraftingConflict> owner) {
        this.owner = owner;
    }

    @Override
    @Generated
    public RegistryHandler<CraftingConflict> getOwner() {
        return this.owner;
    }
}

